"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
const yargs = require("yargs");
const common_1 = require("../common");
const tasks_1 = require("../tasks");
const synth_1 = require("./synth");
const tasks_2 = require("./tasks");
const DEFAULT_RC = path_1.resolve(common_1.PROJEN_RC);
async function main() {
    const ya = yargs;
    ya.commandDir('cmds');
    const runtime = new tasks_1.TaskRuntime('.');
    tasks_2.discoverTaskCommands(runtime, ya);
    ya.recommendCommands();
    ya.strictCommands();
    ya.showHelpOnFail(false);
    ya.wrap(yargs.terminalWidth());
    ya.option('post', { type: 'boolean', default: true, desc: 'Run post-synthesis steps such as installing dependencies. Use --no-post to skip' });
    ya.option('watch', { type: 'boolean', default: false, desc: 'Keep running and resynthesize when projenrc changes', alias: 'w' });
    ya.options('debug', { type: 'boolean', default: false, desc: 'Debug logs' });
    ya.options('rc', { desc: 'path to .projenrc.js file', default: DEFAULT_RC, type: 'string' });
    ya.completion();
    ya.help();
    // do not use the default yargs '--version' implementation since it is
    // global by default (it appears on all subcommands)
    ya.version(false);
    ya.option('version', { type: 'boolean', description: 'Show version number', global: false });
    const args = ya.argv;
    if (args.debug) {
        process.env.DEBUG = 'true';
    }
    // no command means synthesize
    if (args._.length === 0) {
        if (args.version) {
            console.log(common_1.PROJEN_VERSION);
            process.exit(0);
        }
        await synth_1.synth(runtime, {
            post: args.post,
            watch: args.watch,
            rcfile: args.rc,
        });
    }
}
main().catch(e => {
    console.error(e.stack);
    process.exit(1);
});
//# sourceMappingURL=data:application/json;base64,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