import * as inventory from '../inventory';
import { NewProjectOptionHints } from '../option-hints';
export interface CreateProjectOptions {
    /**
     * Project directory.
     */
    dir: string;
    /**
     * Project type from the inventory.
     */
    type: inventory.ProjectType;
    /**
     * Option values.
     */
    params: Record<string, string>;
    /**
     * Should we render commented-out default options in the projenrc file?
     * Does not apply to projenrc.json files.
     */
    comments: NewProjectOptionHints;
    /**
     * Should we call `project.synth()` or instantiate the project (could still
     * have side-effects) and render the .projenrc file.
     */
    synth: boolean;
    /**
     * Should we execute post synthesis hooks? (usually package manager install).
     */
    post: boolean;
}
/**
 * Creates a new project with defaults.
 *
 * This function creates the project type in-process (with in VM) and calls
 * `.synth()` on it (if `options.synth` is not `false`).
 *
 * At the moment, it also generates a `.projenrc.js` file with the same code
 * that was just executed. In the future, this will also be done by the project
 * type, so we can easily support multiple languages of projenrc.
 */
export declare function createProject(opts: CreateProjectOptions): void;
