import { ConstructLibrary, ConstructLibraryOptions } from './construct-lib';
/**
 * @experimental
 */
export interface ConstructLibraryCdk8sOptions extends ConstructLibraryOptions {
    /**
     * (experimental) Minimum target version this library is tested against.
     *
     * @default "1.0.0-beta.10"
     * @experimental
     * @featured true
     */
    readonly cdk8sVersion: string;
    /**
     * (experimental) constructs verion.
     *
     * @default "3.2.34"
     * @experimental
     */
    readonly constructsVersion?: string;
    /**
     * (experimental) cdk8s-plus-17 version.
     *
     * @default "cdk8sVersion"
     * @experimental
     */
    readonly cdk8sPlusVersion?: string;
    /**
     * (experimental) Use pinned version instead of caret version for CDK8s.
     *
     * You can use this to prevent yarn to mix versions for your CDK8s package and to prevent auto-updates.
     * If you use experimental features this will let you define the moment you include breaking changes.
     *
     * @default false
     * @experimental
     */
    readonly cdk8sVersionPinning?: boolean;
    /**
     * (experimental) Use pinned version instead of caret version for constructs.
     *
     * You can use this to prevent yarn to mix versions for your consructs package and to prevent auto-updates.
     * If you use experimental features this will let you define the moment you include breaking changes.
     *
     * @default false
     * @experimental
     */
    readonly constructsVersionPinning?: boolean;
    /**
     * (experimental) Use pinned version instead of caret version for cdk8s-plus-17.
     *
     * You can use this to prevent yarn to mix versions for your CDK8s package and to prevent auto-updates.
     * If you use experimental features this will let you define the moment you include breaking changes.
     *
     * @default false
     * @experimental
     */
    readonly cdk8sPlusVersionPinning?: boolean;
}
/**
 * (experimental) CDK8s construct library project.
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the CDK for Kubernetes (CDK8s), with a friendly workflow and
 * automatic publishing to the construct catalog.
 *
 * @experimental
 * @pjid cdk8s-construct
 */
export declare class ConstructLibraryCdk8s extends ConstructLibrary {
    /**
     * (experimental) The CDK8s version this app is using.
     *
     * @experimental
     */
    readonly cdk8sVersion: string;
    /**
     * (experimental) The constructs version this app is using.
     *
     * @experimental
     */
    readonly constructsVersion: string;
    /**
     * (experimental) The cdk8s-plus-17 version this app is using.
     *
     * @experimental
     */
    readonly cdk8sPlusVersion: string;
    /**
     * @experimental
     */
    constructor(options: ConstructLibraryCdk8sOptions);
}
