"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructLibraryAws = exports.AwsCdkConstructLibrary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
const construct_lib_1 = require("./construct-lib");
/**
 * (experimental) AWS CDK construct library project.
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the AWS CDK with a friendly workflow and automatic publishing to
 * the construct catalog.
 *
 * ```ts
 * const project = new ConstructLibraryAws({
 *    name: 'cdk-watchful',
 *    description: 'Watching your CDK apps since 2019',
 *    jsiiVersion: Semver.caret('1.7.0'),
 *    authorName: 'Elad Ben-Israel',
 *    authorEmail: 'elad.benisrael@gmail.com',
 *    repository: 'https://github.com/eladb/cdk-watchful.git',
 *    keywords: [
 *      "cloudwatch",
 *      "monitoring"
 *    ],
 *
 *    catalog: {
 *      twitter: 'emeshbi'
 *    },
 *
 *    // creates PRs for projen upgrades
 *    projenUpgradeSecret: 'PROJEN_GITHUB_TOKEN',
 *
 *    cdkVersion: '1.54.0',
 *    cdkDependencies: [
 *      "@aws-cdk/aws-apigateway",
 *      "@aws-cdk/aws-cloudwatch",
 *      "@aws-cdk/aws-cloudwatch-actions",
 *      "@aws-cdk/aws-dynamodb",
 *      "@aws-cdk/aws-ecs",
 *      "@aws-cdk/aws-ecs-patterns",
 *      "@aws-cdk/aws-elasticloadbalancingv2",
 *      "@aws-cdk/aws-events",
 *      "@aws-cdk/aws-events-targets",
 *      "@aws-cdk/aws-lambda",
 *      "@aws-cdk/aws-rds",
 *      "@aws-cdk/aws-sns",
 *      "@aws-cdk/aws-sns-subscriptions",
 *      "@aws-cdk/aws-sqs",
 *      "@aws-cdk/core"
 *    ],
 *    devDependencies: {
 *      "aws-sdk": Semver.caret("2.708.0")
 *    },
 *
 *    // jsii publishing
 *
 *    java: {
 *      javaPackage: 'io.github.cdklabs.watchful',
 *      mavenGroupId: 'io.github.cdklabs',
 *      mavenArtifactId: 'cdk-watchful'
 *    },
 *    python: {
 *      distName: 'cdk-watchful',
 *      module: 'cdk_watchful'
 *    }
 * });
 *
 * project.synth();
 * ```
 *
 * @experimental
 * @pjid awscdk-construct
 */
class AwsCdkConstructLibrary extends construct_lib_1.ConstructLibrary {
    /**
     * @experimental
     */
    constructor(options) {
        var _c, _d, _e, _f, _g, _h;
        super({
            ...options,
            peerDependencyOptions: {
                pinnedDevDependency: false,
            },
        });
        this.cdkVersion = options.cdkVersionPinning ? options.cdkVersion : `^${options.cdkVersion}`;
        this.cdkDependenciesAsDeps = (_c = options.cdkDependenciesAsDeps) !== null && _c !== void 0 ? _c : true;
        const cdkMajorVersion = (_e = (_d = semver.minVersion(this.cdkVersion)) === null || _d === void 0 ? void 0 : _d.major) !== null && _e !== void 0 ? _e : 1;
        if (options.constructsVersion) {
            this.addPeerDeps(`constructs@^${options.constructsVersion}`);
            this.addDevDeps(`constructs@${options.constructsVersion}`);
        }
        else if (cdkMajorVersion === 1) {
            // CDK 1.x is built on constructs 3.x
            this.addPeerDeps('constructs@^3.2.27');
        }
        else if (cdkMajorVersion == 2) {
            // CDK 2.x is built on constructs 10.x
            this.addPeerDeps('constructs@^10.0.5');
        }
        else {
            // Otherwise, let the user manage which version they use
            this.addPeerDeps('constructs');
        }
        if ((_f = options.cdkAssert) !== null && _f !== void 0 ? _f : true) {
            this.addDevDeps(this.formatModuleSpec('@aws-cdk/assert'));
        }
        this.addCdkDependencies(...(_g = options.cdkDependencies) !== null && _g !== void 0 ? _g : []);
        this.addCdkTestDependencies(...(_h = options.cdkTestDependencies) !== null && _h !== void 0 ? _h : []);
    }
    /**
     * @deprecated use `cdkVersion`
     */
    get version() {
        return this.cdkVersion;
    }
    /**
     * (experimental) Adds CDK modules as runtime dependencies.
     *
     * Modules are currently by default added with a caret CDK version both as "dependencies"
     * and "peerDependencies". This is because currently npm would not
     * automatically install peer dependencies that are not declared as concerete
     * dependencies by the consumer, so this is a little npm "hack" so that
     * consumers will not need to depend on them directly if they don't interact
     * with them.
     * See `cdkDependenciesAsDeps` for changing the default behavior.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @experimental
     */
    addCdkDependencies(...deps) {
        // this ugliness will go away in cdk v2.0
        this.addPeerDeps(...deps.map(m => this.formatModuleSpec(m)));
        if (this.cdkDependenciesAsDeps) {
            this.addDeps(...deps.map(m => this.formatModuleSpec(m)));
        }
        else {
            this.addDevDeps(...deps.map(m => this.formatModuleSpec(m)));
        }
    }
    /**
     * (experimental) Adds CDK modules as test dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @experimental
     */
    addCdkTestDependencies(...deps) {
        this.addDevDeps(...deps.map(m => this.formatModuleSpec(m)));
    }
    formatModuleSpec(module) {
        return `${module}@${this.cdkVersion}`;
    }
}
exports.AwsCdkConstructLibrary = AwsCdkConstructLibrary;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkConstructLibrary[_a] = { fqn: "projen.AwsCdkConstructLibrary", version: "0.29.3" };
/**
 * @deprecated use `AwsCdkConstructLibrary`
 */
class ConstructLibraryAws extends AwsCdkConstructLibrary {
}
exports.ConstructLibraryAws = ConstructLibraryAws;
_b = JSII_RTTI_SYMBOL_1;
ConstructLibraryAws[_b] = { fqn: "projen.ConstructLibraryAws", version: "0.29.3" };
//# sourceMappingURL=data:application/json;base64,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