"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkTypeScriptApp = exports.CdkApprovalLevel = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
const semver = require("semver");
const component_1 = require("./component");
const json_1 = require("./json");
const typescript_1 = require("./typescript");
/**
 * @experimental
 */
var CdkApprovalLevel;
(function (CdkApprovalLevel) {
    CdkApprovalLevel["NEVER"] = "never";
    CdkApprovalLevel["ANY_CHANGE"] = "any-change";
    CdkApprovalLevel["BROADENING"] = "broadening";
})(CdkApprovalLevel = exports.CdkApprovalLevel || (exports.CdkApprovalLevel = {}));
/**
 * (experimental) AWS CDK app in TypeScript.
 *
 * @experimental
 * @pjid awscdk-app-ts
 */
class AwsCdkTypeScriptApp extends typescript_1.TypeScriptAppProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h;
        super({
            ...options,
            sampleCode: false,
        });
        // encode a hidden assumption further down the chain
        if (this.srcdir !== 'src') {
            throw new Error('sources are expected under the "src" directory');
        }
        // encode a hidden assumption further down the chain
        if (this.testdir !== 'test') {
            throw new Error('test sources are expected under the "test" directory');
        }
        this.appEntrypoint = (_b = options.appEntrypoint) !== null && _b !== void 0 ? _b : 'main.ts';
        this.cdkVersion = options.cdkVersionPinning ? options.cdkVersion : `^${options.cdkVersion}`;
        // CLI
        this.addDevDeps(this.formatModuleSpec('aws-cdk'));
        this.addCdkDependency('@aws-cdk/assert');
        const cdkMajorVersion = (_d = (_c = semver.minVersion(this.cdkVersion)) === null || _c === void 0 ? void 0 : _c.major) !== null && _d !== void 0 ? _d : 1;
        if (cdkMajorVersion < 2) {
            this.addCdkDependency('@aws-cdk/core');
        }
        else {
            this.addCdkDependency('aws-cdk-lib');
            this.addDeps('constructs@^10.0.5');
        }
        this.addCdkDependency(...(_e = options.cdkDependencies) !== null && _e !== void 0 ? _e : []);
        const synth = this.addTask('synth', {
            description: 'Synthesizes your cdk app into cdk.out (part of "yarn build")',
            exec: 'cdk synth',
        });
        this.addTask('deploy', {
            description: 'Deploys your CDK app to the AWS cloud',
            exec: 'cdk deploy',
        });
        this.addTask('destroy', {
            description: 'Destroys your cdk app in the AWS cloud',
            exec: 'cdk destroy',
        });
        this.addTask('diff', {
            description: 'Diffs the currently deployed app against your code',
            exec: 'cdk diff',
        });
        // no compile step because we do all of it in typescript directly
        this.compileTask.reset();
        this.removeScript('watch'); // because we use ts-node
        // add synth to the build
        this.buildTask.spawn(synth);
        this.cdkConfig = {
            app: `npx ts-node --prefer-ts-exts ${path.posix.join(this.srcdir, this.appEntrypoint)}`,
        };
        if (options.context) {
            this.cdkConfig.context = { ...options.context };
        }
        if (options.requireApproval) {
            this.cdkConfig.requireApproval = options.requireApproval;
        }
        this.gitignore.exclude('cdk.out/');
        this.gitignore.exclude('.cdk.staging/');
        this.gitignore.exclude('.parcel-cache/');
        (_f = this.npmignore) === null || _f === void 0 ? void 0 : _f.exclude('cdk.out/');
        (_g = this.npmignore) === null || _g === void 0 ? void 0 : _g.exclude('.cdk.staging/');
        if (this.tsconfig) {
            this.tsconfig.exclude.push('cdk.out');
        }
        this.addDevDeps('ts-node@^9');
        new json_1.JsonFile(this, 'cdk.json', {
            obj: this.cdkConfig,
        });
        if ((_h = options.sampleCode) !== null && _h !== void 0 ? _h : true) {
            new SampleCode(this, cdkMajorVersion);
        }
    }
    /**
     * (experimental) Adds an AWS CDK module dependencies.
     *
     * @param modules The list of modules to depend on.
     * @experimental
     */
    addCdkDependency(...modules) {
        if (modules.length === 0) {
            return;
        }
        this.addDeps(...modules.map(m => this.formatModuleSpec(m)));
    }
    formatModuleSpec(module) {
        return `${module}@${this.cdkVersion}`;
    }
}
exports.AwsCdkTypeScriptApp = AwsCdkTypeScriptApp;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkTypeScriptApp[_a] = { fqn: "projen.AwsCdkTypeScriptApp", version: "0.29.3" };
class SampleCode extends component_1.Component {
    constructor(project, cdkMajorVersion) {
        super(project);
        this.cdkMajorVersion = cdkMajorVersion;
        this.appProject = project;
    }
    synthesize() {
        const outdir = this.project.outdir;
        const srcdir = path.join(outdir, this.appProject.srcdir);
        if (fs.pathExistsSync(srcdir) && fs.readdirSync(srcdir).filter(x => x.endsWith('.ts'))) {
            return;
        }
        const srcImports = new Array();
        if (this.cdkMajorVersion < 2) {
            srcImports.push('import { App, Construct, Stack, StackProps } from \'@aws-cdk/core\';');
        }
        else {
            srcImports.push('import { App, Stack, StackProps } from \'aws-cdk-lib\';');
            srcImports.push('import { Construct } from \'constructs\';');
        }
        const srcCode = `${srcImports.join('\n')}

export class MyStack extends Stack {
  constructor(scope: Construct, id: string, props: StackProps = {}) {
    super(scope, id, props);

    // define resources here...
  }
}

// for development, use account/region from cdk cli
const devEnv = {
  account: process.env.CDK_DEFAULT_ACCOUNT,
  region: process.env.CDK_DEFAULT_REGION,
};

const app = new App();

new MyStack(app, 'my-stack-dev', { env: devEnv });
// new MyStack(app, 'my-stack-prod', { env: prodEnv });

app.synth();`;
        fs.mkdirpSync(srcdir);
        fs.writeFileSync(path.join(srcdir, this.appProject.appEntrypoint), srcCode);
        const testdir = path.join(outdir, this.appProject.testdir);
        if (fs.pathExistsSync(testdir) && fs.readdirSync(testdir).filter(x => x.endsWith('.ts'))) {
            return;
        }
        const testImports = new Array();
        if (this.cdkMajorVersion < 2) {
            testImports.push('import { App } from \'@aws-cdk/core\';');
        }
        else {
            testImports.push('import { App } from \'aws-cdk-lib\';');
        }
        const appEntrypointName = path.basename(this.appProject.appEntrypoint, '.ts');
        const testCode = `import '@aws-cdk/assert/jest';
${testImports.join('\n')}
import { MyStack } from '../src/${appEntrypointName}';

test('Snapshot', () => {
  const app = new App();
  const stack = new MyStack(app, 'test');

  expect(stack).not.toHaveResource('AWS::S3::Bucket');
  expect(app.synth().getStackArtifact(stack.artifactId).template).toMatchSnapshot();
});`;
        fs.mkdirpSync(testdir);
        fs.writeFileSync(path.join(testdir, `${appEntrypointName}.test.ts`), testCode);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzY2RrLWFwcC10cy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9hd3NjZGstYXBwLXRzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkJBQTZCO0FBQzdCLCtCQUErQjtBQUMvQixpQ0FBaUM7QUFDakMsMkNBQXdDO0FBQ3hDLGlDQUFrQztBQUNsQyw2Q0FBOEU7Ozs7QUFFOUUsSUFBWSxnQkFPWDtBQVBELFdBQVksZ0JBQWdCO0lBRTFCLG1DQUFlLENBQUE7SUFFZiw2Q0FBeUIsQ0FBQTtJQUV6Qiw2Q0FBeUIsQ0FBQTtBQUMzQixDQUFDLEVBUFcsZ0JBQWdCLEdBQWhCLHdCQUFnQixLQUFoQix3QkFBZ0IsUUFPM0I7Ozs7Ozs7QUF1QkQsTUFBYSxtQkFBb0IsU0FBUSxpQ0FBb0I7Ozs7SUFVM0QsWUFBWSxPQUFtQzs7UUFDN0MsS0FBSyxDQUFDO1lBQ0osR0FBRyxPQUFPO1lBQ1YsVUFBVSxFQUFFLEtBQUs7U0FDbEIsQ0FBQyxDQUFDO1FBRUgsb0RBQW9EO1FBQ3BELElBQUksSUFBSSxDQUFDLE1BQU0sS0FBSyxLQUFLLEVBQUU7WUFDekIsTUFBTSxJQUFJLEtBQUssQ0FBQyxnREFBZ0QsQ0FBQyxDQUFDO1NBQ25FO1FBRUQsb0RBQW9EO1FBQ3BELElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxNQUFNLEVBQUU7WUFDM0IsTUFBTSxJQUFJLEtBQUssQ0FBQyxzREFBc0QsQ0FBQyxDQUFDO1NBQ3pFO1FBRUQsSUFBSSxDQUFDLGFBQWEsU0FBRyxPQUFPLENBQUMsYUFBYSxtQ0FBSSxTQUFTLENBQUM7UUFFeEQsSUFBSSxDQUFDLFVBQVUsR0FBRyxPQUFPLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLElBQUksT0FBTyxDQUFDLFVBQVUsRUFBRSxDQUFDO1FBRTVGLE1BQU07UUFDTixJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO1FBQ2xELElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBRXpDLE1BQU0sZUFBZSxlQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQywwQ0FBRSxLQUFLLG1DQUFJLENBQUMsQ0FBQztRQUN2RSxJQUFJLGVBQWUsR0FBRyxDQUFDLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGVBQWUsQ0FBQyxDQUFDO1NBQ3hDO2FBQU07WUFDTCxJQUFJLENBQUMsZ0JBQWdCLENBQUMsYUFBYSxDQUFDLENBQUM7WUFDckMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO1NBQ3BDO1FBRUQsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFNBQUcsT0FBTyxDQUFDLGVBQWUsbUNBQUksRUFBRSxDQUFDLENBQUM7UUFFeEQsTUFBTSxLQUFLLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLEVBQUU7WUFDbEMsV0FBVyxFQUFFLDhEQUE4RDtZQUMzRSxJQUFJLEVBQUUsV0FBVztTQUNsQixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRTtZQUNyQixXQUFXLEVBQUUsdUNBQXVDO1lBQ3BELElBQUksRUFBRSxZQUFZO1NBQ25CLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxFQUFFO1lBQ3RCLFdBQVcsRUFBRSx3Q0FBd0M7WUFDckQsSUFBSSxFQUFFLGFBQWE7U0FDcEIsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLEVBQUU7WUFDbkIsV0FBVyxFQUFFLG9EQUFvRDtZQUNqRSxJQUFJLEVBQUUsVUFBVTtTQUNqQixDQUFDLENBQUM7UUFFSCxpRUFBaUU7UUFDakUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUV6QixJQUFJLENBQUMsWUFBWSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMseUJBQXlCO1FBRXJELHlCQUF5QjtRQUN6QixJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUU1QixJQUFJLENBQUMsU0FBUyxHQUFHO1lBQ2YsR0FBRyxFQUFFLGdDQUFnQyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsRUFBRTtTQUN4RixDQUFDO1FBRUYsSUFBSSxPQUFPLENBQUMsT0FBTyxFQUFFO1lBQ25CLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxHQUFHLEVBQUUsR0FBRyxPQUFPLENBQUMsT0FBTyxFQUFFLENBQUM7U0FDakQ7UUFFRCxJQUFJLE9BQU8sQ0FBQyxlQUFlLEVBQUU7WUFDM0IsSUFBSSxDQUFDLFNBQVMsQ0FBQyxlQUFlLEdBQUcsT0FBTyxDQUFDLGVBQWUsQ0FBQztTQUMxRDtRQUVELElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ25DLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQ3hDLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLENBQUM7UUFFekMsTUFBQSxJQUFJLENBQUMsU0FBUywwQ0FBRSxPQUFPLENBQUMsVUFBVSxFQUFFO1FBQ3BDLE1BQUEsSUFBSSxDQUFDLFNBQVMsMENBQUUsT0FBTyxDQUFDLGVBQWUsRUFBRTtRQUV6QyxJQUFJLElBQUksQ0FBQyxRQUFRLEVBQUU7WUFDakIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1NBQ3ZDO1FBRUQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQztRQUU5QixJQUFJLGVBQVEsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQzdCLEdBQUcsRUFBRSxJQUFJLENBQUMsU0FBUztTQUNwQixDQUFDLENBQUM7UUFFSCxVQUFJLE9BQU8sQ0FBQyxVQUFVLG1DQUFJLElBQUksRUFBRTtZQUM5QixJQUFJLFVBQVUsQ0FBQyxJQUFJLEVBQUUsZUFBZSxDQUFDLENBQUM7U0FDdkM7SUFDSCxDQUFDOzs7Ozs7O0lBR00sZ0JBQWdCLENBQUMsR0FBRyxPQUFpQjtRQUMxQyxJQUFJLE9BQU8sQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO1lBQ3hCLE9BQU87U0FDUjtRQUNELElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRyxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUM5RCxDQUFDO0lBRU8sZ0JBQWdCLENBQUMsTUFBYztRQUNyQyxPQUFPLEdBQUcsTUFBTSxJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQztJQUN4QyxDQUFDOztBQXBISCxrREFxSEM7OztBQUVELE1BQU0sVUFBVyxTQUFRLHFCQUFTO0lBRWhDLFlBQVksT0FBNEIsRUFBbUIsZUFBdUI7UUFDaEYsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBRDBDLG9CQUFlLEdBQWYsZUFBZSxDQUFRO1FBRWhGLElBQUksQ0FBQyxVQUFVLEdBQUcsT0FBTyxDQUFDO0lBQzVCLENBQUM7SUFFTSxVQUFVO1FBQ2YsTUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUM7UUFDbkMsTUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUN6RCxJQUFJLEVBQUUsQ0FBQyxjQUFjLENBQUMsTUFBTSxDQUFDLElBQUksRUFBRSxDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUU7WUFDdEYsT0FBTztTQUNSO1FBRUQsTUFBTSxVQUFVLEdBQUcsSUFBSSxLQUFLLEVBQVUsQ0FBQztRQUN2QyxJQUFJLElBQUksQ0FBQyxlQUFlLEdBQUcsQ0FBQyxFQUFFO1lBQzVCLFVBQVUsQ0FBQyxJQUFJLENBQUMsc0VBQXNFLENBQUMsQ0FBQztTQUN6RjthQUFNO1lBQ0wsVUFBVSxDQUFDLElBQUksQ0FBQyx5REFBeUQsQ0FBQyxDQUFDO1lBQzNFLFVBQVUsQ0FBQyxJQUFJLENBQUMsMkNBQTJDLENBQUMsQ0FBQztTQUM5RDtRQUVELE1BQU0sT0FBTyxHQUFHLEdBQUcsVUFBVSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OzthQXFCL0IsQ0FBQztRQUVWLEVBQUUsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDdEIsRUFBRSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBRTVFLE1BQU0sT0FBTyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDM0QsSUFBSSxFQUFFLENBQUMsY0FBYyxDQUFDLE9BQU8sQ0FBQyxJQUFJLEVBQUUsQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFO1lBQ3hGLE9BQU87U0FDUjtRQUVELE1BQU0sV0FBVyxHQUFHLElBQUksS0FBSyxFQUFVLENBQUM7UUFDeEMsSUFBSSxJQUFJLENBQUMsZUFBZSxHQUFHLENBQUMsRUFBRTtZQUM1QixXQUFXLENBQUMsSUFBSSxDQUFDLHdDQUF3QyxDQUFDLENBQUM7U0FDNUQ7YUFBTTtZQUNMLFdBQVcsQ0FBQyxJQUFJLENBQUMsc0NBQXNDLENBQUMsQ0FBQztTQUMxRDtRQUdELE1BQU0saUJBQWlCLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLGFBQWEsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUM5RSxNQUFNLFFBQVEsR0FBRztFQUNuQixXQUFXLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztrQ0FDVSxpQkFBaUI7Ozs7Ozs7O0lBUS9DLENBQUM7UUFFRCxFQUFFLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ3ZCLEVBQUUsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsR0FBRyxpQkFBaUIsVUFBVSxDQUFDLEVBQUUsUUFBUSxDQUFDLENBQUM7SUFDakYsQ0FBQztDQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCAqIGFzIGZzIGZyb20gJ2ZzLWV4dHJhJztcbmltcG9ydCAqIGFzIHNlbXZlciBmcm9tICdzZW12ZXInO1xuaW1wb3J0IHsgQ29tcG9uZW50IH0gZnJvbSAnLi9jb21wb25lbnQnO1xuaW1wb3J0IHsgSnNvbkZpbGUgfSBmcm9tICcuL2pzb24nO1xuaW1wb3J0IHsgVHlwZVNjcmlwdEFwcFByb2plY3QsIFR5cGVTY3JpcHRQcm9qZWN0T3B0aW9ucyB9IGZyb20gJy4vdHlwZXNjcmlwdCc7XG5cbmV4cG9ydCBlbnVtIENka0FwcHJvdmFsTGV2ZWwge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBORVZFUiA9ICduZXZlcicsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQU5ZX0NIQU5HRSA9ICdhbnktY2hhbmdlJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBCUk9BREVOSU5HID0gJ2Jyb2FkZW5pbmcnLFxufVxuZXhwb3J0IGludGVyZmFjZSBBd3NDZGtUeXBlU2NyaXB0QXBwT3B0aW9ucyBleHRlbmRzIFR5cGVTY3JpcHRQcm9qZWN0T3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjZGtWZXJzaW9uOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjZGtWZXJzaW9uUGlubmluZz86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNka0RlcGVuZGVuY2llcz86IHN0cmluZ1tdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNvbnRleHQ/OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYXBwRW50cnlwb2ludD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmVxdWlyZUFwcHJvdmFsPzogQ2RrQXBwcm92YWxMZXZlbDtcblxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEF3c0Nka1R5cGVTY3JpcHRBcHAgZXh0ZW5kcyBUeXBlU2NyaXB0QXBwUHJvamVjdCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGNka1ZlcnNpb246IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgY2RrQ29uZmlnOiBhbnk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgYXBwRW50cnlwb2ludDogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKG9wdGlvbnM6IEF3c0Nka1R5cGVTY3JpcHRBcHBPcHRpb25zKSB7XG4gICAgc3VwZXIoe1xuICAgICAgLi4ub3B0aW9ucyxcbiAgICAgIHNhbXBsZUNvZGU6IGZhbHNlLFxuICAgIH0pO1xuXG4gICAgLy8gZW5jb2RlIGEgaGlkZGVuIGFzc3VtcHRpb24gZnVydGhlciBkb3duIHRoZSBjaGFpblxuICAgIGlmICh0aGlzLnNyY2RpciAhPT0gJ3NyYycpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignc291cmNlcyBhcmUgZXhwZWN0ZWQgdW5kZXIgdGhlIFwic3JjXCIgZGlyZWN0b3J5Jyk7XG4gICAgfVxuXG4gICAgLy8gZW5jb2RlIGEgaGlkZGVuIGFzc3VtcHRpb24gZnVydGhlciBkb3duIHRoZSBjaGFpblxuICAgIGlmICh0aGlzLnRlc3RkaXIgIT09ICd0ZXN0Jykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCd0ZXN0IHNvdXJjZXMgYXJlIGV4cGVjdGVkIHVuZGVyIHRoZSBcInRlc3RcIiBkaXJlY3RvcnknKTtcbiAgICB9XG5cbiAgICB0aGlzLmFwcEVudHJ5cG9pbnQgPSBvcHRpb25zLmFwcEVudHJ5cG9pbnQgPz8gJ21haW4udHMnO1xuXG4gICAgdGhpcy5jZGtWZXJzaW9uID0gb3B0aW9ucy5jZGtWZXJzaW9uUGlubmluZyA/IG9wdGlvbnMuY2RrVmVyc2lvbiA6IGBeJHtvcHRpb25zLmNka1ZlcnNpb259YDtcblxuICAgIC8vIENMSVxuICAgIHRoaXMuYWRkRGV2RGVwcyh0aGlzLmZvcm1hdE1vZHVsZVNwZWMoJ2F3cy1jZGsnKSk7XG4gICAgdGhpcy5hZGRDZGtEZXBlbmRlbmN5KCdAYXdzLWNkay9hc3NlcnQnKTtcblxuICAgIGNvbnN0IGNka01ham9yVmVyc2lvbiA9IHNlbXZlci5taW5WZXJzaW9uKHRoaXMuY2RrVmVyc2lvbik/Lm1ham9yID8/IDE7XG4gICAgaWYgKGNka01ham9yVmVyc2lvbiA8IDIpIHtcbiAgICAgIHRoaXMuYWRkQ2RrRGVwZW5kZW5jeSgnQGF3cy1jZGsvY29yZScpO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLmFkZENka0RlcGVuZGVuY3koJ2F3cy1jZGstbGliJyk7XG4gICAgICB0aGlzLmFkZERlcHMoJ2NvbnN0cnVjdHNAXjEwLjAuNScpO1xuICAgIH1cblxuICAgIHRoaXMuYWRkQ2RrRGVwZW5kZW5jeSguLi5vcHRpb25zLmNka0RlcGVuZGVuY2llcyA/PyBbXSk7XG5cbiAgICBjb25zdCBzeW50aCA9IHRoaXMuYWRkVGFzaygnc3ludGgnLCB7XG4gICAgICBkZXNjcmlwdGlvbjogJ1N5bnRoZXNpemVzIHlvdXIgY2RrIGFwcCBpbnRvIGNkay5vdXQgKHBhcnQgb2YgXCJ5YXJuIGJ1aWxkXCIpJyxcbiAgICAgIGV4ZWM6ICdjZGsgc3ludGgnLFxuICAgIH0pO1xuXG4gICAgdGhpcy5hZGRUYXNrKCdkZXBsb3knLCB7XG4gICAgICBkZXNjcmlwdGlvbjogJ0RlcGxveXMgeW91ciBDREsgYXBwIHRvIHRoZSBBV1MgY2xvdWQnLFxuICAgICAgZXhlYzogJ2NkayBkZXBsb3knLFxuICAgIH0pO1xuXG4gICAgdGhpcy5hZGRUYXNrKCdkZXN0cm95Jywge1xuICAgICAgZGVzY3JpcHRpb246ICdEZXN0cm95cyB5b3VyIGNkayBhcHAgaW4gdGhlIEFXUyBjbG91ZCcsXG4gICAgICBleGVjOiAnY2RrIGRlc3Ryb3knLFxuICAgIH0pO1xuXG4gICAgdGhpcy5hZGRUYXNrKCdkaWZmJywge1xuICAgICAgZGVzY3JpcHRpb246ICdEaWZmcyB0aGUgY3VycmVudGx5IGRlcGxveWVkIGFwcCBhZ2FpbnN0IHlvdXIgY29kZScsXG4gICAgICBleGVjOiAnY2RrIGRpZmYnLFxuICAgIH0pO1xuXG4gICAgLy8gbm8gY29tcGlsZSBzdGVwIGJlY2F1c2Ugd2UgZG8gYWxsIG9mIGl0IGluIHR5cGVzY3JpcHQgZGlyZWN0bHlcbiAgICB0aGlzLmNvbXBpbGVUYXNrLnJlc2V0KCk7XG5cbiAgICB0aGlzLnJlbW92ZVNjcmlwdCgnd2F0Y2gnKTsgLy8gYmVjYXVzZSB3ZSB1c2UgdHMtbm9kZVxuXG4gICAgLy8gYWRkIHN5bnRoIHRvIHRoZSBidWlsZFxuICAgIHRoaXMuYnVpbGRUYXNrLnNwYXduKHN5bnRoKTtcblxuICAgIHRoaXMuY2RrQ29uZmlnID0ge1xuICAgICAgYXBwOiBgbnB4IHRzLW5vZGUgLS1wcmVmZXItdHMtZXh0cyAke3BhdGgucG9zaXguam9pbih0aGlzLnNyY2RpciwgdGhpcy5hcHBFbnRyeXBvaW50KX1gLFxuICAgIH07XG5cbiAgICBpZiAob3B0aW9ucy5jb250ZXh0KSB7XG4gICAgICB0aGlzLmNka0NvbmZpZy5jb250ZXh0ID0geyAuLi5vcHRpb25zLmNvbnRleHQgfTtcbiAgICB9XG5cbiAgICBpZiAob3B0aW9ucy5yZXF1aXJlQXBwcm92YWwpIHtcbiAgICAgIHRoaXMuY2RrQ29uZmlnLnJlcXVpcmVBcHByb3ZhbCA9IG9wdGlvbnMucmVxdWlyZUFwcHJvdmFsO1xuICAgIH1cblxuICAgIHRoaXMuZ2l0aWdub3JlLmV4Y2x1ZGUoJ2Nkay5vdXQvJyk7XG4gICAgdGhpcy5naXRpZ25vcmUuZXhjbHVkZSgnLmNkay5zdGFnaW5nLycpO1xuICAgIHRoaXMuZ2l0aWdub3JlLmV4Y2x1ZGUoJy5wYXJjZWwtY2FjaGUvJyk7XG5cbiAgICB0aGlzLm5wbWlnbm9yZT8uZXhjbHVkZSgnY2RrLm91dC8nKTtcbiAgICB0aGlzLm5wbWlnbm9yZT8uZXhjbHVkZSgnLmNkay5zdGFnaW5nLycpO1xuXG4gICAgaWYgKHRoaXMudHNjb25maWcpIHtcbiAgICAgIHRoaXMudHNjb25maWcuZXhjbHVkZS5wdXNoKCdjZGsub3V0Jyk7XG4gICAgfVxuXG4gICAgdGhpcy5hZGREZXZEZXBzKCd0cy1ub2RlQF45Jyk7XG5cbiAgICBuZXcgSnNvbkZpbGUodGhpcywgJ2Nkay5qc29uJywge1xuICAgICAgb2JqOiB0aGlzLmNka0NvbmZpZyxcbiAgICB9KTtcblxuICAgIGlmIChvcHRpb25zLnNhbXBsZUNvZGUgPz8gdHJ1ZSkge1xuICAgICAgbmV3IFNhbXBsZUNvZGUodGhpcywgY2RrTWFqb3JWZXJzaW9uKTtcbiAgICB9XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBhZGRDZGtEZXBlbmRlbmN5KC4uLm1vZHVsZXM6IHN0cmluZ1tdKSB7XG4gICAgaWYgKG1vZHVsZXMubGVuZ3RoID09PSAwKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuICAgIHRoaXMuYWRkRGVwcyguLi5tb2R1bGVzLm1hcChtID0+IHRoaXMuZm9ybWF0TW9kdWxlU3BlYyhtKSkpO1xuICB9XG5cbiAgcHJpdmF0ZSBmb3JtYXRNb2R1bGVTcGVjKG1vZHVsZTogc3RyaW5nKTogc3RyaW5nIHtcbiAgICByZXR1cm4gYCR7bW9kdWxlfUAke3RoaXMuY2RrVmVyc2lvbn1gO1xuICB9XG59XG5cbmNsYXNzIFNhbXBsZUNvZGUgZXh0ZW5kcyBDb21wb25lbnQge1xuICBwcml2YXRlIHJlYWRvbmx5IGFwcFByb2plY3Q6IEF3c0Nka1R5cGVTY3JpcHRBcHA7XG4gIGNvbnN0cnVjdG9yKHByb2plY3Q6IEF3c0Nka1R5cGVTY3JpcHRBcHAsIHByaXZhdGUgcmVhZG9ubHkgY2RrTWFqb3JWZXJzaW9uOiBudW1iZXIpIHtcbiAgICBzdXBlcihwcm9qZWN0KTtcbiAgICB0aGlzLmFwcFByb2plY3QgPSBwcm9qZWN0O1xuICB9XG5cbiAgcHVibGljIHN5bnRoZXNpemUoKSB7XG4gICAgY29uc3Qgb3V0ZGlyID0gdGhpcy5wcm9qZWN0Lm91dGRpcjtcbiAgICBjb25zdCBzcmNkaXIgPSBwYXRoLmpvaW4ob3V0ZGlyLCB0aGlzLmFwcFByb2plY3Quc3JjZGlyKTtcbiAgICBpZiAoZnMucGF0aEV4aXN0c1N5bmMoc3JjZGlyKSAmJiBmcy5yZWFkZGlyU3luYyhzcmNkaXIpLmZpbHRlcih4ID0+IHguZW5kc1dpdGgoJy50cycpKSkge1xuICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIGNvbnN0IHNyY0ltcG9ydHMgPSBuZXcgQXJyYXk8c3RyaW5nPigpO1xuICAgIGlmICh0aGlzLmNka01ham9yVmVyc2lvbiA8IDIpIHtcbiAgICAgIHNyY0ltcG9ydHMucHVzaCgnaW1wb3J0IHsgQXBwLCBDb25zdHJ1Y3QsIFN0YWNrLCBTdGFja1Byb3BzIH0gZnJvbSBcXCdAYXdzLWNkay9jb3JlXFwnOycpO1xuICAgIH0gZWxzZSB7XG4gICAgICBzcmNJbXBvcnRzLnB1c2goJ2ltcG9ydCB7IEFwcCwgU3RhY2ssIFN0YWNrUHJvcHMgfSBmcm9tIFxcJ2F3cy1jZGstbGliXFwnOycpO1xuICAgICAgc3JjSW1wb3J0cy5wdXNoKCdpbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tIFxcJ2NvbnN0cnVjdHNcXCc7Jyk7XG4gICAgfVxuXG4gICAgY29uc3Qgc3JjQ29kZSA9IGAke3NyY0ltcG9ydHMuam9pbignXFxuJyl9XG5cbmV4cG9ydCBjbGFzcyBNeVN0YWNrIGV4dGVuZHMgU3RhY2sge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogU3RhY2tQcm9wcyA9IHt9KSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG5cbiAgICAvLyBkZWZpbmUgcmVzb3VyY2VzIGhlcmUuLi5cbiAgfVxufVxuXG4vLyBmb3IgZGV2ZWxvcG1lbnQsIHVzZSBhY2NvdW50L3JlZ2lvbiBmcm9tIGNkayBjbGlcbmNvbnN0IGRldkVudiA9IHtcbiAgYWNjb3VudDogcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfQUNDT1VOVCxcbiAgcmVnaW9uOiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9SRUdJT04sXG59O1xuXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5cbm5ldyBNeVN0YWNrKGFwcCwgJ215LXN0YWNrLWRldicsIHsgZW52OiBkZXZFbnYgfSk7XG4vLyBuZXcgTXlTdGFjayhhcHAsICdteS1zdGFjay1wcm9kJywgeyBlbnY6IHByb2RFbnYgfSk7XG5cbmFwcC5zeW50aCgpO2A7XG5cbiAgICBmcy5ta2RpcnBTeW5jKHNyY2Rpcik7XG4gICAgZnMud3JpdGVGaWxlU3luYyhwYXRoLmpvaW4oc3JjZGlyLCB0aGlzLmFwcFByb2plY3QuYXBwRW50cnlwb2ludCksIHNyY0NvZGUpO1xuXG4gICAgY29uc3QgdGVzdGRpciA9IHBhdGguam9pbihvdXRkaXIsIHRoaXMuYXBwUHJvamVjdC50ZXN0ZGlyKTtcbiAgICBpZiAoZnMucGF0aEV4aXN0c1N5bmModGVzdGRpcikgJiYgZnMucmVhZGRpclN5bmModGVzdGRpcikuZmlsdGVyKHggPT4geC5lbmRzV2l0aCgnLnRzJykpKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgY29uc3QgdGVzdEltcG9ydHMgPSBuZXcgQXJyYXk8c3RyaW5nPigpO1xuICAgIGlmICh0aGlzLmNka01ham9yVmVyc2lvbiA8IDIpIHtcbiAgICAgIHRlc3RJbXBvcnRzLnB1c2goJ2ltcG9ydCB7IEFwcCB9IGZyb20gXFwnQGF3cy1jZGsvY29yZVxcJzsnKTtcbiAgICB9IGVsc2Uge1xuICAgICAgdGVzdEltcG9ydHMucHVzaCgnaW1wb3J0IHsgQXBwIH0gZnJvbSBcXCdhd3MtY2RrLWxpYlxcJzsnKTtcbiAgICB9XG5cblxuICAgIGNvbnN0IGFwcEVudHJ5cG9pbnROYW1lID0gcGF0aC5iYXNlbmFtZSh0aGlzLmFwcFByb2plY3QuYXBwRW50cnlwb2ludCwgJy50cycpO1xuICAgIGNvbnN0IHRlc3RDb2RlID0gYGltcG9ydCAnQGF3cy1jZGsvYXNzZXJ0L2plc3QnO1xuJHt0ZXN0SW1wb3J0cy5qb2luKCdcXG4nKX1cbmltcG9ydCB7IE15U3RhY2sgfSBmcm9tICcuLi9zcmMvJHthcHBFbnRyeXBvaW50TmFtZX0nO1xuXG50ZXN0KCdTbmFwc2hvdCcsICgpID0+IHtcbiAgY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuICBjb25zdCBzdGFjayA9IG5ldyBNeVN0YWNrKGFwcCwgJ3Rlc3QnKTtcblxuICBleHBlY3Qoc3RhY2spLm5vdC50b0hhdmVSZXNvdXJjZSgnQVdTOjpTMzo6QnVja2V0Jyk7XG4gIGV4cGVjdChhcHAuc3ludGgoKS5nZXRTdGFja0FydGlmYWN0KHN0YWNrLmFydGlmYWN0SWQpLnRlbXBsYXRlKS50b01hdGNoU25hcHNob3QoKTtcbn0pO2A7XG5cbiAgICBmcy5ta2RpcnBTeW5jKHRlc3RkaXIpO1xuICAgIGZzLndyaXRlRmlsZVN5bmMocGF0aC5qb2luKHRlc3RkaXIsIGAke2FwcEVudHJ5cG9pbnROYW1lfS50ZXN0LnRzYCksIHRlc3RDb2RlKTtcbiAgfVxufVxuIl19