from spa_py import spa_calc
import numpy as np

EXPECTED = {
    'year': 2004,
    'month': 10,
    'day': 17,
    'hour': 12,
    'minute': 30,
    'second': 30.0,
    'delta_ut1': 0.0,
    'delta_t': 67.0,
    'time_zone': -7.0,
    'longitude': -105.1786,
    'latitude': 39.742476,
    'elevation': 1830.14,
    'pressure': 820.0,
    'temperature': 11.0,
    'slope': 30.0,
    'azm_rotation': -10.0,
    'atmos_refract': 0.5667,
    'function': 3,
    'e0': 39.59209464796398,
    'e': 39.60858878898177,
    'zenith': 50.39141121101823,
    'azimuth_astro': 14.311961805946808,
    'azimuth': 194.3119618059468,
    'incidence': 25.42168493680471,
    'suntransit': 11.765833793714224,
    'sunrise': 6.22578372122376,
    'sunset': 17.320379610556166
}


def spa_calc_example(test=True):
    result = spa_calc(
        year=2004, month=10, day=17, hour=12, minute=30, second=30,
        time_zone=-7, longitude=-105.1786, latitude=39.742476,
        elevation=1830.14, pressure=820, temperature=11, delta_t=67
    )
    if test:
        for fieldname, expected_value in EXPECTED.items():
            assert np.isclose(result[fieldname], expected_value)
    return result
