cimport cspa_py

def spa_calc(year, month, day, hour, minute, second, time_zone, latitude,
        longitude, elevation, pressure, temperature, delta_t,
        delta_ut1=0, slope=30.0, azm_rotation=-10, atmos_refract=0.5667):

    cdef cspa_py.spa_data spa

    spa.year = year
    spa.month = month
    spa.day = day
    spa.hour = hour
    spa.minute = minute
    spa.second = second
    spa.time_zone = time_zone
    spa.delta_ut1 = delta_ut1
    spa.delta_t = delta_t
    spa.longitude = longitude
    spa.latitude = latitude
    spa.elevation = elevation
    spa.pressure = pressure
    spa.temperature = temperature
    spa.slope = slope
    spa.azm_rotation = azm_rotation
    spa.atmos_refract = atmos_refract
    spa.function = cspa_py.SPA_ALL

    err = cspa_py.spa_calculate(&spa)

    return spa
