<img src="docs/sphinx/source/_images/pvlib_logo_horiz.png" width="600">

<table>
<tr>
  <td>Latest Release</td>
  <td>
    <a href="https://pypi.org/project/pvlib/">
    <img src="https://img.shields.io/pypi/v/pvlib.svg" alt="latest release" />
    </a>
    <a href="https://anaconda.org/conda-forge/pvlib-python">
    <img src="https://anaconda.org/conda-forge/pvlib-python/badges/version.svg" />
    </a>
    <a href="https://anaconda.org/conda-forge/pvlib-python">
    <img src="https://anaconda.org/conda-forge/pvlib-python/badges/latest_release_date.svg" />
    </a>
</tr>
<tr>
  <td>License</td>
  <td>
    <a href="https://github.com/pvlib/pvlib-python/blob/master/LICENSE">
    <img src="https://img.shields.io/pypi/l/pvlib.svg" alt="license" />
    </a>
</td>
</tr>
<tr>
  <td>Build Status</td>
  <td>
    <a href="https://travis-ci.org/pvlib/pvlib-python">
    <img src="https://travis-ci.org/pvlib/pvlib-python.svg?branch=master" alt="travis build status" />
    </a>
    <a href="http://pvlib-python.readthedocs.org/en/stable/">
    <img src="https://readthedocs.org/projects/pvlib-python/badge/?version=stable" alt="documentation build status" />
    </a>
    <a href="https://dev.azure.com/solararbiter/pvlib%20python/_build/latest?definitionId=4&branchName=master">
      <img src="https://dev.azure.com/solararbiter/pvlib%20python/_apis/build/status/pvlib.pvlib-python?branchName=master" alt="Azure Pipelines build status" />
    </a>
  </td>
</tr>
<tr>
  <td>Code Quality</td>
  <td>
    <a href="https://lgtm.com/projects/g/pvlib/pvlib-python/context:python">
    <img src="https://img.shields.io/lgtm/grade/python/g/pvlib/pvlib-python.svg?logo=lgtm&logoWidth=18" alt="lgtm quality grade" />
    </a>
    <a href="https://lgtm.com/projects/g/pvlib/pvlib-python/alerts">
    <img src="https://img.shields.io/lgtm/alerts/g/pvlib/pvlib-python.svg?logo=lgtm&logoWidth=18" alt="lgtm alters" />
    </a>
  </td>
</tr>
<tr>
  <td>Coverage</td>
  <td>
    <a href="https://coveralls.io/r/pvlib/pvlib-python">
    <img src="https://img.shields.io/coveralls/pvlib/pvlib-python.svg" alt="coveralls coverage" />
    </a>
    <a href="https://codecov.io/gh/pvlib/pvlib-python">
    <img src="https://codecov.io/gh/pvlib/pvlib-python/branch/master/graph/badge.svg" alt="codecov coverage" />
    </a>
  </td>
</tr>
<tr>
  <td>Publications</td>
  <td>
    <a href="https://doi.org/10.5281/zenodo.2554311">
    <img src="https://zenodo.org/badge/DOI/10.5281/zenodo.2554311.svg" alt="zenodo reference" />
    </a>
    <a href="http://joss.theoj.org/papers/41187535cad22dd4b076c89b72f874b1">
    <img src="http://joss.theoj.org/papers/41187535cad22dd4b076c89b72f874b1/status.svg" alt="JOSS reference" />
    </a>
  </td>
</tr>
<tr>
  <td>Downloads</td>
  <td>
    <a href="https://pypi.org/project/pvlib/">
    <img src="https://img.shields.io/pypi/dm/pvlib" alt="PyPI downloads" />
    </a>
    <a href="https://anaconda.org/conda-forge/pvlib-python">
    <img src="https://anaconda.org/conda-forge/pvlib-python/badges/downloads.svg" alt="conda-forge downloads" />
    </a>
  </td>
</tr>
</table>


pvlib python is a community supported tool that provides a set of
functions and classes for simulating the performance of photovoltaic
energy systems. pvlib python was originally ported from the PVLIB MATLAB
toolbox developed at Sandia National Laboratories and it implements many
of the models and methods developed at the Labs. More information on
Sandia Labs PV performance modeling programs can be found at
https://pvpmc.sandia.gov/. We collaborate with the PVLIB MATLAB project,
but operate independently of it.


Documentation
=============

Full documentation can be found at [readthedocs](http://pvlib-python.readthedocs.io/en/stable/).


Installation
============

pvlib-python releases may be installed using the ``pip`` and ``conda`` tools.
Please see the [Installation page](http://pvlib-python.readthedocs.io/en/stable/installation.html) of the documentation for complete instructions.

pvlib-python is compatible with Python 3.5 and above.

**Python 2.7 support ended on June 1, 2019, with pvlib-python 0.6.3.**


Contributing
============

We need your help to make pvlib-python a great tool!
Please see the [Contributing page](http://pvlib-python.readthedocs.io/en/stable/contributing.html) for more on how you can contribute.
The long-term success of pvlib-python requires substantial community support.


License
=======

BSD 3-clause


Getting support
===============

pvlib usage questions can be asked on
[Stack Overflow](http://stackoverflow.com) and tagged with
the [pvlib](http://stackoverflow.com/questions/tagged/pvlib) tag.

The [pvlib-python google group](https://groups.google.com/forum/#!forum/pvlib-python)
is used for discussing various topics of interest to the pvlib-python
community. We also make new version announcements on the google group.

If you suspect that you may have discovered a bug or if you'd like to
change something about pvlib, then please make an issue on our
[GitHub issues page](https://github.com/pvlib/pvlib-python/issues).


Citing
======

If you use pvlib-python in a published work, please cite:

  William F. Holmgren, Clifford W. Hansen, and Mark A. Mikofski.
  "pvlib python: a python package for modeling solar energy systems."
  Journal of Open Source Software, 3(29), 884, (2018).
  https://doi.org/10.21105/joss.00884

Please also cite the DOI corresponding to the specific version of
pvlib-python that you used. pvlib-python DOIs are listed at
[Zenodo.org](https://zenodo.org/search?page=1&size=20&q=conceptrecid:593284&all_versions&sort=-version)

NumFOCUS
========

pvlib python is a [NumFOCUS Affiliated Project](https://numfocus.org/sponsored-projects/affiliated-projects)

[![NumFocus Affliated Projects](https://i0.wp.com/numfocus.org/wp-content/uploads/2019/06/AffiliatedProject.png)](https://numfocus.org/sponsored-projects/affiliated-projects)
