"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class DAG(google.protobuf.message.Message):
    """DAG is the total set of operations to execute, though not technically
    DAGs since there can be recursion or anything that python can do. It
    is supposed to be our understanding of the code with our own internal
    IR.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class SymbolsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___Node: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___Node] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    SYMBOLS_FIELD_NUMBER: builtins.int
    FLOWCHART_FIELD_NUMBER: builtins.int
    @property
    def symbols(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___Node]:
        """symbols is a dict with name keys and nodes as values"""
        pass
    @property
    def flowchart(self) -> global___Flowchart: ...
    def __init__(self,
        *,
        symbols: typing.Optional[typing.Mapping[typing.Text, global___Node]] = ...,
        flowchart: typing.Optional[global___Flowchart] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["flowchart",b"flowchart"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["flowchart",b"flowchart","symbols",b"symbols"]) -> None: ...
global___DAG = DAG

class Flowchart(google.protobuf.message.Message):
    """Flowchart represents the data flow with nodes and edges, this can then
    be optimised for faster more performant execution. With nodes and edges
    we can reconstruct and play with any kind of arbitrary code.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class NodesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___Node: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___Node] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    class EdgesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___Edge: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___Edge] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    NODES_FIELD_NUMBER: builtins.int
    EDGES_FIELD_NUMBER: builtins.int
    @property
    def nodes(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___Node]:
        """node.id: node dict; map because easier to fetch and update things"""
        pass
    @property
    def edges(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___Edge]:
        """edge.id: edge dict; map because easier to fetch and update things"""
        pass
    def __init__(self,
        *,
        nodes: typing.Optional[typing.Mapping[typing.Text, global___Node]] = ...,
        edges: typing.Optional[typing.Mapping[typing.Text, global___Edge]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["edges",b"edges","nodes",b"nodes"]) -> None: ...
global___Flowchart = Flowchart

class Edge(google.protobuf.message.Message):
    """The edges are just connectors and should not contain any data of its own
    nbox_string can be used to tell about the edge in our IR
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _EdgeType:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _EdgeTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Edge._EdgeType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        EXECUTION_ORDER: Edge._EdgeType.ValueType  # 0
        BRANCHING: Edge._EdgeType.ValueType  # 1
        LOOP: Edge._EdgeType.ValueType  # 2
    class EdgeType(_EdgeType, metaclass=_EdgeTypeEnumTypeWrapper):
        """execution order: default
        branching: conditionals or parallels
        loop edge: for or while loop things
        """
        pass

    EXECUTION_ORDER: Edge.EdgeType.ValueType  # 0
    BRANCHING: Edge.EdgeType.ValueType  # 1
    LOOP: Edge.EdgeType.ValueType  # 2

    ID_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    TARGET_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    NBOX_STRING_FIELD_NUMBER: builtins.int
    id: typing.Text
    """edge id should be a combination of source and target"""

    source: typing.Text
    """name/id of the source"""

    target: typing.Text
    """name/id of the target"""

    type: global___Edge.EdgeType.ValueType
    """what type of edge is this, it can tell if it's a conditional
    edge or a loop edge or something
    """

    nbox_string: typing.Text
    def __init__(self,
        *,
        id: typing.Text = ...,
        source: typing.Text = ...,
        target: typing.Text = ...,
        type: global___Edge.EdgeType.ValueType = ...,
        nbox_string: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id",b"id","nbox_string",b"nbox_string","source",b"source","target",b"target","type",b"type"]) -> None: ...
global___Edge = Edge

class RunStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class InputsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        value: typing.Text
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    class OutputsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        value: typing.Text
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    START_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    @property
    def start(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """start datetime of this node"""
        pass
    @property
    def end(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """end datetime of this node"""
        pass
    @property
    def inputs(self) -> google.protobuf.internal.containers.ScalarMap[typing.Text, typing.Text]:
        """name of the inputs and optionally some value against them"""
        pass
    @property
    def outputs(self) -> google.protobuf.internal.containers.ScalarMap[typing.Text, typing.Text]:
        """name of the outputs with some string against it"""
        pass
    def __init__(self,
        *,
        start: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        end: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        inputs: typing.Optional[typing.Mapping[typing.Text, typing.Text]] = ...,
        outputs: typing.Optional[typing.Mapping[typing.Text, typing.Text]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["end",b"end","start",b"start"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["end",b"end","inputs",b"inputs","outputs",b"outputs","start",b"start"]) -> None: ...
global___RunStatus = RunStatus

class Code(google.protobuf.message.Message):
    """Code mostly has code related information"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class InputsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        value: typing.Text
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    class OutputsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        value: typing.Text
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    NBOX_STRING_FIELD_NUMBER: builtins.int
    LINENO_FIELD_NUMBER: builtins.int
    COL_OFFSET_FIELD_NUMBER: builtins.int
    END_LINENO_FIELD_NUMBER: builtins.int
    END_COL_OFFSET_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    CONDITIONS_FIELD_NUMBER: builtins.int
    name: typing.Text
    """name of the node"""

    code: typing.Text
    """code string for this node"""

    nbox_string: typing.Text
    lineno: builtins.int
    """these are code location elements"""

    col_offset: builtins.int
    end_lineno: builtins.int
    end_col_offset: builtins.int
    @property
    def inputs(self) -> google.protobuf.internal.containers.ScalarMap[typing.Text, typing.Text]:
        """name of the inputs and optionally some value against them"""
        pass
    @property
    def outputs(self) -> google.protobuf.internal.containers.ScalarMap[typing.Text, typing.Text]:
        """name of the outputs with some string against it"""
        pass
    @property
    def conditions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Code]:
        """when this is if-conditional it can have many different nodes"""
        pass
    def __init__(self,
        *,
        name: typing.Text = ...,
        code: typing.Text = ...,
        nbox_string: typing.Text = ...,
        lineno: builtins.int = ...,
        col_offset: builtins.int = ...,
        end_lineno: builtins.int = ...,
        end_col_offset: builtins.int = ...,
        inputs: typing.Optional[typing.Mapping[typing.Text, typing.Text]] = ...,
        outputs: typing.Optional[typing.Mapping[typing.Text, typing.Text]] = ...,
        conditions: typing.Optional[typing.Iterable[global___Code]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["code",b"code","col_offset",b"col_offset","conditions",b"conditions","end_col_offset",b"end_col_offset","end_lineno",b"end_lineno","inputs",b"inputs","lineno",b"lineno","name",b"name","nbox_string",b"nbox_string","outputs",b"outputs"]) -> None: ...
global___Code = Code

class Node(google.protobuf.message.Message):
    """Nodes contain the real-deal, these beast of a data structure has
    logic for processing some inputs, they are the servers and edges
    are just conne
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _NodeType:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _NodeTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Node._NodeType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        CODE: Node._NodeType.ValueType  # 0
        """code-block, this default and selected when code cannot be understood"""

        OP: Node._NodeType.ValueType  # 1
        """this is when the code is an operation and to be considered"""

        LOOP: Node._NodeType.ValueType  # 2
        """loop node can be a while or for loop"""

        BRANCHING: Node._NodeType.ValueType  # 3
        """code for parallelisation or conditional"""

        RETURN: Node._NodeType.ValueType  # 4
        """this code is returning something, defined for convinience"""

    class NodeType(_NodeType, metaclass=_NodeTypeEnumTypeWrapper):
        """NodeTypes can be of a few types such as"""
        pass

    CODE: Node.NodeType.ValueType  # 0
    """code-block, this default and selected when code cannot be understood"""

    OP: Node.NodeType.ValueType  # 1
    """this is when the code is an operation and to be considered"""

    LOOP: Node.NodeType.ValueType  # 2
    """loop node can be a while or for loop"""

    BRANCHING: Node.NodeType.ValueType  # 3
    """code for parallelisation or conditional"""

    RETURN: Node.NodeType.ValueType  # 4
    """this code is returning something, defined for convinience"""


    ID_FIELD_NUMBER: builtins.int
    EXECUTION_INDEX_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    OPERATOR_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    NBOX_STRING_FIELD_NUMBER: builtins.int
    RUN_STATUS_FIELD_NUMBER: builtins.int
    PARENT_NODE_ID_FIELD_NUMBER: builtins.int
    id: typing.Text
    """uuid4 id of the Node object"""

    execution_index: builtins.int
    """since the code during execution can be actually run out of order
    we need to store the order in which it would have been executed
    on the users single threaded GIL python for best experience. Thus
    adding execution_index which tracks this.
    """

    name: typing.Text
    """name of the node"""

    operator: typing.Text
    """operator is the name of the Operator class that is this node, it is
    to understanding what are the things people want to do since these
    names are given by the user
    """

    type: global___Node.NodeType.ValueType
    """Type of nodes"""

    @property
    def info(self) -> global___Code:
        """Code contains the code related information"""
        pass
    nbox_string: typing.Text
    @property
    def run_status(self) -> global___RunStatus:
        """define the run status"""
        pass
    parent_node_id: typing.Text
    """parent node id is used to determine the flow of the graph"""

    def __init__(self,
        *,
        id: typing.Text = ...,
        execution_index: builtins.int = ...,
        name: typing.Text = ...,
        operator: typing.Text = ...,
        type: global___Node.NodeType.ValueType = ...,
        info: typing.Optional[global___Code] = ...,
        nbox_string: typing.Text = ...,
        run_status: typing.Optional[global___RunStatus] = ...,
        parent_node_id: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["info",b"info","run_status",b"run_status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["execution_index",b"execution_index","id",b"id","info",b"info","name",b"name","nbox_string",b"nbox_string","operator",b"operator","parent_node_id",b"parent_node_id","run_status",b"run_status","type",b"type"]) -> None: ...
global___Node = Node
