# How to Install Browserist
## PyPI
Assuming that Python is installed already, execute this command in the terminal:

```shell
pip3 install browserist
```

If you already have installed Browserist, use this command to upgrade to latest version:

```shell
pip3 install --upgrade browserist
```

## Homebrew
If you already have installed the [Homebrew](https://brew.sh) package manager for Mac and Linux, execute this terminal command to tap Browserist:

```shell
brew tap jakob-bagterp/browserist
```

And then install:

```shell
brew install browserist
```

## Recommended Add-Ons
### ChromeDriver for Google Chrome
```shell
pip3 install chromedriver
```

```shell
brew install chromedriver
```

More info [here](https://chromedriver.chromium.org).

### Microsoft Edge Driver
More info and download [here](https://developer.microsoft.com/en-us/microsoft-edge/tools/webdriver/).

### GeckoDriver for Mozilla Firefox
```shell
brew install geckodriver
```

More info [here](https://github.com/mozilla/geckodriver).
