# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/02_nets.ipynb.

# %% auto 0
__all__ = ['DenseBlock', 'MLP', 'PredictiveModel', 'CounterNetModel']

# %% ../nbs/02_nets.ipynb 3
from .import_essentials import *
from .utils import validate_configs, sigmoid

# %% ../nbs/02_nets.ipynb 4
@deprecated(removed_in='0.1.0', deprecated_in='0.0.7',
            details='Use `cfnet.module.DenseBlock` instead.')
class DenseBlock(hk.Module):
    def __init__(self,
                output_size: int,
                dropout_rate: float = 0.3,
                name: Optional[str] = None):
        super().__init__(name=name)
        self.output_size = output_size
        self.dropout_rate = dropout_rate

    def __call__(self,
                x: jnp.ndarray,
                is_training: bool = True) -> jnp.ndarray:
        dropout_rate = self.dropout_rate if is_training else 0.0
        # he_uniform
        w_init = hk.initializers.VarianceScaling(2.0, 'fan_in', 'uniform')
        x = hk.Linear(self.output_size, w_init=w_init)(x)
        x = jax.nn.leaky_relu(x)
        x = hk.dropout(hk.next_rng_key(), dropout_rate, x)
        return x

# %% ../nbs/02_nets.ipynb 5
@deprecated(removed_in='0.1.0', deprecated_in='0.0.7',
            details='Use `cfnet.module.MLP` instead.')
class MLP(hk.Module):
    def __init__(self,
                sizes: List[int],
                dropout_rate: float = 0.3,
                name: Optional[str] = None):
        super().__init__(name=name)
        self.sizes = sizes
        self.dropout_rate = dropout_rate

    def __call__(self,
                x: jnp.ndarray,
                is_training: bool = True) -> jnp.ndarray:
        for size in self.sizes:
            x = DenseBlock(size, self.dropout_rate)(x, is_training)
        return x

# %% ../nbs/02_nets.ipynb 6
class PredictiveModelConfigs(BaseParser):
    sizes: List[int]
    dropout_rate: float = 0.3

# %% ../nbs/02_nets.ipynb 7
@deprecated(removed_in='0.1.0', deprecated_in='0.0.7',
            details='Use `cfnet.module.PredictiveModel` instead.')
class PredictiveModel(hk.Module):
    def __init__(
        self,
        m_config: Dict[str, Any],
        name: Optional[str] = None
    ):
        super().__init__(name=name)
        self.configs = validate_configs(m_config, PredictiveModelConfigs) #PredictiveModelConfigs(**m_config)

    def __call__(
        self,
        x: jnp.ndarray,
        is_training: bool = True
    ) -> jnp.ndarray:
        x = MLP(sizes=self.configs.sizes, dropout_rate=self.configs.dropout_rate)(x, is_training)
        x = hk.Linear(1)(x)
        x = sigmoid(x)
        return x

# %% ../nbs/02_nets.ipynb 10
class CounterNetModelConfigs(BaseParser):
    enc_sizes: List[int]
    dec_sizes: List[int]
    exp_sizes: List[int]
    dropout_rate: float = 0.3

# %% ../nbs/02_nets.ipynb 11
@deprecated(removed_in='0.1.0', deprecated_in='0.0.7',
            details='Use `cfnet.module.CounterNetModel` instead.')
class CounterNetModel(hk.Module):

    def __init__(self,
                m_config: Dict[str, Any],
                name: Optional[str] = None):
        super().__init__(name=name)
        self.configs = validate_configs(m_config, CounterNetModelConfigs)

    def __call__(self,
                x: jnp.ndarray,
                is_training: bool = True) -> jnp.ndarray:
        input_shape = x.shape[-1]
        # encoder
        z = MLP(self.configs.enc_sizes, self.configs.dropout_rate, name="Encoder")(x, is_training)

        # prediction
        pred = MLP(self.configs.dec_sizes, self.configs.dropout_rate, name="Predictor")(z, is_training)
        y_hat = hk.Linear(1, name='Predictor')(pred)
        y_hat = sigmoid(y_hat)

        # explain
        z_exp = jnp.concatenate((z, pred), axis=-1)
        cf = MLP(self.configs.exp_sizes, self.configs.dropout_rate, name="Explainer")(z_exp, is_training)
        cf = hk.Linear(input_shape, name='Explainer')(cf)
        return y_hat, cf
