﻿(function($) {
	$.fn.html5Uploader = function(options) {
		var crlf = '\r\n';
		var boundary = "iloveigloo";
		var dashes = "--";
		var settings = {
			"name" : "uploadedFile",
			"postUrl" : "Upload.aspx",
			"onClientAbort" : null,
			"onClientError" : null,
			"onClientLoad" : null,
			"onClientLoadEnd" : null,
			"onClientLoadStart" : null,
			"onClientProgress" : null,
			"onServerAbort" : null,
			"onServerError" : null,
			"onServerLoad" : null,
			"onServerLoadStart" : null,
			"onServerProgress" : null,
			"onServerReadyStateChange" : null,
			"onSuccess" : null,
			// new
			"upload_limit":null,
			"file_ext":null,
			"max_size":null,
			"autoUpload":true,
		};
		if (options) {
			$.extend(settings, options);
		}
		return this.each(function(options) {
			var $this = $(this);
			if ($this.is("[type='file']")) {
				$this.bind("change", function() {
					var files = this.files;
					
					if (settings.upload_limit != null && files.length > settings.upload_limit ){
						alert("最多只能上传" + settings.upload_limit+"文件!");
						return false;
					}
					for ( var i = 0; i < files.length; i++) {
						if (settings.file_ext != null) {
							if (jQuery.inArray(files[i].name.substring(files[i].name.lastIndexOf(".")+1).toLowerCase(), settings.file_ext) == '-1') {
								alert("只能上传" + settings.file_ext.join(",") + "格式！");
								return false;	
							} 
						}
						if (settings.max_size != null) {
							if (files[i].size >= settings.max_size) {
								alert("最大只能上传" + to_byte(settings.max_size,0) + "的文件!");
								return false;
							}
						}
						var os_type = $("[name='os_type']").val();
						if (os_type != "undefined" && os_type) {
							if (os_type == '1') {
								if (!(files[i].name.toLowerCase().indexOf('.apk') != -1)) {
									alert('请选择上传的android包');
									return false;				
								}
							}
							else if (!(files[i].name.toLowerCase().indexOf('.ipa') != -1)) {
								alert('请选择上传的ios包');
								return false;
							}							
						}
						fileHandler(files[i]);	
					}
					
				});
			} else {
				$this.bind("dragenter dragover", function() {
					$(this).addClass("hover");
					return false;
				}).bind("dragleave", function() {
					$(this).removeClass("hover");
					return false;
				}).bind("drop", function(e) {
					$(this).removeClass("hover");
					var files = e.originalEvent.dataTransfer.files;
					
					if (settings.upload_limit != null && files.length > settings.upload_limit ){
						alert("最多只能上传" + settings.upload_limit+"文件!");
						return false;
					}
					for ( var i = 0; i < files.length; i++) {
						if (settings.file_ext != null) {
							if (jQuery.inArray(files[i].name.substring(files[i].name.lastIndexOf(".")+1).toLowerCase(), settings.file_ext) == '-1') {
								alert("只能上传" + settings.file_ext.join(",") + "格式！");
								return false;	
							} 
						}
						if (settings.max_size != null) {
							if (files[i].size >= settings.max_size) {
								alert("最大只能上传" + to_byte(settings.max_size,0) + "的文件!");
								return false;
							}
						}
						var os_type = $("[name='os_type']").val();
						if (os_type != undefined && os_type) {
							if (os_type == '1') {
								if (!(files[i].name.toLowerCase().indexOf('.apk') != -1)) {
									alert('请选择上传的android包');
									return false;				
								}
							}
							else if (!(files[i].name.toLowerCase().indexOf('.ipa') != -1)) {
								alert('请选择上传的ios包');
								return false;
							}							
						}
						fileHandler(files[i]);
					}
				});
			}
		});
		function slugify(text) {
			text = text.replace(/[^-a-zA-Z0-9,&\s]+/ig, '');
			text = text.replace(/-/gi, "_");
			text = text.replace(/\s/gi, "-");
			return text;
		}		
    	function to_byte(value, dec) {
        	if (value == 0) 
            	return '0'
	        var prefix_list = ['B', 'K', 'M', 'G', 'T']
			var t = 1;
			
			//for(;dec>0;t*=10,dec--);
			
			//for(;dec<0;t/=10,dec++); 
				        
	        //value =  Math.round(value*t)/t;
	        value =  Math.round(value) 
	        var i = 0
	        while (value >= 1000){
				value /= 1000
	            i = i+1	        	
	        }
	        // while (value >= 1024){
				// value /= 1024
	            // i = i+1	        	
	        // }
	        //return Math.round(value*t)/t + prefix_list[i]
	        return Math.round(value) + prefix_list[i]
        }		
		function fileHandler(file) {
			var fileReader = new FileReader();
			fileReader.onabort = function(e) {
				if (settings.onClientAbort) {
					settings.onClientAbort(e, file);
				}
			};
			fileReader.onerror = function(e) {
				if (settings.onClientError) {
					settings.onClientError(e, file);
				}
			};
			fileReader.onload = function(e) {
				if (settings.onClientLoad) {
					settings.onClientLoad(e, file);
				}
			};
			fileReader.onloadend = function(e) {
				if (settings.onClientLoadEnd) {
					settings.onClientLoadEnd(e, file);
				}
			};
			fileReader.onloadstart = function(e) {
				if (settings.onClientLoadStart) {
					settings.onClientLoadStart(e, file);
				}
			};
			fileReader.onprogress = function(e) {
				if (settings.onClientProgress) {
					settings.onClientProgress(e, file);
				}
			};
			fileReader.readAsDataURL(file);
			var xmlHttpRequest = new XMLHttpRequest();
			xmlHttpRequest.upload.onabort = function(e) {
				if (settings.onServerAbort) {
					settings.onServerAbort(e, file);
				}
			};
			xmlHttpRequest.upload.onerror = function(e) {
				if (settings.onServerError) {
					settings.onServerError(e, file);
				}
			};
			xmlHttpRequest.upload.onload = function(e) {
				if (settings.onServerLoad) {
					settings.onServerLoad(e, file);
				}
			};
			xmlHttpRequest.upload.onloadstart = function(e) {
				if (settings.onServerLoadStart) {
					settings.onServerLoadStart(e, file);
				}
			};
			xmlHttpRequest.upload.onprogress = function(e) {
				if (settings.onServerProgress) {
					settings.onServerProgress(e, file);
				}
			};
			xmlHttpRequest.onreadystatechange = function(e) {
				if (settings.onServerReadyStateChange) {
					settings.onServerReadyStateChange(e, file,
							xmlHttpRequest.readyState);
				}
				if (settings.onSuccess && xmlHttpRequest.readyState == 4
						&& xmlHttpRequest.status == 200) {
					settings.onSuccess(e, file, xmlHttpRequest.responseText);
				}
			};
			if ($("#file_name").length > 0 && $("#version").length > 0)　{
				settings.postUrl += "&file_name=" + $("#file_name").val() + "&version=" + $("#version").val();		
			}
			xmlHttpRequest.open("POST", settings.postUrl, true);
			if (file.getAsBinary) {
				var data = dashes + boundary + crlf
						+ "Content-Disposition: form-data;" + "name=\""
						+ settings.name + "\";" + "filename=\""
						+ unescape(encodeURIComponent(file.name)) + "\"" + crlf
						+ "Content-Type: application/octet-stream" + crlf
						+ crlf + file.getAsBinary() + crlf + dashes + boundary
						+ dashes;
				xmlHttpRequest.setRequestHeader("Content-Type",
						"multipart/form-data;boundary=" + boundary);
				xmlHttpRequest.sendAsBinary(data);
			} else if (window.FormData) {
				var formData = new FormData();
				formData.append(settings.name, file);
				xmlHttpRequest.send(formData);
			}
		}
	};
})(jQuery);