# Generated by Django 2.0.13 on 2021-02-21 17:39

import django.core.validators
from django.db import migrations, models
import framework.models
import log_def.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='DictDefine',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('_version', models.IntegerField(default=0, verbose_name='版本')),
                ('create_datetime', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_datetime', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('name', models.CharField(max_length=100, verbose_name='字典名')),
                ('key', models.CharField(db_index=True, max_length=50, unique=True, validators=[django.core.validators.RegexValidator('^[a-z][\\d\\w_]+$', '字母组合,符合^[a-z][\\d\\w_]+$')], verbose_name='标识名')),
                ('json_dict', framework.models.JSONField(blank=True, default='{}', verbose_name='存键值')),
                ('group', models.CharField(default='', max_length=50, verbose_name='组')),
                ('type', models.IntegerField(choices=[(0, '字典'), (1, '数据表'), (2, '文件'), (3, '目录')], default=0, verbose_name='字典的类型')),
                ('remark', models.CharField(max_length=400, verbose_name='备注')),
            ],
            bases=(models.Model, framework.models.SqlModelMixin),
        ),
        migrations.CreateModel(
            name='LogDefine',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('_version', models.IntegerField(default=0, verbose_name='版本')),
                ('create_datetime', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_datetime', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('name', models.CharField(max_length=50, verbose_name='日志名')),
                ('key', models.CharField(db_index=True, max_length=100, validators=[django.core.validators.RegexValidator('^[a-z][\\d\\w_]+$', '字母组合,符合^[a-z][\\d\\w_]+$')], verbose_name='日志表标识')),
                ('remark', models.CharField(max_length=1000, verbose_name='备注')),
                ('status', models.IntegerField(choices=[(0, '分服'), (1, '中央服'), (2, '跨服')], default=0, verbose_name='保存位置')),
                ('_config', models.TextField(verbose_name='配置')),
                ('trigger', models.TextField(blank=True, default='', verbose_name='触发器sql')),
            ],
            bases=(models.Model, framework.models.SqlModelMixin, log_def.models.LogDefineMixin),
        ),
    ]
