"""braille characters have different width than most characters"""

from __future__ import annotations

import typing

from . import raster_utils
from . import render_utils


braille_dict: dict[tuple[tuple[int, ...], ...], str] = {
    ((0, 0), (0, 0), (0, 0), (0, 0)): '⠀',
    ((1, 0), (0, 0), (0, 0), (0, 0)): '⠁',
    ((1, 0), (1, 0), (0, 0), (0, 0)): '⠃',
    ((1, 0), (1, 0), (1, 0), (0, 0)): '⠇',
    ((1, 1), (1, 0), (1, 0), (0, 0)): '⠏',
    ((1, 1), (1, 1), (1, 0), (0, 0)): '⠟',
    ((1, 1), (1, 1), (1, 1), (0, 0)): '⠿',
    ((1, 1), (1, 1), (1, 1), (1, 0)): '⡿',
    ((1, 1), (1, 1), (1, 1), (1, 1)): '⣿',
    ((1, 1), (1, 1), (1, 1), (0, 1)): '⢿',
    ((1, 1), (1, 1), (1, 0), (1, 0)): '⡟',
    ((1, 1), (1, 1), (1, 0), (1, 1)): '⣟',
    ((1, 1), (1, 1), (1, 0), (0, 1)): '⢟',
    ((1, 1), (1, 0), (1, 1), (0, 0)): '⠯',
    ((1, 1), (1, 0), (1, 1), (1, 0)): '⡯',
    ((1, 1), (1, 0), (1, 1), (1, 1)): '⣯',
    ((1, 1), (1, 0), (1, 1), (0, 1)): '⢯',
    ((1, 1), (1, 0), (1, 0), (1, 0)): '⡏',
    ((1, 1), (1, 0), (1, 0), (1, 1)): '⣏',
    ((1, 1), (1, 0), (1, 0), (0, 1)): '⢏',
    ((1, 0), (1, 1), (1, 0), (0, 0)): '⠗',
    ((1, 0), (1, 1), (1, 1), (0, 0)): '⠷',
    ((1, 0), (1, 1), (1, 1), (1, 0)): '⡷',
    ((1, 0), (1, 1), (1, 1), (1, 1)): '⣷',
    ((1, 0), (1, 1), (1, 1), (0, 1)): '⢷',
    ((1, 0), (1, 1), (1, 0), (1, 0)): '⡗',
    ((1, 0), (1, 1), (1, 0), (1, 1)): '⣗',
    ((1, 0), (1, 1), (1, 0), (0, 1)): '⢗',
    ((1, 0), (1, 0), (1, 1), (0, 0)): '⠧',
    ((1, 0), (1, 0), (1, 1), (1, 0)): '⡧',
    ((1, 0), (1, 0), (1, 1), (1, 1)): '⣧',
    ((1, 0), (1, 0), (1, 1), (0, 1)): '⢧',
    ((1, 0), (1, 0), (1, 0), (1, 0)): '⡇',
    ((1, 0), (1, 0), (1, 0), (1, 1)): '⣇',
    ((1, 0), (1, 0), (1, 0), (0, 1)): '⢇',
    ((1, 1), (1, 0), (0, 0), (0, 0)): '⠋',
    ((1, 1), (1, 1), (0, 0), (0, 0)): '⠛',
    ((1, 1), (1, 1), (0, 1), (0, 0)): '⠻',
    ((1, 1), (1, 1), (0, 1), (1, 0)): '⡻',
    ((1, 1), (1, 1), (0, 1), (1, 1)): '⣻',
    ((1, 1), (1, 1), (0, 1), (0, 1)): '⢻',
    ((1, 1), (1, 1), (0, 0), (1, 0)): '⡛',
    ((1, 1), (1, 1), (0, 0), (1, 1)): '⣛',
    ((1, 1), (1, 1), (0, 0), (0, 1)): '⢛',
    ((1, 1), (1, 0), (0, 1), (0, 0)): '⠫',
    ((1, 1), (1, 0), (0, 1), (1, 0)): '⡫',
    ((1, 1), (1, 0), (0, 1), (1, 1)): '⣫',
    ((1, 1), (1, 0), (0, 1), (0, 1)): '⢫',
    ((1, 1), (1, 0), (0, 0), (1, 0)): '⡋',
    ((1, 1), (1, 0), (0, 0), (1, 1)): '⣋',
    ((1, 1), (1, 0), (0, 0), (0, 1)): '⢋',
    ((1, 0), (1, 1), (0, 0), (0, 0)): '⠓',
    ((1, 0), (1, 1), (0, 1), (0, 0)): '⠳',
    ((1, 0), (1, 1), (0, 1), (1, 0)): '⡳',
    ((1, 0), (1, 1), (0, 1), (1, 1)): '⣳',
    ((1, 0), (1, 1), (0, 1), (0, 1)): '⢳',
    ((1, 0), (1, 1), (0, 0), (1, 0)): '⡓',
    ((1, 0), (1, 1), (0, 0), (1, 1)): '⣓',
    ((1, 0), (1, 1), (0, 0), (0, 1)): '⢓',
    ((1, 0), (1, 0), (0, 1), (0, 0)): '⠣',
    ((1, 0), (1, 0), (0, 1), (1, 0)): '⡣',
    ((1, 0), (1, 0), (0, 1), (1, 1)): '⣣',
    ((1, 0), (1, 0), (0, 1), (0, 1)): '⢣',
    ((1, 0), (1, 0), (0, 0), (1, 0)): '⡃',
    ((1, 0), (1, 0), (0, 0), (1, 1)): '⣃',
    ((1, 0), (1, 0), (0, 0), (0, 1)): '⢃',
    ((1, 0), (0, 0), (1, 0), (0, 0)): '⠅',
    ((1, 1), (0, 0), (1, 0), (0, 0)): '⠍',
    ((1, 1), (0, 1), (1, 0), (0, 0)): '⠝',
    ((1, 1), (0, 1), (1, 1), (0, 0)): '⠽',
    ((1, 1), (0, 1), (1, 1), (1, 0)): '⡽',
    ((1, 1), (0, 1), (1, 1), (1, 1)): '⣽',
    ((1, 1), (0, 1), (1, 1), (0, 1)): '⢽',
    ((1, 1), (0, 1), (1, 0), (1, 0)): '⡝',
    ((1, 1), (0, 1), (1, 0), (1, 1)): '⣝',
    ((1, 1), (0, 1), (1, 0), (0, 1)): '⢝',
    ((1, 1), (0, 0), (1, 1), (0, 0)): '⠭',
    ((1, 1), (0, 0), (1, 1), (1, 0)): '⡭',
    ((1, 1), (0, 0), (1, 1), (1, 1)): '⣭',
    ((1, 1), (0, 0), (1, 1), (0, 1)): '⢭',
    ((1, 1), (0, 0), (1, 0), (1, 0)): '⡍',
    ((1, 1), (0, 0), (1, 0), (1, 1)): '⣍',
    ((1, 1), (0, 0), (1, 0), (0, 1)): '⢍',
    ((1, 0), (0, 1), (1, 0), (0, 0)): '⠕',
    ((1, 0), (0, 1), (1, 1), (0, 0)): '⠵',
    ((1, 0), (0, 1), (1, 1), (1, 0)): '⡵',
    ((1, 0), (0, 1), (1, 1), (1, 1)): '⣵',
    ((1, 0), (0, 1), (1, 1), (0, 1)): '⢵',
    ((1, 0), (0, 1), (1, 0), (1, 0)): '⡕',
    ((1, 0), (0, 1), (1, 0), (1, 1)): '⣕',
    ((1, 0), (0, 1), (1, 0), (0, 1)): '⢕',
    ((1, 0), (0, 0), (1, 1), (0, 0)): '⠥',
    ((1, 0), (0, 0), (1, 1), (1, 0)): '⡥',
    ((1, 0), (0, 0), (1, 1), (1, 1)): '⣥',
    ((1, 0), (0, 0), (1, 1), (0, 1)): '⢥',
    ((1, 0), (0, 0), (1, 0), (1, 0)): '⡅',
    ((1, 0), (0, 0), (1, 0), (1, 1)): '⣅',
    ((1, 0), (0, 0), (1, 0), (0, 1)): '⢅',
    ((1, 1), (0, 0), (0, 0), (0, 0)): '⠉',
    ((1, 1), (0, 1), (0, 0), (0, 0)): '⠙',
    ((1, 1), (0, 1), (0, 1), (0, 0)): '⠹',
    ((1, 1), (0, 1), (0, 1), (1, 0)): '⡹',
    ((1, 1), (0, 1), (0, 1), (1, 1)): '⣹',
    ((1, 1), (0, 1), (0, 1), (0, 1)): '⢹',
    ((1, 1), (0, 1), (0, 0), (1, 0)): '⡙',
    ((1, 1), (0, 1), (0, 0), (1, 1)): '⣙',
    ((1, 1), (0, 1), (0, 0), (0, 1)): '⢙',
    ((1, 1), (0, 0), (0, 1), (0, 0)): '⠩',
    ((1, 1), (0, 0), (0, 1), (1, 0)): '⡩',
    ((1, 1), (0, 0), (0, 1), (1, 1)): '⣩',
    ((1, 1), (0, 0), (0, 1), (0, 1)): '⢩',
    ((1, 1), (0, 0), (0, 0), (1, 0)): '⡉',
    ((1, 1), (0, 0), (0, 0), (1, 1)): '⣉',
    ((1, 1), (0, 0), (0, 0), (0, 1)): '⢉',
    ((1, 0), (0, 1), (0, 0), (0, 0)): '⠑',
    ((1, 0), (0, 1), (0, 1), (0, 0)): '⠱',
    ((1, 0), (0, 1), (0, 1), (1, 0)): '⡱',
    ((1, 0), (0, 1), (0, 1), (1, 1)): '⣱',
    ((1, 0), (0, 1), (0, 1), (0, 1)): '⢱',
    ((1, 0), (0, 1), (0, 0), (1, 0)): '⡑',
    ((1, 0), (0, 1), (0, 0), (1, 1)): '⣑',
    ((1, 0), (0, 1), (0, 0), (0, 1)): '⢑',
    ((1, 0), (0, 0), (0, 1), (0, 0)): '⠡',
    ((1, 0), (0, 0), (0, 1), (1, 0)): '⡡',
    ((1, 0), (0, 0), (0, 1), (1, 1)): '⣡',
    ((1, 0), (0, 0), (0, 1), (0, 1)): '⢡',
    ((1, 0), (0, 0), (0, 0), (1, 0)): '⡁',
    ((1, 0), (0, 0), (0, 0), (1, 1)): '⣁',
    ((1, 0), (0, 0), (0, 0), (0, 1)): '⢁',
    ((0, 0), (1, 0), (0, 0), (0, 0)): '⠂',
    ((0, 0), (1, 0), (1, 0), (0, 0)): '⠆',
    ((0, 1), (1, 0), (1, 0), (0, 0)): '⠎',
    ((0, 1), (1, 1), (1, 0), (0, 0)): '⠞',
    ((0, 1), (1, 1), (1, 1), (0, 0)): '⠾',
    ((0, 1), (1, 1), (1, 1), (1, 0)): '⡾',
    ((0, 1), (1, 1), (1, 1), (1, 1)): '⣾',
    ((0, 1), (1, 1), (1, 1), (0, 1)): '⢾',
    ((0, 1), (1, 1), (1, 0), (1, 0)): '⡞',
    ((0, 1), (1, 1), (1, 0), (1, 1)): '⣞',
    ((0, 1), (1, 1), (1, 0), (0, 1)): '⢞',
    ((0, 1), (1, 0), (1, 1), (0, 0)): '⠮',
    ((0, 1), (1, 0), (1, 1), (1, 0)): '⡮',
    ((0, 1), (1, 0), (1, 1), (1, 1)): '⣮',
    ((0, 1), (1, 0), (1, 1), (0, 1)): '⢮',
    ((0, 1), (1, 0), (1, 0), (1, 0)): '⡎',
    ((0, 1), (1, 0), (1, 0), (1, 1)): '⣎',
    ((0, 1), (1, 0), (1, 0), (0, 1)): '⢎',
    ((0, 0), (1, 1), (1, 0), (0, 0)): '⠖',
    ((0, 0), (1, 1), (1, 1), (0, 0)): '⠶',
    ((0, 0), (1, 1), (1, 1), (1, 0)): '⡶',
    ((0, 0), (1, 1), (1, 1), (1, 1)): '⣶',
    ((0, 0), (1, 1), (1, 1), (0, 1)): '⢶',
    ((0, 0), (1, 1), (1, 0), (1, 0)): '⡖',
    ((0, 0), (1, 1), (1, 0), (1, 1)): '⣖',
    ((0, 0), (1, 1), (1, 0), (0, 1)): '⢖',
    ((0, 0), (1, 0), (1, 1), (0, 0)): '⠦',
    ((0, 0), (1, 0), (1, 1), (1, 0)): '⡦',
    ((0, 0), (1, 0), (1, 1), (1, 1)): '⣦',
    ((0, 0), (1, 0), (1, 1), (0, 1)): '⢦',
    ((0, 0), (1, 0), (1, 0), (1, 0)): '⡆',
    ((0, 0), (1, 0), (1, 0), (1, 1)): '⣆',
    ((0, 0), (1, 0), (1, 0), (0, 1)): '⢆',
    ((0, 1), (1, 0), (0, 0), (0, 0)): '⠊',
    ((0, 1), (1, 1), (0, 0), (0, 0)): '⠚',
    ((0, 1), (1, 1), (0, 1), (0, 0)): '⠺',
    ((0, 1), (1, 1), (0, 1), (1, 0)): '⡺',
    ((0, 1), (1, 1), (0, 1), (1, 1)): '⣺',
    ((0, 1), (1, 1), (0, 1), (0, 1)): '⢺',
    ((0, 1), (1, 1), (0, 0), (1, 0)): '⡚',
    ((0, 1), (1, 1), (0, 0), (1, 1)): '⣚',
    ((0, 1), (1, 1), (0, 0), (0, 1)): '⢚',
    ((0, 1), (1, 0), (0, 1), (0, 0)): '⠪',
    ((0, 1), (1, 0), (0, 1), (1, 0)): '⡪',
    ((0, 1), (1, 0), (0, 1), (1, 1)): '⣪',
    ((0, 1), (1, 0), (0, 1), (0, 1)): '⢪',
    ((0, 1), (1, 0), (0, 0), (1, 0)): '⡊',
    ((0, 1), (1, 0), (0, 0), (1, 1)): '⣊',
    ((0, 1), (1, 0), (0, 0), (0, 1)): '⢊',
    ((0, 0), (1, 1), (0, 0), (0, 0)): '⠒',
    ((0, 0), (1, 1), (0, 1), (0, 0)): '⠲',
    ((0, 0), (1, 1), (0, 1), (1, 0)): '⡲',
    ((0, 0), (1, 1), (0, 1), (1, 1)): '⣲',
    ((0, 0), (1, 1), (0, 1), (0, 1)): '⢲',
    ((0, 0), (1, 1), (0, 0), (1, 0)): '⡒',
    ((0, 0), (1, 1), (0, 0), (1, 1)): '⣒',
    ((0, 0), (1, 1), (0, 0), (0, 1)): '⢒',
    ((0, 0), (1, 0), (0, 1), (0, 0)): '⠢',
    ((0, 0), (1, 0), (0, 1), (1, 0)): '⡢',
    ((0, 0), (1, 0), (0, 1), (1, 1)): '⣢',
    ((0, 0), (1, 0), (0, 1), (0, 1)): '⢢',
    ((0, 0), (1, 0), (0, 0), (1, 0)): '⡂',
    ((0, 0), (1, 0), (0, 0), (1, 1)): '⣂',
    ((0, 0), (1, 0), (0, 0), (0, 1)): '⢂',
    ((0, 0), (0, 0), (1, 0), (0, 0)): '⠄',
    ((0, 1), (0, 0), (1, 0), (0, 0)): '⠌',
    ((0, 1), (0, 1), (1, 0), (0, 0)): '⠜',
    ((0, 1), (0, 1), (1, 1), (0, 0)): '⠼',
    ((0, 1), (0, 1), (1, 1), (1, 0)): '⡼',
    ((0, 1), (0, 1), (1, 1), (1, 1)): '⣼',
    ((0, 1), (0, 1), (1, 1), (0, 1)): '⢼',
    ((0, 1), (0, 1), (1, 0), (1, 0)): '⡜',
    ((0, 1), (0, 1), (1, 0), (1, 1)): '⣜',
    ((0, 1), (0, 1), (1, 0), (0, 1)): '⢜',
    ((0, 1), (0, 0), (1, 1), (0, 0)): '⠬',
    ((0, 1), (0, 0), (1, 1), (1, 0)): '⡬',
    ((0, 1), (0, 0), (1, 1), (1, 1)): '⣬',
    ((0, 1), (0, 0), (1, 1), (0, 1)): '⢬',
    ((0, 1), (0, 0), (1, 0), (1, 0)): '⡌',
    ((0, 1), (0, 0), (1, 0), (1, 1)): '⣌',
    ((0, 1), (0, 0), (1, 0), (0, 1)): '⢌',
    ((0, 0), (0, 1), (1, 0), (0, 0)): '⠔',
    ((0, 0), (0, 1), (1, 1), (0, 0)): '⠴',
    ((0, 0), (0, 1), (1, 1), (1, 0)): '⡴',
    ((0, 0), (0, 1), (1, 1), (1, 1)): '⣴',
    ((0, 0), (0, 1), (1, 1), (0, 1)): '⢴',
    ((0, 0), (0, 1), (1, 0), (1, 0)): '⡔',
    ((0, 0), (0, 1), (1, 0), (1, 1)): '⣔',
    ((0, 0), (0, 1), (1, 0), (0, 1)): '⢔',
    ((0, 0), (0, 0), (1, 1), (0, 0)): '⠤',
    ((0, 0), (0, 0), (1, 1), (1, 0)): '⡤',
    ((0, 0), (0, 0), (1, 1), (1, 1)): '⣤',
    ((0, 0), (0, 0), (1, 1), (0, 1)): '⢤',
    ((0, 0), (0, 0), (1, 0), (1, 0)): '⡄',
    ((0, 0), (0, 0), (1, 0), (1, 1)): '⣄',
    ((0, 0), (0, 0), (1, 0), (0, 1)): '⢄',
    ((0, 1), (0, 0), (0, 0), (0, 0)): '⠈',
    ((0, 1), (0, 1), (0, 0), (0, 0)): '⠘',
    ((0, 1), (0, 1), (0, 1), (0, 0)): '⠸',
    ((0, 1), (0, 1), (0, 1), (1, 0)): '⡸',
    ((0, 1), (0, 1), (0, 1), (1, 1)): '⣸',
    ((0, 1), (0, 1), (0, 1), (0, 1)): '⢸',
    ((0, 1), (0, 1), (0, 0), (1, 0)): '⡘',
    ((0, 1), (0, 1), (0, 0), (1, 1)): '⣘',
    ((0, 1), (0, 1), (0, 0), (0, 1)): '⢘',
    ((0, 1), (0, 0), (0, 1), (0, 0)): '⠨',
    ((0, 1), (0, 0), (0, 1), (1, 0)): '⡨',
    ((0, 1), (0, 0), (0, 1), (1, 1)): '⣨',
    ((0, 1), (0, 0), (0, 1), (0, 1)): '⢨',
    ((0, 1), (0, 0), (0, 0), (1, 0)): '⡈',
    ((0, 1), (0, 0), (0, 0), (1, 1)): '⣈',
    ((0, 1), (0, 0), (0, 0), (0, 1)): '⢈',
    ((0, 0), (0, 1), (0, 0), (0, 0)): '⠐',
    ((0, 0), (0, 1), (0, 1), (0, 0)): '⠰',
    ((0, 0), (0, 1), (0, 1), (1, 0)): '⡰',
    ((0, 0), (0, 1), (0, 1), (1, 1)): '⣰',
    ((0, 0), (0, 1), (0, 1), (0, 1)): '⢰',
    ((0, 0), (0, 1), (0, 0), (1, 0)): '⡐',
    ((0, 0), (0, 1), (0, 0), (1, 1)): '⣐',
    ((0, 0), (0, 1), (0, 0), (0, 1)): '⢐',
    ((0, 0), (0, 0), (0, 1), (0, 0)): '⠠',
    ((0, 0), (0, 0), (0, 1), (1, 0)): '⡠',
    ((0, 0), (0, 0), (0, 1), (1, 1)): '⣠',
    ((0, 0), (0, 0), (0, 1), (0, 1)): '⢠',
    ((0, 0), (0, 0), (0, 0), (1, 0)): '⡀',
    ((0, 0), (0, 0), (0, 0), (1, 1)): '⣀',
    ((0, 0), (0, 0), (0, 0), (0, 1)): '⢀',
}


def create_braille_sparkline(
    data: typing.Sequence[int | float],
    width: int,
    height: int | None,
) -> str:
    import numpy as np

    indices = np.linspace(0, len(data) - 1, 2 * width, dtype=int)
    samples: np.ndarray[typing.Any, np.dtype[np.int64]] = np.array(
        [data[index] for index in indices]
    )

    ymin = samples.min()
    ymax = samples.max()
    dy = ymax - ymin

    if height is None:
        height = 1

    grid = {
        'n_rows': 4 * height,
        'n_columns': 2 * width,
        'xmin': 0,
        'xmax': 2 * width,
        'ymin': ymin - 0.1 * dy,
        'ymax': ymax + 0.1 * dy,
    }
    raster = raster_utils.rasterize_by_lines(yvals=samples, grid=grid)  # type: ignore

    return render_utils.render_supergrid(
        raster,
        rows_per_cell=4,
        columns_per_cell=2,
        char_dict=braille_dict,
    )
