# References
For further research and developments, use the following references to start.

------------

## FireSQL
- PyFireSQL <https://github.com/bennycheung/PyFireSQL>
  - PyPi <https://pypi.org/project/pyfiresql/>

## Firebase Python
- Google Cloud Firestore <https://firebase.google.com/products/firestore>
- Google Cloud Firestore Python Client SDK <https://googleapis.dev/python/firestore/latest/client.html>
- Firebase Admin SDK Documentation <https://firebase.google.com/docs/admin/setup>

## Language Parsing
- Gabriele Tomassetti, Parsing In Python: Tools And Libraries, <https://tomassetti.me/parsing-in-python/>
- Lark Documentation <https://lark-parser.readthedocs.io/en/latest/>
  - Code Repo: [lark-parser](https://github.com/lark-parser/lark) 

## Similar Projects
The following projects inspired PyFireSQL development. They have a different purpose or different base language.
- From SQL to Ibis Parsing - sql_to_ibis <https://github.com/zbrookle/sql_to_ibis>
  - `sql_to_ibis` is a Python package that translates SQL syntax into [ibis](https://github.com/ibis-project/ibis) expressions. This provides the capability of using only one SQL dialect to target many different backends.
- Ibis: Python data analysis framework for Hadoop and SQL engines, <https://ibis-project.org/docs/dev/>
  - Code Repo: <https://github.com/ibis-project/ibis>
  - Ibis is a Python framework to access data and perform analytical computations from different sources, in a standard way.
- FireSQL (Node.js - Typescript) Project, <https://firebaseopensource.com/projects/jsayol/firesql/>
  - Code Repo: <https://github.com/jsayol/firesql>
  - FireSQL is a library built on top of the official Firebase SDK that allows you to query Cloud Firestore using SQL syntax. It's smart enough to issue the minimum amount of queries necessary to the Firestore servers in order to get the data that you request.