"""
Corporal commands
"""

import sys

from rattail import commands

from corporal import __version__


def main(*args):
    """
    Main entry point for Corporal command system
    """
    args = list(args or sys.argv[1:])
    cmd = Command()
    cmd.run(*args)


class Command(commands.Command):
    """
    Main command for Corporal
    """
    name = 'corporal'
    version = __version__
    description = "Corporal (custom Rattail system)"
    long_description = ''


class HelloWorld(commands.Subcommand):
    """
    The requisite 'hello world' example
    """
    name = 'hello'
    description = __doc__.strip()

    def run(self, args):
        self.stdout.write("hello world!\n")
