% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionality_reduction.R
\name{run_tsne}
\alias{run_tsne}
\title{Run t-SNE on the MOFA factors}
\usage{
run_tsne(object, factors = "all", groups = "all", ...)
}
\arguments{
\item{object}{a trained \code{\link{MOFA}} object.}

\item{factors}{character vector with the factor names, or numeric vector with the indices of the factors to use, or "all" to plot all factors.}

\item{groups}{character vector with the groups names, or numeric vector with the indices of the groups of samples to use, or "all" to use samples from all groups.}

\item{...}{arguments passed to \code{\link{Rtsne}}}
}
\value{
Returns a \code{\link{MOFA}} object with the dim_red slot filled with the t-SNE output
}
\description{
Run t-SNE on the MOFA factors
}
\details{
use set.seed before the function call to get reproducible results.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)

# Run t-SNE
\dontrun{ model <- run_tsne(model) }

# Change hyperparameters passed to Rtsne
\dontrun{ model <- run_tsne(model, perplexity = 15) }

}
