% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mefisto.R
\name{get_default_smooth_options}
\alias{get_default_smooth_options}
\title{Get default options for smooth covariates}
\usage{
get_default_smooth_options(object)
}
\arguments{
\item{object}{an untrained \code{\link{MOFA}} object}
}
\value{
Returns a list with default options for the smooth covariate(s) functionality.
}
\description{
Function to obtain the default options for the usage of smooth covariates with MEFISTO
}
\details{
The options are the following: \cr
\itemize{
 \item{\strong{scale_cov}:}  logical: Scale covariates?
 \item{\strong{start_opt}:} integer: First iteration to start the optimisation of GP hyperparameters
 \item{\strong{n_grid}:} integer: Number of points for the grid search in the optimisation of GP hyperparameters
 \item{\strong{opt_freq}:} integer: Frequency of optimisation of GP hyperparameters
 \item{\strong{sparseGP}:} logical: Use sparse GPs to speed up the optimisation of the GP parameters?
 \item{\strong{frac_inducing}:} numeric between 0 and 1: Fraction of samples to use as inducing points (only relevant if sparseGP is \code{TRUE})
 \item{\strong{warping}:}   logical: Activate warping functionality to align covariates between groups (requires a multi-group design)
 \item{\strong{warping_freq}:} numeric: frequency of the warping (only relevant if warping is \code{TRUE})
 \item{\strong{warping_ref}:} A character specifying the reference group for warping (only relevant if warping is \code{TRUE})
 \item{\strong{warping_open_begin}:} logical: Warping: Allow for open beginning? (only relevant warping is \code{TRUE})
 \item{\strong{warping_open_end}:} logical: Warping: Allow for open end? (only relevant warping is \code{TRUE})
 \item{\strong{model_groups}:} logical: Model covariance structure across groups? If FALSE, we assume the same patterns in all groups.
 \item{\strong{new_values}:} Values for which to predict the factor values (for interpolation / extrapolation). 
 This should be numeric matrix in the same format with covariate(s) in rows and new values in columns.
 Default is NULL, leading to no interpolation.
}
}
\examples{
# generate example data
dd <- make_example_data(sample_cov = seq(0,1,length.out = 200), n_samples = 200,
n_factors = 4, n_features = 200, n_views = 4, lscales = c(0.5, 0.2, 0, 0))
# input data
data <- dd$data
# covariate matrix with samples in columns
time <- dd$sample_cov
rownames(time) <- "time"

# create mofa and set covariates
sm <- create_mofa(data = dd$data)
sm <- set_covariates(sm, covariates = time)

smooth_opt <- get_default_smooth_options(sm)
}
