from setuptools import setup, find_packages

install_requires = [
    "numpy>=1.15",
    "pymongo>=3.7",
    "pandas",
    "sacred>=0.8.1",
    "pyyaml",
    "jsonpickle>=1.2, <2.0",
    "munch>=2.0.4",
]

with open("README.md", "r") as fh:
    long_description = fh.read()

setup(
    name='seml',
    version='0.2.1',
    description='Slurm Experiment Management Library',
    long_description=long_description,
    long_description_content_type="text/markdown",
    url='http://github.com/TUM-DAML/seml',
    author='DAML Group @ TUM',
    author_email='zuegnerd@in.tum.de, klicpera@in.tum.de',
    packages=find_packages('.'),
    entry_points={
            'console_scripts': [
                'seml = seml.main:main'
            ]
    },
    install_requires=install_requires,
    python_requires='>=3.6',
    zip_safe=False,
)
