#!/usr/bin/env python
# -*- coding: ascii -*-
from __future__ import print_function

# NOTICE... this file is generated by TkGridGUI.
# Any code or comments added by the user must be in designated areas ONLY.
# User additions will be lost if they are placed in code-generated areas.
# (i.e. Saving from TkGridGUI will over-write code-generated areas.)

# TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "imports"


from __future__ import unicode_literals
from future import standard_library
standard_library.install_aliases()
from builtins import str
from builtins import range
from builtins import object

from tkinter.ttk import Combobox, Progressbar, Separator, Treeview, Notebook

from tkinter import *
from tkinter import Button, Canvas, Checkbutton, Entry, Frame, Label, LabelFrame
from tkinter import Listbox, Message, Radiobutton, Spinbox, Text
from tkinter import OptionMenu
import tkinter.filedialog
from tkinter import _setit as set_command


# >>>>>>insert any user code below this comment for section "imports"
# Place any user import statements here
import os, sys
import io
import traceback
import webbrowser

import numpy as np
from PIL import ImageTk, Image
import matplotlib
import matplotlib.pyplot as plt
import pylab
prop_cycle = pylab.rcParams['axes.prop_cycle']
colorsL = prop_cycle.by_key()['color']

from tkinter import scrolledtext 
from tkinter.ttk import Style
from tkinter import messagebox

from rocketisp.rocket_isp import RocketThruster
from rocketisp.geometry import Geometry
from rocketisp.injector import Injector, modeSvnD, temperature_clamp
from rocketisp.stream_tubes import CoreStream, BarrierStream
from rocketisp.efficiencies import Efficiencies, Efficiency
from rocketisp.mr_range import MRrange

from rocketisp.gui.get_value_w_units_Dialog import _get_value_w_units
from rocketisp.gui.get_value_v2_Dialog import _get_value_v2
from rocketisp.gui.get_eff_value_Dialog import _get_eff_value
from rocketisp.gui.propellants_Dialog import _propellants
from rocketisp.gui.select_recent_file_Dialog import _select_recent_file
from rocketisp.unit_conv_data import get_value  #( inp_val=20.0, inp_units='degC', out_units='degK')
from rocketisp.cast import floatCast, max_precision_float_str

from rocketisp.gui.tooltip import CreateToolTip

from rocketisp.gui.config_file import ConfigInterface
from rocketisp.gui.recent_files import RecentFiles
from rocketisp.gui.global_vars import reset_vars_to_default, set_user_vals_and_units, set_eff_vals_and_const,\
                        user_valueD, user_unitsD, cat_unitsD, default_valueD,\
                        unitsD,descriptionD,efficiencyD,eff_constD,eff_descD,eff_default_valD,\
                        eff_default_constD, value_clampD
from rocketisp.gui.global_vars import GeometryL, CoreStreamL, BarrierL, RocketThrusterL, InjectorL, Injector_3L, \
                        EfficienciesL, parse_value, EfficienciesD


# TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "top_of_init"
class _tk_thruster:
    def __init__(self, master):
    
        grid_frame = Frame( master )
        self.grid_frame = grid_frame
        grid_frame.pack(expand=1, fill=BOTH)
        self.master = master
        
        self.x, self.y, self.w, self.h = 10, 10, 732, 745

        self.master.title("tk_thruster")

        self.RadioGroup_1_StringVar = StringVar()
        self.RadioGroup_2_StringVar = StringVar()
        self.RadioGroup_3_StringVar = StringVar()

        self.make_Frame_1( self.grid_frame )           #       Frame:  at Main(2,2)
        self.make_Notebook_1( self.grid_frame )        #    Notebook:  at Main(2,1)
        self.make_Button_1( self.Frame_1 )             #      Button: Set Throat Size : at Frame_1(2,1)
        self.make_Button_2( self.Frame_1 )             #      Button: Set Thrust : at Frame_1(2,2)
        self.make_Canvas_1( self.Frame_1 )             #      Canvas:  at Frame_1(3,1)
        self.make_Text_1( self.Frame_1 )               #        Text:  at Frame_1(1,1)
        self.make_Tab_1( self.Notebook_1 )             #         Tab: Inputs to RocketIsp : at Notebook_1(1,1)
        self.make_Tab_2( self.Notebook_1 )             #         Tab: Output from RocketIsp : at Notebook_1(2,1)
        self.make_Tab_3( self.Notebook_1 )             #         Tab: Plot of Ideal Isp : at Notebook_1(3,1)
        self.make_Tab_4( self.Notebook_1 )             #         Tab: Injector Inputs : at Notebook_1(4,1)
        self.make_Frame_2( self.Tab_1 )                #       Frame:  at Tab_1(1,0)
        self.make_Frame_3( self.Tab_1 )                #       Frame:  at Tab_1(1,1)
        self.make_Frame_4( self.Tab_1 )                #       Frame:  at Tab_1(1,2)
        self.make_Label_1( self.Tab_1 )                #       Label: Click Buttons to Set Values : at Tab_1(2,0)
        self.make_Text_2( self.Tab_2 )                 #        Text:  at Tab_2(1,1)
        self.make_Canvas_2( self.Tab_3 )               #      Canvas:  at Tab_3(1,1)
        self.make_LabelFrame_1( self.Tab_4 )           #  LabelFrame: Fluid Properties : at Tab_4(1,1)
        self.make_LabelFrame_2( self.Tab_4 )           #  LabelFrame: Injector Pressure Drop : at Tab_4(2,1)
        self.make_LabelFrame_3( self.Tab_4 )           #  LabelFrame: Element Design : at Tab_4(3,1)
        self.make_LabelFrame_4( self.Tab_4 )           #  LabelFrame: Element Frequency : at Tab_4(4,1)
        self.make_Label_2( self.LabelFrame_1 )         #       Label: Oxidizer : at LabelFrame_1(0,1)
        self.make_Label_3( self.LabelFrame_1 )         #       Label: Fuel : at LabelFrame_1(0,2)
        self.make_Label_4( self.LabelFrame_2 )         #       Label: Oxidizer : at LabelFrame_2(0,1)
        self.make_Label_7( self.LabelFrame_2 )         #       Label: Fuel : at LabelFrame_2(0,2)
        self.make_Label_11( self.LabelFrame_3 )        #       Label:  at LabelFrame_3(4,1)
        self.make_Label_12( self.LabelFrame_3 )        #       Label:  at LabelFrame_3(1,1)
        self.make_Label_5( self.LabelFrame_3 )         #       Label: Oxidizer : at LabelFrame_3(5,1)
        self.make_Label_8( self.LabelFrame_3 )         #       Label: Fuel : at LabelFrame_3(5,2)
        self.make_RadioGroup_1( self.LabelFrame_3 )    #  RadioGroup: Set Number of Elements By: : at LabelFrame_3(0,2)
        self.make_RadioGroup_2( self.LabelFrame_3 )    #  RadioGroup: Set Fuel Element Type : at LabelFrame_3(0,3)
        self.make_Radiobutton_1( self.RadioGroup_1 )   # Radiobutton: Acoustic Frequency : at RadioGroup_1(1,1)
        self.make_Radiobutton_2( self.RadioGroup_1 )   # Radiobutton: Element Density : at RadioGroup_1(2,1)
        self.make_Radiobutton_3( self.RadioGroup_1 )   # Radiobutton: Input Number : at RadioGroup_1(3,1)
        self.make_Radiobutton_4( self.RadioGroup_2 )   # Radiobutton: Like-on-Like : at RadioGroup_2(1,1)
        self.make_Radiobutton_5( self.RadioGroup_2 )   # Radiobutton: Unlike : at RadioGroup_2(2,1)
        self.make_Label_13( self.LabelFrame_4 )        #       Label: Design Chamber Mode : at LabelFrame_4(1,2)
        self.make_Listbox_1( self.LabelFrame_4 )       #     Listbox:  at LabelFrame_4(2,2)
        self.make_RadioGroup_3( self.LabelFrame_4 )    #  RadioGroup: Set Limiting Frequency By: : at LabelFrame_4(2,1)
        self.make_Radiobutton_6( self.RadioGroup_3 )   # Radiobutton: mode : at RadioGroup_3(1,1)
        self.make_Radiobutton_7( self.RadioGroup_3 )   # Radiobutton: freq : at RadioGroup_3(2,1)

        self.grid_frame.rowconfigure(2, weight=1)
        self.Frame_1.rowconfigure(3, weight=1)
        self.Tab_1.rowconfigure(1, weight=1)
        self.Tab_2.rowconfigure(1, weight=1)
        self.Tab_3.rowconfigure(1, weight=1)
        self.Tab_4.rowconfigure(4, weight=1)
        self.grid_frame.columnconfigure(1, weight=5)
        self.grid_frame.columnconfigure(2, weight=1)
        self.Frame_1.columnconfigure(1, weight=1)
        self.Frame_1.columnconfigure(2, weight=1)
        self.LabelFrame_4.columnconfigure(2, weight=1)
        self.LabelFrame_4.columnconfigure(1, weight=1)
        self.Notebook_1.columnconfigure(1, weight=1)
        self.Tab_1.columnconfigure(0, weight=1)
        self.Tab_1.columnconfigure(2, weight=1)
        self.Tab_1.columnconfigure(1, weight=1)
        self.Tab_2.columnconfigure(1, weight=1)
        self.Tab_3.columnconfigure(1, weight=1)
        self.Tab_4.columnconfigure(1, weight=1)

        
        # make a Status Bar
        self.statusMessage = StringVar()
        self.statusMessage.set("")
        self.statusbar = Label(self.master, textvariable=self.statusMessage, bd=1, relief=SUNKEN)
        self.statusbar.pack(anchor=SW, fill=X, side=BOTTOM)


        self.RadioGroup_1_StringVar.set("1")
        self.RadioGroup_1_StringVar_traceName = self.RadioGroup_1_StringVar.trace_variable("w", self.RadioGroup_1_StringVar_Callback)
        self.RadioGroup_2_StringVar.set("4")
        self.RadioGroup_2_StringVar_traceName = self.RadioGroup_2_StringVar.trace_variable("w", self.RadioGroup_2_StringVar_Callback)
        self.RadioGroup_3_StringVar.set("6")
        self.RadioGroup_3_StringVar_traceName = self.RadioGroup_3_StringVar.trace_variable("w", self.RadioGroup_3_StringVar_Callback)

        self.menuBar = Menu(master, relief = "raised", bd=2)

        top_File = Menu(self.menuBar, tearoff=0)

        top_File.add("command", label = "New", command=self.menu_File_New, underline=0, accelerator="Ctrl+N")
        top_File.add("command", label = "Open", command=self.menu_File_Open, underline=0, accelerator="Ctrl+O")
        top_File.add("command", label = "Recent", command=self.menu_File_Recent, underline=0, accelerator="Ctrl+R")
        top_File.add("command", label = "Save", command=self.menu_File_Save, underline=0, accelerator="Ctrl+S")
        top_File.add("command", label = "SaveAs", command=self.menu_File_SaveAs, underline=1, accelerator="Ctrl+A")
        top_File.add_separator()
        top_File.add("command", label = "SaveHTML", command=self.menu_File_SaveHTML, underline=2, accelerator="Ctrl+V")
        top_File.add_separator()
        top_File.add("command", label = "Exit", command=self.menu_File_Exit, underline=0, accelerator="Ctrl+E")
        self.menuBar.add("cascade", label="File", menu=top_File)

        top_Common_Tasks = Menu(self.menuBar, tearoff=0)

        top_Common_Tasks.add("command", label = "Set Throat Size", command=self.menu_Common_Tasks_Set_Throat_Size, underline=2, accelerator="Ctrl+T")
        top_Common_Tasks.add("command", label = "Set Thrust", command=self.menu_Common_Tasks_Set_Thrust, underline=5, accelerator="Ctrl+H")
        top_Common_Tasks.add("command", label = "Set MR to Max Isp", command=self.menu_Common_Tasks_Set_MR_to_Max_Isp, underline=4, accelerator="Ctrl+M")
        top_Common_Tasks.add("command", label = "Set MRthruster given FFC", command=self.menu_Common_Tasks_Set_MRthruster_given_FFC, underline=9, accelerator="Ctrl+U")
        top_Common_Tasks.add("command", label = "Set Nozzle Pexit", command=self.menu_Common_Tasks_Set_Nozzle_Pexit, underline=6, accelerator="Ctrl+Z")
        top_Common_Tasks.add("command", label = "Plot Efficiencies", command=self.menu_Common_Tasks_Plot_Efficiencies, underline=0, accelerator="Ctrl+P")
        top_Common_Tasks.add("command", label = "Plot Isp Delivered", command=self.menu_Common_Tasks_Plot_Isp_Delivered, underline=1, accelerator="Ctrl+L")
        self.menuBar.add("cascade", label="Common Tasks", menu=top_Common_Tasks)
        self.menuBar.add("command", label = "Help", command=self.menu_Help , accelerator="Ctrl+2")

        master.config(menu=self.menuBar)




        # use both upper and lower characters for keyboard accelerator options.
        self.master.bind("<Control-N>", lambda event: self.menu_File_New())
        self.master.bind("<Control-n>", lambda event: self.menu_File_New())
        self.master.bind("<Control-O>", lambda event: self.menu_File_Open())
        self.master.bind("<Control-o>", lambda event: self.menu_File_Open())
        self.master.bind("<Control-R>", lambda event: self.menu_File_Recent())
        self.master.bind("<Control-r>", lambda event: self.menu_File_Recent())
        self.master.bind("<Control-S>", lambda event: self.menu_File_Save())
        self.master.bind("<Control-s>", lambda event: self.menu_File_Save())
        self.master.bind("<Control-A>", lambda event: self.menu_File_SaveAs())
        self.master.bind("<Control-a>", lambda event: self.menu_File_SaveAs())
        self.master.bind("<Control-V>", lambda event: self.menu_File_SaveHTML())
        self.master.bind("<Control-v>", lambda event: self.menu_File_SaveHTML())
        self.master.bind("<Control-E>", lambda event: self.menu_File_Exit())
        self.master.bind("<Control-e>", lambda event: self.menu_File_Exit())
        self.master.bind("<Control-T>", lambda event: self.menu_Common_Tasks_Set_Throat_Size())
        self.master.bind("<Control-t>", lambda event: self.menu_Common_Tasks_Set_Throat_Size())
        self.master.bind("<Control-H>", lambda event: self.menu_Common_Tasks_Set_Thrust())
        self.master.bind("<Control-h>", lambda event: self.menu_Common_Tasks_Set_Thrust())
        self.master.bind("<Control-M>", lambda event: self.menu_Common_Tasks_Set_MR_to_Max_Isp())
        self.master.bind("<Control-m>", lambda event: self.menu_Common_Tasks_Set_MR_to_Max_Isp())
        self.master.bind("<Control-U>", lambda event: self.menu_Common_Tasks_Set_MRthruster_given_FFC())
        self.master.bind("<Control-u>", lambda event: self.menu_Common_Tasks_Set_MRthruster_given_FFC())
        self.master.bind("<Control-Z>", lambda event: self.menu_Common_Tasks_Set_Nozzle_Pexit())
        self.master.bind("<Control-z>", lambda event: self.menu_Common_Tasks_Set_Nozzle_Pexit())
        self.master.bind("<Control-P>", lambda event: self.menu_Common_Tasks_Plot_Efficiencies())
        self.master.bind("<Control-p>", lambda event: self.menu_Common_Tasks_Plot_Efficiencies())
        self.master.bind("<Control-L>", lambda event: self.menu_Common_Tasks_Plot_Isp_Delivered())
        self.master.bind("<Control-l>", lambda event: self.menu_Common_Tasks_Plot_Isp_Delivered())
        self.master.bind("<Control-2>", lambda event: self.menu_Help())
        self.master.bind("<Control-2>", lambda event: self.menu_Help())
        # >>>>>>insert any user code below this comment for section "top_of_init"
        # ==================================================================================
        self.ttk_style = Style()
        self.ttk_style.configure('TNotebook.Tab', font=('TkDefaultFont','11','italic'),
                                  padding=(22,6))
        
        self.master.protocol("WM_DELETE_WINDOW", self.cleanupOnQuit)
        #self.master.geometry( '+2000+10' )
        self.master.geometry("1068x700")
        
        self.master.bind("<<NotebookTabChanged>>", self.tab_change)
        #self.RadioGroup_1_StringVar.set("acoustics")
        
        self.resize_active = False
        self.master.bind('<Configure>', self.resize)
        self.tk_photoimg = False # image of thruster shown on Canvas_1
        self.tk_photoimg_2 = False # image of Isp ODE, ODK, ODF shown on Canvas_2
        self.tk_blank_img = False
        self.imgTargObj = False   # canvas object, image of thruster shown on Canvas_1
        self.imgTargObj_2 = False # canvas object, image of Isp ODE, ODK, ODF shown on Canvas_2
        
        self.stringvar_callback_is_active = True # a kludge to deactivate radio button callback (in lieu of trace_vdelete)
        
        self.recent_rocketisp = RecentFiles( config_file_prefix='RocketIspGUI' )
        self.current_filePath = ''
        self.current_fileName = ''


        self.statusMessage.set("Welcome to tk_thruster")

        self.buttonD = {} # key=variable name, value=tkinter Button object
        self.max_len_vnameD = {} # key=variable name, value=max variable length in group
        self.btn_tooltipD = {} # key=variable name, value=tooltip object

        # build initial default thruster for use by build_buttons
        self.geomObj = Geometry()
        self.effObj = Efficiencies()
        self.coreObj = CoreStream( self.geomObj, self.effObj )
        self.injObj = Injector( self.coreObj )
        self.thruster = RocketThruster(name='Dummy Thruster',coreObj=self.coreObj, injObj=self.injObj)
        self.build_buttons()
        
        self.tabidD = {} # key=tab text, value=tabid 
        for tabid in self.Notebook_1.tabs():
            self.tabidD[ self.Notebook_1.tab(tabid, "text") ] = tabid
        self.plot_efficiencies = False
        
        
        # build thruster from default values
        reset_vars_to_default()
        self.thruster = None
        self.build_new_thruster_from_user_values()

        #self.set_all_labels_from_thruster()
        self.put_thruster_on_canvas()
        
        self.resize_active = True
        
        self.changes_since_last_save = False
        
    def cleanupOnQuit(self):
        
        if self.changes_since_last_save:
            ans = messagebox.askquestion('Exit Application', 'Do You Want to Exit without Saving?')
        else:
            ans = 'yes'
        #print('NEED TO REACTIVATE cleanupOnQuit')

        if ans == 'yes':
            self.resize_active = False
            sys.exit(1)

    def clear_all_display_output(self):
        # FIRST... clear Text_1 and Text_2 in case of a crash
        self.Text_1.delete(1.0, END)
        self.Text_2.delete(1.0, END)
        for name, btn in self.buttonD.items():
            btn.configure( text=name )
        
        
    def build_new_thruster_from_user_values(self):
        
        self.clear_all_display_output()
        
        # build these dictionaries from user values in order to create new objects.
        inp_thrusterD = {}
        inp_injObjD   = {}
        inp_coreObjD  = {}
        inp_geomObjD  = {}
        
        if self.thruster is not None:
            del self.thruster
            del self.injObj
            del self.coreObj
            del self.geomObj
            del self.effObj
    
        # create new effObj
        self.effObj = Efficiencies()
        
        # set efficiency object values from user values
        for name, value in efficiencyD.items():
            if eff_constD[name]:
                #print('setting eff',name,'to const =',value)
                self.effObj.set_const( name, value, re_evaluate=False)
            else:
                self.effObj.set_value( name, value, value_src='user input', re_evaluate=False)
        self.effObj.evaluate()
        #self.effObj.summ_print()
        
        
        def maybe_clamp(value, name):
            """Check to see if name is limited in range."""
            if name in value_clampD:
                min_value, max_value = value_clampD[name]
                if value < min_value:
                    s = 'WARNING... %s set to %g (MUST be >=%g and <=%g'%(name, min_value, min_value, max_value)
                    print( s )
                    self.statusMessage.set( s )
                    return min_value
                if value > max_value:
                    s = 'WARNING... %s set to %g (MUST be >=%g and <=%g'%(name, max_value, min_value, max_value)
                    print( s )
                    self.statusMessage.set( s )
                    return max_value
                
            return value

        def get_internal_val( name ):
            if user_valueD[name] is None:
                return None
            
            if user_unitsD[name]:
                #print(name, user_unitsD[name])
                value = get_value( inp_val=user_valueD[name], inp_units=user_unitsD[name], out_units=unitsD[name])
            else:
                value = user_valueD[name]
                
            value = maybe_clamp( value, name )
                
            #print('name:', name, '  value:',value, type(value))
            return value
        
        # set Geometry object values
        for name in GeometryL:
            value = get_internal_val(name)
            inp_geomObjD[ name ] = value
        
        # set CoreStream object values
        for name in CoreStreamL + BarrierL:
            value = get_internal_val(name)
            inp_coreObjD[ name ] = value
            
        # set RocketThruster object values
        for name in RocketThrusterL:
            value = get_internal_val(name)
            inp_thrusterD[ name ] = value
        #self.thruster.summ_print()
            
        # set Injector object values
        for name in InjectorL:
            value = get_internal_val(name)
            inp_injObjD[ name ] = value

        # if Like-on-Like, make sure there are enough fuel orifices per element.
        if inp_injObjD['lolFuelElem']:
            inp_injObjD['FuelOrfPerEl'] = max(2.0, inp_injObjD['FuelOrfPerEl'])
            inp_injObjD["dropCorrFuel"] = max(1.0, inp_injObjD["dropCorrFuel"])


        # now that inputs are available, make new thruster objects
        self.geomObj = Geometry( **inp_geomObjD )
        self.coreObj = CoreStream( self.geomObj, self.effObj, **inp_coreObjD )
        self.injObj = Injector( self.coreObj, **inp_injObjD )
        self.thruster = RocketThruster(coreObj=self.coreObj, injObj=self.injObj, **inp_thrusterD)
        
        # set user values that are calculated
        for name, value in efficiencyD.items():
            effobj = self.effObj[name]
            efficiencyD[name] = effobj.value
            eff_constD[name] = effobj.is_const
        
        
        # now set labels from new thruster object
        self.set_all_labels_from_thruster()
        
            
            

    def tab_change(self, event):
        
        selected_tab = event.widget.select()
        tab_text = event.widget.tab(selected_tab, "text")
        #print('tab_text=',tab_text   )
        if tab_text == 'Ideal Isp':
            self.put_isp_plot_on_canvas_2()
        
        
    def put_isp_plot_on_canvas_2(self):
        
        if self.tk_photoimg_2:
            self.Canvas_2.delete( self.tk_photoimg_2 )
            
        self.Canvas_2.delete("all")
        if self.imgTargObj_2:
            del self.imgTargObj_2
        
        w,h = (self.Canvas_2.winfo_width(), self.Canvas_2.winfo_height())
        

        # ............. show working... 
        self.Canvas_2.create_text(w/2,h/2, text="Working...", fill="red",
                                  font="Helvetica 14 bold roman")
        self.master.update()
        
        if self.plot_efficiencies:
            plt = self.thruster.plot_eff_curves( title='', png_name='', pixel_wh=(w,h),
                                                 do_show=False, show_grid=True, Npts=30, 
                                                 edge_frac=0.97 )
        else:
            plt = self.thruster.plot_isp_curves( title='', png_name='', pixel_wh=(w,h),
                                                 do_show=False, show_grid=True, Npts=30, 
                                                 edge_frac=0.97 )
        self.plot_efficiencies = False
                
        b = io.BytesIO()
        plt.savefig(b, format='png')
        b.seek(0)
        
        self.tk_photoimg_2 = ImageTk.PhotoImage( file=b )

        del b
        plt.clf()
                
        self.imgTargObj_2 = self.Canvas_2.create_image(0, 0, image=self.tk_photoimg_2, anchor=NW)
        
        self.master.update()

    def resize(self, event):
        
        if not self.resize_active:
            return
        
        #x = int(self.master.winfo_x())
        #y = int(self.master.winfo_y())
        #w = int(self.master.winfo_width())
        #h = int(self.master.winfo_height())
        #print( 'x,y,w,h = ', x,y,w,h )
        
        #print('........called resize')
        #for s in traceback.extract_stack():
        #    print(s)
        
        #self.put_thruster_on_canvas()
        #self.put_isp_plot_on_canvas_2()
        #pass

    def build_buttons(self):
        
        frameL = [self.Frame_2, self.Frame_3, self.Frame_4]
        
        col_labelL = ['General','Geometry','Efficiencies']
        self.labelObjL = [] # save references to column labels
        
        # ----------------- build group buttons ---------------------------
        # get the max name length in each column
        for i,varL in enumerate([CoreStreamL + BarrierL + RocketThrusterL, GeometryL, EfficienciesL]):
            max_len_varname = 1
            for vname in varL:
                max_len_varname = max(max_len_varname, len(vname))
            for vname in varL:
                self.max_len_vnameD[vname] = max_len_varname
                
            frame = frameL[ i ]
            lbl =  Label( frame , text=col_labelL[i], width="26", 
                          font="Helvetica 10 bold roman", pady=6)
            lbl.grid(row=1, column=0, sticky="ew")
            self.labelObjL.append( lbl )

            
        # build buttons for RocketThrusterL, GeometryL, CoreStreamL + BarrierL
        Last_rowL = [0,0,0] # remember last row that buttons are placed in
        for i,varL in enumerate([CoreStreamL + BarrierL + RocketThrusterL, GeometryL]):
            frame = frameL[ i ]
            #print('varL =', varL)
            for irow,vname in enumerate(varL):
                btn = Button(frame, text=vname, width=30, anchor="w",
                             command=lambda n=vname: self.gen_btn_action(n), 
                             font="Courier 9 normal roman")
                btn.grid(  row=irow+3, column=0, sticky="ew")
                Last_rowL[i] = irow+3
                
                if vname in descriptionD:
                    self.btn_tooltipD[ vname ] = CreateToolTip( btn, descriptionD[vname],
                                                                background="#FFD700") # gold
                self.buttonD[vname] =  btn

        # ----------------- build efficiency buttons in column 0 ---------------------------
        i = 2
        frame = frameL[ i ]
        Last_rowL[i] += 3
        
        for irow, vname in enumerate(EfficienciesL):
            
            btn = Button(frame, text=vname, width=30, anchor="w",
                         command=lambda n=vname: self.gen_btn_action(n), 
                         font="Courier 9 normal roman")
            btn.grid(  row=Last_rowL[i] + irow, column=0, sticky="ew")
            
            if vname in eff_descD:
                self.btn_tooltipD[ vname ] = CreateToolTip( btn, eff_descD[vname],
                                                            background="#FFD700") # gold
            self.buttonD[vname] =  btn
        Last_rowL[i] = Last_rowL[i] + irow + 1
        
        # --------------------------- build Injector design buttons --------------------
        
        # self.LabelFrame_1 = Fluid Properties
        # self.LabelFrame_2 = Injector Pressure Drop
        # self.LabelFrame_3 = Element Design
        # self.LabelFrame_4 = Element Frequency
            
        def make_btn( frame, irow, icol, vname, max_len_varname ):
            #print('before adding irow=%s, icol=%s, grid_size()=%s'%(irow, icol, str(frame.grid_size())))
            btn = Button(frame, text=vname, width=30, anchor="nw",
                         command=lambda n=vname: self.gen_btn_action(n), 
                         font="Courier 9 normal roman")
            btn.grid(  row=irow, column=icol, sticky="new")
            
            if vname in descriptionD:
                self.btn_tooltipD[ vname ] = CreateToolTip( btn, descriptionD[vname],
                                                            background="#FFD700") # gold
            self.buttonD[vname] =  btn
            
            self.max_len_vnameD[vname] = max_len_varname
            #print('after adding irow=%s, icol=%s, grid_size()=%s\n'%(irow, icol, str(frame.grid_size())))
            return btn
        
        # self.LabelFrame_1 = Fluid Properties
        _, next_row = self.LabelFrame_1.grid_size()
        make_btn( self.LabelFrame_1, next_row, 1, 'Tox', 5 )
        make_btn( self.LabelFrame_1, next_row, 2, 'Tfuel', 5 )
        
        # self.LabelFrame_2 = Injector Pressure Drop
        _, next_row = self.LabelFrame_2.grid_size()
        make_btn( self.LabelFrame_2, next_row, 1, 'fdPinjOx', 9 )
        make_btn( self.LabelFrame_2, next_row, 2, 'fdPinjFuel', 9 )

        _, next_row = self.LabelFrame_2.grid_size()
        make_btn( self.LabelFrame_2, next_row, 1, 'dpOxInp', 9 )
        make_btn( self.LabelFrame_2, next_row, 2, 'dpFuelInp', 9 )

        # self.LabelFrame_3 = Element Design
        for irow, name in enumerate(['elemDensInp', 'NelementsInp', 'elemEm']):
            make_btn( self.LabelFrame_3, irow+2, 1, name, 12 )
        make_btn( self.LabelFrame_3, irow+2, 2, 'DorfMin', 12 )

        for i in range(6, len(Injector_3L), 2):
            _, next_row = self.LabelFrame_3.grid_size()
            make_btn( self.LabelFrame_3, next_row, 1, Injector_3L[i], 12 )
            make_btn( self.LabelFrame_3, next_row, 2, Injector_3L[i+1], 14 )
        
        # self.LabelFrame_4 = Element Frequency
        btn = make_btn( self.LabelFrame_4, 1, 1, 'desFreqInp', 10 )
        btn.configure( anchor='center' )
        
        
    def set_all_labels_from_thruster(self):
        """
        Some thruster variables can be either input or calculated so 
        need to get values from thruster
        """
        # FIRST... clear Text_1 and Text_2 in case of a crash
        self.clear_all_display_output()
        #self.Text_1.delete(1.0, END)
        #self.Text_2.delete(1.0, END)
        #for name, btn in self.buttonD.items():
        #    btn.configure( text=name )
        
        
        # set some controls to the value indicated by thruster object.
        self.stringvar_callback_is_active = False
        self.RadioGroup_1_StringVar.set( self.injObj.setNelementsBy )
        
        if self.injObj.lolFuelElem:
            self.RadioGroup_2_StringVar.set("Like-on-Like")
        else:
            self.RadioGroup_2_StringVar.set("Unlike")
        
        
        self.set_listbox_1_by_value( self.injObj.desAcousMode )
        self.RadioGroup_3_StringVar.set( self.injObj.setAcousticFreqBy )
            
        self.stringvar_callback_is_active = True

        # start iterating through RocketIsp objects
        objL = [self.geomObj, self.coreObj, self.coreObj.barrierObj, self.injObj, self.thruster]
        
        def format_val_str( val ):
            s = '%s'%val
            try:
                f = float( s )
                if len(s) > 8:
                    s = '%g'%val
            except:
                pass
            return s
        
        for name, btn in self.buttonD.items():
            gotit = False
            fmt = '%' + '%is'%self.max_len_vnameD[name] + ' = %s %s'
            for obj in objL:
                if hasattr( obj, name ) and (not name in EfficienciesL):
                    if name=='name':
                        btn.config( text= getattr(obj,name), anchor='center')
                    
                    else:
                        val_str = format_val_str( getattr(obj,name) )
                        if val_str == 'None':
                            units_str = ''
                            
                            # put current value as part of None button (i.e. show calculated value)
                            if name in ['LchamberInp', 'LnozInp', 'dpOxInp', 'dpFuelInp']:
                                if name=='dpOxInp':
                                    val_str = 'None (==%g)'% int(self.injObj.dpOx)
                                elif name=='dpFuelInp':
                                    val_str = 'None (==%g)'% int(self.injObj.dpFuel)
                                elif name=='LchamberInp':
                                    val_str = 'None (==%.1f)'% self.geomObj.Lcham
                                elif name=='LnozInp':
                                    val_str = 'None (==%.1f)'% self.geomObj.Lnoz
                            
                            
                        else:
                            units_str = user_unitsD.get(name,'')
                            if units_str:
                                value = get_value( inp_val=getattr(obj,name), inp_units=unitsD[name], out_units=user_unitsD[name])
                                val_str = format_val_str( value )
                        
                        btn.config( text=fmt%(name, val_str, units_str) )
                    gotit = True
            if not gotit:
                
                if name in self.effObj.effD:
                    eobj = EfficienciesD[name]
                    ipad = 4*(3 - eobj.level) - 5
                    fmt_eff = '%' + '%is'%(ipad+self.max_len_vnameD[name],) + ' = %s %s'
                    
                    if eff_constD[name]:
                        calcon = 'INPUT'
                    else:
                        calcon = 'Calc'
                        
                    val_str = format_val_str( self.effObj.effD[name].value  )
                    btn.config( text=fmt_eff%(name, val_str, calcon) )
                    gotit = True
                    
            if not gotit:
                btn.config( text=fmt%(name, 'N/A', '') )
        
        # gray out efficiency buttons that do not apply
        btn_stateD = {} # key=eff name, value="disabled" OR "normal"
        for eff_name in EfficienciesL:
            btn_stateD[eff_name] = "normal"
        if eff_constD['Isp']: # gray out all Isp children
            for cname in  ['Noz', 'Div','Kin','BL','TP', 'ERE', 'Mix','Em','Vap','HL',  'FFC']:
                btn_stateD[ cname ] = "disabled"
        else:
            if eff_constD['Noz']: # gray out all Noz children
                for cname in  [ 'Div','Kin','BL','TP']:
                    btn_stateD[ cname ] = "disabled"
            if eff_constD['ERE']: # gray out all ERE children
                for cname in  [ 'Mix','Em','Vap','HL']:
                    btn_stateD[ cname ] = "disabled"
                
        for eff_name in EfficienciesL:
            btn = self.buttonD[ eff_name ]
            if btn_stateD[ eff_name ] == "disabled":
                eobj = EfficienciesD[eff_name]
                pad = ' '*4*(3 - eobj.level)
                
                btn.config( text=pad + eff_name + ' override' )
                
            btn["state"] = btn_stateD[ eff_name ]
        
        # put thruster values into Text_1
        sL = ['      %s/%s'%( self.thruster.coreObj.oxName, self.thruster.coreObj.fuelName )]
        
        
        sL.append( 'IspVac    = %g sec'%self.thruster.coreObj.IspDel )
        
        if user_valueD['Pamb'] > 0.0:
            sL.append( 'IspAmb    = %g sec'%self.thruster.coreObj.IspAmb )
            sL.append( '   '+ self.thruster.coreObj.noz_mode )
        if self.effObj('Pulse') < 1.0:
            sL.append( 'IspPulsing    = %g sec'%self.thruster.coreObj.IspDelPulse )
        sL.append( 'MRcore    = %g'%self.thruster.coreObj.MRcore )
        if self.thruster.coreObj.barrierObj is not None:
            sL.append( 'MRthruster= %g'%self.thruster.coreObj.MRthruster )
        
        sL.append( 'Rt        = %g in'%self.thruster.geomObj.Rthrt )
        sL.append( 'At        = %g in**2'%self.thruster.geomObj.At )
        sL.append( 'Pc        = %g psia'%self.thruster.coreObj.Pc )
        sL.append( 'Fvac      = %g lbf'%self.thruster.coreObj.FvacTotal )
        if user_valueD['Pamb'] > 0.0:
            sL.append( 'Famb      = %g lbf'%self.thruster.coreObj.Fambient )
        
        mode, mode_freq, mode_msg = self.injObj.get_closest_mode()
        
        sL.append( 'cham_freq = %g Hz'%self.injObj.des_freq + mode_msg )
        if self.injObj.des_freq > 1.01*self.injObj._3T_freq:
            sL.append('    WARNING des_freq > 3T')
        
        sL.append( 'Nelements = %g'%self.injObj.Nelements + ' (set by %s)'%self.injObj.used_Nelem_criteria )
        sL.append( 'elemDens  = %g'%self.injObj.elemDensCalc + ' elem/in**2' )
        
        if self.injObj.DorfOx < self.injObj.DorfMin * 0.999:
            sL.append( 'DorfOx    = %.4f'%self.injObj.DorfOx + ' in (Violates DorfMin)' )
        else:
            try:
                ReOx = self.injObj.rhoOx * self.injObj.velOx_ips * self.injObj.DorfOx \
                         / get_value( self.injObj.viscOx, 'poise', 'lbm/s/inch')
                sRe = ' (Re=%.1e)'%ReOx
                sRe = sRe.replace('e+0','e')
            except:
                sRe = ''
            
            sL.append( 'DorfOx    = %.4f'%self.injObj.DorfOx + ' in' + sRe )
            
        if self.injObj.DorfFuel < self.injObj.DorfMin * 1.01:
            sL.append( 'DorfFuel  = %.4f'%self.injObj.DorfFuel + ' in (DorfMin=%g)'%self.injObj.DorfMin )
        else:
            try:
                ReFuel = self.injObj.rhoFuel * self.injObj.velFuel_ips * self.injObj.DorfFuel \
                         / get_value( self.injObj.viscFuel, 'poise', 'lbm/s/inch')
                sRe = ' (Re=%.1e)'%ReFuel
                sRe = sRe.replace('e+0','e')
            except:
                sRe = ''
            sL.append( 'DorfFuel  = %.4f'%self.injObj.DorfFuel + ' in' + sRe )
            
            
        out_str = '\n'.join(sL)
        self.Text_1.insert(END, out_str )
        
        # show image of thruster on Canvas_1
        self.put_thruster_on_canvas()
        
        # fill Output Text_1 tab
        out_str = self.thruster.get_summ_str()
        self.Text_2.insert(END, out_str )
        
        if self.Notebook_1.tab(self.Notebook_1.select(), "text") == 'Ideal Isp':
            self.put_isp_plot_on_canvas_2()

    
    def put_thruster_on_canvas(self):
        
        if self.tk_photoimg:
            self.Canvas_1.delete( self.tk_photoimg )
        self.Canvas_1.delete("all")
        
        try:
            del self.imgTargObj
        except:
            pass
        
        pixel_wh = (self.Canvas_1.winfo_width(), self.Canvas_1.winfo_height())
        self.master.update_idletasks()
        
        # create new plot
        s1 = max_precision_float_str(self.geomObj.Lcham)
        s2 = max_precision_float_str(self.geomObj.Lnoz)
        
        plt = self.geomObj.plot_geometry( title='Lcham=%s in, Lnoz=%s in'%( s1, s2 ), 
                                          png_name='', pixel_wh=pixel_wh,
                                          do_show=False, show_grid=True, make_vertical=True)
        b = io.BytesIO()
        plt.savefig(b, format='png')
        b.seek(0)
        #self.pil_img = Image.open( b )
        self.tk_photoimg = ImageTk.PhotoImage( file=b )

        del b
        plt.clf()
                
        self.imgTargObj = self.Canvas_1.create_image(0, 0, image=self.tk_photoimg, anchor=NW)
        
        self.master.update()
        #self.master.update_idletasks()
    
    def load_file(self, full_fname):
        
        #self.recent_rocketisp.update( full_fname )
        #self.updateRecentFileActions()
        
        head,tail = os.path.split( full_fname )
        
        self.current_filePath = head
        self.current_fileName = tail
        
        self.config_interface = ConfigInterface( config_filename=full_fname, 
                                                 sectionL=['UserInput','UserUnits','Efficiencies','EffConst'] )
        
        inputD = self.config_interface.get_dictionary()
        if 'UserInput' in inputD:
            reset_vars_to_default()
            set_user_vals_and_units( inputD['UserInput'], inputD['UserUnits'] )
            set_eff_vals_and_const( inputD['Efficiencies'], inputD['EffConst'] )
            
            self.build_new_thruster_from_user_values()
        
        self.statusMessage.set('Opened File: "%s"'%self.current_fileName)
        self.master.title("tk_thruster: " + tail + ' %s'%user_valueD["name"])
        self.changes_since_last_save = False
        #self.updateRecentFileActions()
        self.recent_rocketisp.update( full_fname )
        
        # No current changes to worry about
        #self.clear_changes() # No current changes to worry about        
        
        #self.make_ispObj_and_set_main_title()
        
    def save_file(self, full_fname):
        
        self.recent_rocketisp.update( full_fname )
        head,tail = os.path.split( full_fname )
        
        self.current_filePath = head
        self.current_fileName = tail
        
        self.config_interface = ConfigInterface( config_filename=full_fname, 
                                                 sectionL=['UserInput','UserUnits','Efficiencies','EffConst'] )
        
        for key,value in user_valueD.items():
            self.config_interface['UserInput',key] = value
        
        for key,value in user_unitsD.items():
            self.config_interface['UserUnits',key] = value

        for key,value in efficiencyD.items():
            self.config_interface['Efficiencies',key] = value

        for key,value in eff_constD.items():
            self.config_interface['EffConst',key] = value
        
        self.config_interface.save_file()
        self.statusMessage.set('Saved File: "%s"'%self.current_fileName)
        self.master.title("tk_thruster: " + tail+ ' %s'%user_valueD["name"])
        self.changes_since_last_save = False
        self.recent_rocketisp.update( full_fname )
        
        
    def get_inp_from_a_dialog(self, attr_name):
        
        if attr_name in ['oxName','fuelName']:
            
            dialog = _propellants(self.master, 'Input Propellant Combination',
                                  dialogOptions={'oxName':user_valueD["oxName"] , 
                                                 'fuelName':user_valueD["fuelName"] } )
            if dialog.result is not None:
                user_valueD["oxName"] = dialog.result["oxName"]
                user_valueD["fuelName"] = dialog.result["fuelName"]
                
                self.statusMessage.set('Propellants set to %s/%s'%( user_valueD["oxName"], 
                                                                    user_valueD["fuelName"] ))
                self.build_new_thruster_from_user_values()
                self.changes_since_last_save = True 
        
        elif attr_name in efficiencyD:
            
            dialog = _get_eff_value(self.master, "Input %s Efficiency"%attr_name, 
                     dialogOptions={'name':attr_name, 'value':efficiencyD[attr_name], 
                                    'desc':eff_descD[attr_name], 
                                    'val_type': float,
                                    'label':'%s Efficiency'%attr_name})
            
            if dialog.result is not None:
                # return value is a string
                s = dialog.result["return_value"]
                v = parse_value( s )
                
                if dialog.result["is_const"]:
                    efficiencyD[attr_name] = v
                    self.statusMessage.set('Set %s efficiency = %g'%(attr_name,v))
                else:
                    self.statusMessage.set('%s efficiency is Calculated'%(attr_name,))
                    
                    
                eff_constD[attr_name] = dialog.result["is_const"]
                
                self.build_new_thruster_from_user_values()
                self.changes_since_last_save = True 
                                    
        elif attr_name in user_valueD:
            
            if unitsD[attr_name]: 
                # attr_name HAS units
                dialogOptions = {'name':attr_name, 'units':user_unitsD[attr_name], 
                                 'value':user_valueD[attr_name], 'desc':descriptionD[attr_name]}
                                 
                # some variables allow for a None input.
                if attr_name in ['LchamberInp', 'LnozInp', 'dpOxInp', 'dpFuelInp']:
                    dialogOptions['show_none_btn'] = True
                    if attr_name=='dpOxInp':
                        dialogOptions['value'] = self.injObj.dpOx
                    elif attr_name=='dpFuelInp':
                        dialogOptions['value'] = self.injObj.dpFuel
                    elif attr_name=='LchamberInp':
                        dialogOptions['value'] = self.geomObj.Lcham
                    elif attr_name=='LnozInp':
                        dialogOptions['value'] = self.geomObj.Lnoz
                    
                    
                dialog = _get_value_w_units(self.master, "Input %s"%attr_name, dialogOptions=dialogOptions)
                
                if dialog.result is not None:
                    # return value is a string
                    s = dialog.result["return_value"]
                    v = parse_value( s )
                    user_valueD[attr_name] = v
                    user_unitsD[attr_name] = dialog.result["return_units"]
                    
                    if attr_name == 'Tox':
                        degR = get_value( inp_val=v, inp_units=user_unitsD[attr_name], out_units='degR')
                        degR, warning = temperature_clamp(degR, 'Tox', self.injObj.TminOx,   self.injObj.TmaxOx)
                        if warning:
                            messagebox.showwarning('ONLY Liquids Allowed', warning)
                            user_valueD[attr_name] = degR
                            user_unitsD[attr_name] = 'degR'
                    
                    if attr_name == 'Tfuel':
                        degR = get_value( inp_val=v, inp_units=user_unitsD[attr_name], out_units='degR')
                        degR, warning = temperature_clamp(degR, 'Tfuel', self.injObj.TminFuel,   self.injObj.TmaxFuel)
                        if warning:
                            messagebox.showwarning('ONLY Liquids Allowed', warning)
                            user_valueD[attr_name] = degR
                            user_unitsD[attr_name] = 'degR'
                    
                    try:
                        self.statusMessage.set('Set %s = %g'%(attr_name,v))
                    except:
                        self.statusMessage.set('Set %s = %s'%(attr_name,v))
                        
                    self.build_new_thruster_from_user_values()
                    self.changes_since_last_save = True 
                    
            else:
                # attr_name does NOT have units
                dialog = _get_value_v2(self.master, "Input %s"%attr_name, 
                         dialogOptions={'name':attr_name, 'value':user_valueD[attr_name], 
                                        'val_type': type(default_valueD[attr_name]), 
                                        'desc':descriptionD[attr_name]})
                
                if dialog.result is not None:
                    # return value is a string
                    s = dialog.result["return_value"]
                    v = parse_value( s )
                    user_valueD[attr_name] = v
                    
                    try:
                        self.statusMessage.set('Set %s = %g'%(attr_name,v))
                    except:
                        self.statusMessage.set('Set %s = %s'%(attr_name,v))
                    
                    # Need to modify inter-dependent inputs.
                    if attr_name=='LchmOvrDt':
                        user_valueD['LchamberInp'] = None
                        
                    elif attr_name=='CdThroat':
                        user_valueD['calc_CdThroat'] = False
                        
                    elif attr_name=='name':
                        self.master.title("tk_thruster: " + user_valueD["name"])
                    
                    elif attr_name=='pcentBell':
                        user_valueD['LnozInp'] = None
                        user_unitsD['LnozInp'] = 'in'
                    self.build_new_thruster_from_user_values()
                    self.changes_since_last_save = True 
        
    def gen_btn_action(self, name):
        #print('Button Pressed:', name)
        self.statusMessage.set('Button Pressed: "%s"'%name)
        
        self.get_inp_from_a_dialog( name )


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Frame_1"
    def make_Frame_1(self, frame):
        """       Frame:  at Main(2,2)"""
        self.Frame_1 = Frame( frame , width="60", height="50")
        self.Frame_1.grid(row=2, column=2, sticky="nsew")

        # >>>>>>insert any user code below this comment for section "make_Frame_1"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Notebook_1"
    def make_Notebook_1(self, frame):
        """    Notebook:  at Main(2,1)"""
        self.Notebook_1 = Notebook ( frame , width="400", height="700")
        self.Notebook_1.grid(row=2, column=1, sticky="nsew")

        # >>>>>>insert any user code below this comment for section "make_Notebook_1"
        self.Notebook_1.config(width='740', height='500')
        self.Notebook_1.grid(row=2, column=1, sticky="nsew")   


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Button_1"
    def make_Button_1(self, frame):
        """      Button: Set Throat Size : at Frame_1(2,1)"""
        self.Button_1 = Button( frame , text="Set Throat Size", width="15")
        self.Button_1.grid(row=2, column=1, sticky="ew")

        # >>>>>>insert any user code below this comment for section "make_Button_1"

        self.Button_1.bind("<ButtonRelease-1>", self.Button_1_Click)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Button_2"
    def make_Button_2(self, frame):
        """      Button: Set Thrust : at Frame_1(2,2)"""
        self.Button_2 = Button( frame , text="Set Thrust", width="15", font="TkDefaultFont")
        self.Button_2.grid(row=2, column=2, sticky="ew")

        # >>>>>>insert any user code below this comment for section "make_Button_2"

        self.Button_2.bind("<ButtonRelease-1>", self.Button_2_Click)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Canvas_1"
    def make_Canvas_1(self, frame):
        """      Canvas:  at Frame_1(3,1)"""
        self.Canvas_1 = Canvas( frame , width="60", height="50")
        self.Canvas_1.grid(row=3, column=1, sticky="nsew", columnspan="2")

        # >>>>>>insert any user code below this comment for section "make_Canvas_1"

        self.Canvas_1.config(bg='#ffffff')
        self.Canvas_1.bind("<ButtonRelease-1>", self.Canvas_1_Click)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Text_1"
    def make_Text_1(self, frame):
        """        Text:  at Frame_1(1,1)"""
        self.Text_1 = Text( frame , width="40", height="12")
        self.Text_1.grid(row=1, column=1, columnspan="2")

        # >>>>>>insert any user code below this comment for section "make_Text_1"
        self.Text_1.configure( height=18, width=45 )

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Tab_1"
    def make_Tab_1(self, frame):
        """         Tab: Inputs to RocketIsp : at Notebook_1(1,1)"""
        self.Tab_1 = Frame( frame )
        self.Notebook_1.add( self.Tab_1, text="Basic Inputs" )
        # >>>>>>insert any user code below this comment for section "make_Tab_1"
        #self.Notebook_1.tab(0, text='Basic Inputs   ')

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Tab_2"
    def make_Tab_2(self, frame):
        """         Tab: Output from RocketIsp : at Notebook_1(2,1)"""
        self.Tab_2 = Frame( frame )
        self.Notebook_1.add( self.Tab_2, text="Standard Output" )
        # >>>>>>insert any user code below this comment for section "make_Tab_2"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Tab_3"
    def make_Tab_3(self, frame):
        """         Tab: Plot of Ideal Isp : at Notebook_1(3,1)"""
        self.Tab_3 = Frame( frame )
        self.Notebook_1.add( self.Tab_3, text="Ideal Isp" )
        # >>>>>>insert any user code below this comment for section "make_Tab_3"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Tab_4"
    def make_Tab_4(self, frame):
        """         Tab: Injector Inputs : at Notebook_1(4,1)"""
        self.Tab_4 = Frame( frame )
        self.Notebook_1.add( self.Tab_4, text="Injector Inputs" )
        # >>>>>>insert any user code below this comment for section "make_Tab_4"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Frame_2"
    def make_Frame_2(self, frame):
        """       Frame:  at Tab_1(1,0)"""
        self.Frame_2 = Frame( frame , width="60", height="50")
        self.Frame_2.grid(row=1, column=0, sticky="nsew")

        # >>>>>>insert any user code below this comment for section "make_Frame_2"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Frame_3"
    def make_Frame_3(self, frame):
        """       Frame:  at Tab_1(1,1)"""
        self.Frame_3 = Frame( frame , width="60", height="50")
        self.Frame_3.grid(row=1, column=1, sticky="nsew")

        # >>>>>>insert any user code below this comment for section "make_Frame_3"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Frame_4"
    def make_Frame_4(self, frame):
        """       Frame:  at Tab_1(1,2)"""
        self.Frame_4 = Frame( frame , width="60", height="50")
        self.Frame_4.grid(row=1, column=2, sticky="nsew")

        # >>>>>>insert any user code below this comment for section "make_Frame_4"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_1"
    def make_Label_1(self, frame):
        """       Label: Click Buttons to Set Values : at Tab_1(2,0)"""
        self.Label_1 = Label( frame , text="Click Buttons to Set Values", width="40")
        self.Label_1.grid(row=2, column=0, sticky="sew", columnspan="3")

        # >>>>>>insert any user code below this comment for section "make_Label_1"
        self.Label_1.grid(row=99, column=0, sticky="ew", columnspan="3")
        self.Label_1.config( text='Click Buttons to Set Values', 
                             width=90, anchor='s' )

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Text_2"
    def make_Text_2(self, frame):
        """        Text:  at Tab_2(1,1)"""
        self.Text_2 = Text( frame , width="40", height="12")
        self.Text_2.grid(row=1, column=1, sticky="nsew")

        # >>>>>>insert any user code below this comment for section "make_Text_2"
        del self.Text_2
        self.Text_2 = scrolledtext.ScrolledText(frame , width="80", height="24", wrap='none')
        self.Text_2.grid(row=1, column=1, sticky="nsew", columnspan="4")


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Canvas_2"
    def make_Canvas_2(self, frame):
        """      Canvas:  at Tab_3(1,1)"""
        self.Canvas_2 = Canvas( frame , width="60", height="50")
        self.Canvas_2.grid(row=1, column=1, sticky="nsew")

        # >>>>>>insert any user code below this comment for section "make_Canvas_2"

        self.Canvas_2.config(bg='#ffffff')
        self.Canvas_2.bind("<ButtonRelease-1>", self.Canvas_2_Click)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_LabelFrame_1"
    def make_LabelFrame_1(self, frame):
        """  LabelFrame: Fluid Properties : at Tab_4(1,1)"""
        self.LabelFrame_1 = LabelFrame( frame , width="300", height="50", text="Fluid Properties")
        self.LabelFrame_1.grid(row=1, column=1, sticky="ew")

        # >>>>>>insert any user code below this comment for section "make_LabelFrame_1"
        self.LabelFrame_1.configure( labelanchor='n', font="Helvetica 10 bold roman" )

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_LabelFrame_2"
    def make_LabelFrame_2(self, frame):
        """  LabelFrame: Injector Pressure Drop : at Tab_4(2,1)"""
        self.LabelFrame_2 = LabelFrame( frame , width="300", height="50", text="Injector Pressure Drop")
        self.LabelFrame_2.grid(row=2, column=1, sticky="ew")

        # >>>>>>insert any user code below this comment for section "make_LabelFrame_2"
        self.LabelFrame_2.configure( labelanchor='n', font="Helvetica 10 bold roman" )


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_LabelFrame_3"
    def make_LabelFrame_3(self, frame):
        """  LabelFrame: Element Design : at Tab_4(3,1)"""
        self.LabelFrame_3 = LabelFrame( frame , width="300", height="50", text="Element Design")
        self.LabelFrame_3.grid(row=3, column=1, sticky="nsew")

        # >>>>>>insert any user code below this comment for section "make_LabelFrame_3"
        self.LabelFrame_3.configure( labelanchor='n', font="Helvetica 10 bold roman" )


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_LabelFrame_4"
    def make_LabelFrame_4(self, frame):
        """  LabelFrame: Element Frequency : at Tab_4(4,1)"""
        self.LabelFrame_4 = LabelFrame( frame , width="300", height="50", text="Element Frequency")
        self.LabelFrame_4.grid(row=4, column=1, sticky="nsew")

        # >>>>>>insert any user code below this comment for section "make_LabelFrame_4"
        self.LabelFrame_4.configure( labelanchor='n', font="Helvetica 10 bold roman" )


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_2"
    def make_Label_2(self, frame):
        """       Label: Oxidizer : at LabelFrame_1(0,1)"""
        self.Label_2 = Label( frame , text="Oxidizer", width="15")
        self.Label_2.grid(row=0, column=1)

        # >>>>>>insert any user code below this comment for section "make_Label_2"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_3"
    def make_Label_3(self, frame):
        """       Label: Fuel : at LabelFrame_1(0,2)"""
        self.Label_3 = Label( frame , text="Fuel", width="15")
        self.Label_3.grid(row=0, column=2)

        # >>>>>>insert any user code below this comment for section "make_Label_3"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_4"
    def make_Label_4(self, frame):
        """       Label: Oxidizer : at LabelFrame_2(0,1)"""
        self.Label_4 = Label( frame , text="Oxidizer", width="15")
        self.Label_4.grid(row=0, column=1)

        # >>>>>>insert any user code below this comment for section "make_Label_4"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_7"
    def make_Label_7(self, frame):
        """       Label: Fuel : at LabelFrame_2(0,2)"""
        self.Label_7 = Label( frame , text="Fuel", width="15")
        self.Label_7.grid(row=0, column=2)

        # >>>>>>insert any user code below this comment for section "make_Label_7"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_11"
    def make_Label_11(self, frame):
        """       Label:  at LabelFrame_3(4,1)"""
        self.Label_11 = Label( frame , text="", width="15", height="2")
        self.Label_11.grid(row=4, column=1)

        # >>>>>>insert any user code below this comment for section "make_Label_11"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_12"
    def make_Label_12(self, frame):
        """       Label:  at LabelFrame_3(1,1)"""
        self.Label_12 = Label( frame , text="", width="15")
        self.Label_12.grid(row=1, column=1)

        # >>>>>>insert any user code below this comment for section "make_Label_12"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_5"
    def make_Label_5(self, frame):
        """       Label: Oxidizer : at LabelFrame_3(5,1)"""
        self.Label_5 = Label( frame , text="Oxidizer", width="15")
        self.Label_5.grid(row=5, column=1)

        # >>>>>>insert any user code below this comment for section "make_Label_5"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_8"
    def make_Label_8(self, frame):
        """       Label: Fuel : at LabelFrame_3(5,2)"""
        self.Label_8 = Label( frame , text="Fuel", width="15")
        self.Label_8.grid(row=5, column=2)

        # >>>>>>insert any user code below this comment for section "make_Label_8"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_RadioGroup_1"
    def make_RadioGroup_1(self, frame):
        """  RadioGroup: Set Number of Elements By: : at LabelFrame_3(0,2)"""
        self.RadioGroup_1 = LabelFrame( frame , width="60", height="50", text="Set Number of Elements By:")
        self.RadioGroup_1.grid(row=0, column=2, sticky="w", rowspan="4")

        # >>>>>>insert any user code below this comment for section "make_RadioGroup_1"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_RadioGroup_2"
    def make_RadioGroup_2(self, frame):
        """  RadioGroup: Set Fuel Element Type : at LabelFrame_3(0,3)"""
        self.RadioGroup_2 = LabelFrame( frame , width="60", height="50", text="Set Fuel Element Type")
        self.RadioGroup_2.grid(row=0, column=3, sticky="nw", rowspan="4")

        # >>>>>>insert any user code below this comment for section "make_RadioGroup_2"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Radiobutton_1"
    def make_Radiobutton_1(self, frame):
        """ Radiobutton: Acoustic Frequency : at RadioGroup_1(1,1)"""
        self.Radiobutton_1 = Radiobutton( frame , value="acoustics", text="Acoustic Frequency", width="30", anchor="w")
        self.Radiobutton_1.grid(row=1, column=1)

        # >>>>>>insert any user code below this comment for section "make_Radiobutton_1"

        self.Radiobutton_1.configure(variable=self.RadioGroup_1_StringVar)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Radiobutton_2"
    def make_Radiobutton_2(self, frame):
        """ Radiobutton: Element Density : at RadioGroup_1(2,1)"""
        self.Radiobutton_2 = Radiobutton( frame , value="elem_density", text="Element Density", width="30", anchor="w")
        self.Radiobutton_2.grid(row=2, column=1)

        # >>>>>>insert any user code below this comment for section "make_Radiobutton_2"

        self.Radiobutton_2.configure(variable=self.RadioGroup_1_StringVar)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Radiobutton_3"
    def make_Radiobutton_3(self, frame):
        """ Radiobutton: Input Number : at RadioGroup_1(3,1)"""
        self.Radiobutton_3 = Radiobutton( frame , value="input", text="Input Number", width="30", anchor="w")
        self.Radiobutton_3.grid(row=3, column=1)

        # >>>>>>insert any user code below this comment for section "make_Radiobutton_3"

        self.Radiobutton_3.configure(variable=self.RadioGroup_1_StringVar)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Radiobutton_4"
    def make_Radiobutton_4(self, frame):
        """ Radiobutton: Like-on-Like : at RadioGroup_2(1,1)"""
        self.Radiobutton_4 = Radiobutton( frame , value="Like-on-Like", text="Like-on-Like", width="15", anchor="w")
        self.Radiobutton_4.grid(row=1, column=1)

        # >>>>>>insert any user code below this comment for section "make_Radiobutton_4"

        self.Radiobutton_4.configure(variable=self.RadioGroup_2_StringVar)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Radiobutton_5"
    def make_Radiobutton_5(self, frame):
        """ Radiobutton: Unlike : at RadioGroup_2(2,1)"""
        self.Radiobutton_5 = Radiobutton( frame , value="Unlike", text="Unlike", width="15", anchor="w")
        self.Radiobutton_5.grid(row=2, column=1)

        # >>>>>>insert any user code below this comment for section "make_Radiobutton_5"

        self.Radiobutton_5.configure(variable=self.RadioGroup_2_StringVar)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_13"
    def make_Label_13(self, frame):
        """       Label: Design Chamber Mode : at LabelFrame_4(1,2)"""
        self.Label_13 = Label( frame , text="Design Chamber Mode", width="30")
        self.Label_13.grid(row=1, column=2)

        # >>>>>>insert any user code below this comment for section "make_Label_13"
        self.Label_13.configure( text="Design Chamber Resonance Mode" )

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Listbox_1"
    def make_Listbox_1(self, frame):
        """     Listbox:  at LabelFrame_4(2,2)"""
        self.Listbox_1 = Listbox( frame , width="18", height="12")
        self.Listbox_1.grid(row=2, column=2, sticky="new")

        # >>>>>>insert any user code below this comment for section "make_Listbox_1"


        # Edit the Listbox Entries
        self.Listbox_1.configure( exportselection=False ) # stay highlighted after focus leaves
        
        modeSvnL = sorted( [(v,k) for k,v in modeSvnD.items()] )
        ipos = 0
        for i,(_,k) in enumerate(modeSvnL):
            self.Listbox_1.insert(END, k)
            if k==default_valueD["desAcousMode"]:
                ipos = i
        self.Listbox_1.select_set( ipos )
        self.Listbox_1.configure( height='%i'%len(modeSvnL) )

        self.Listbox_1.bind("<ButtonRelease-1>", self.Listbox_1_Click)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_RadioGroup_3"
    def make_RadioGroup_3(self, frame):
        """  RadioGroup: Set Limiting Frequency By: : at LabelFrame_4(2,1)"""
        self.RadioGroup_3 = LabelFrame( frame , width="60", height="50", text="Set Limiting Frequency By:")
        self.RadioGroup_3.grid(row=2, column=1, sticky="new")

        # >>>>>>insert any user code below this comment for section "make_RadioGroup_3"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Radiobutton_6"
    def make_Radiobutton_6(self, frame):
        """ Radiobutton: mode : at RadioGroup_3(1,1)"""
        self.Radiobutton_6 = Radiobutton( frame , value="mode", text="mode", width="15", anchor="w")
        self.Radiobutton_6.grid(row=1, column=1)

        # >>>>>>insert any user code below this comment for section "make_Radiobutton_6"

        self.Radiobutton_6.configure(variable=self.RadioGroup_3_StringVar)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Radiobutton_7"
    def make_Radiobutton_7(self, frame):
        """ Radiobutton: freq : at RadioGroup_3(2,1)"""
        self.Radiobutton_7 = Radiobutton( frame , value="freq", text="freq", width="15", anchor="w")
        self.Radiobutton_7.grid(row=2, column=1)

        # >>>>>>insert any user code below this comment for section "make_Radiobutton_7"

        self.Radiobutton_7.configure(variable=self.RadioGroup_3_StringVar)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "Button_1_Click"
    def Button_1_Click(self, event): #bind method for component ID=Button_1
        """      Button: Set Throat Size : at Frame_1(2,1)"""
        pass
        # >>>>>>insert any user code below this comment for section "Button_1_Click"
        # replace, delete, or comment-out the following
        #print( "executed method Button_1_Click" )
        self.statusMessage.set("Setting Throat Size")
        self.get_inp_from_a_dialog('Rthrt')
        

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "Button_2_Click"
    def Button_2_Click(self, event): #bind method for component ID=Button_2
        """      Button: Set Thrust : at Frame_1(2,2)"""
        pass
        # >>>>>>insert any user code below this comment for section "Button_2_Click"
        # replace, delete, or comment-out the following
        #print( "executed method Button_2_Click" )
        self.statusMessage.set("Setting Thrust Level")
        
        Pamb_psia = get_value( user_valueD['Pamb'], user_unitsD['Pamb'], out_units='psia')
        
        s = 'Input Thrust at %g %s'%( user_valueD['Pamb'], user_unitsD['Pamb'] )
        dialog = _get_value_w_units(self.master, s, 
                 dialogOptions={'name':'Thrust', 'units':'lbf', 
                                'value':self.thruster.coreObj.Fambient, 'desc':'Ambient Thrust'})
        if dialog.result is not None:
            # return value is a string
            s = dialog.result["return_value"]
            v =floatCast( s )
            units = dialog.result["return_units"]
            
            self.statusMessage.set('Set Thrust = %g %s'%(v, units))
            
            ThrustLbf = get_value( v, units, out_units='lbf')
        
            self.thruster.scale_Rt_to_Thrust( ThrustLbf=ThrustLbf, Pamb=Pamb_psia )
            
            value = get_value( inp_val=self.thruster.geomObj.Rthrt, inp_units='in', out_units=user_unitsD['Rthrt'])
            user_valueD['Rthrt'] = value
            
            self.set_all_labels_from_thruster()
            self.changes_since_last_save = True 

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "Canvas_1_Click"
    def Canvas_1_Click(self, event): #bind method for component ID=Canvas_1
        """      Canvas:  at Frame_1(3,1)"""
        pass
        # >>>>>>insert any user code below this comment for section "Canvas_1_Click"
        # replace, delete, or comment-out the following
        #print( "executed method Canvas_1_Click" )
        self.statusMessage.set("Refreshing Thruster Image")

        self.put_thruster_on_canvas()

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "Canvas_2_Click"
    def Canvas_2_Click(self, event): #bind method for component ID=Canvas_2
        """      Canvas:  at Tab_3(1,1)"""
        pass
        # >>>>>>insert any user code below this comment for section "Canvas_2_Click"
        # replace, delete, or comment-out the following
        #print( "executed method Canvas_2_Click" )
        #self.statusMessage.set("executed method Canvas_2_Click")
        self.put_isp_plot_on_canvas_2()

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "Listbox_1_Click"
    def Listbox_1_Click(self, event): #bind method for component ID=Listbox_1
        """     Listbox:  at LabelFrame_4(2,2)"""
        pass
        # >>>>>>insert any user code below this comment for section "Listbox_1_Click"
        # replace, delete, or comment-out the following
        #print( "executed method Listbox_1_Click" )
        self.statusMessage.set("Chamber Mode set to: ")

        #print( "current selection(s) =",self.Listbox_1.curselection() )
        labelL = []
        for i in self.Listbox_1.curselection():
            labelL.append( self.Listbox_1.get(i))
        #print( "current label(s) =",labelL )
        user_valueD['desAcousMode'] = labelL[0]
        
        if self.RadioGroup_3_StringVar.get() != 'mode':
            self.RadioGroup_3_StringVar.set( 'mode' ) # let radio group call build_new_thruster_from_user_values
        else:
        
            if self.stringvar_callback_is_active and hasattr(self, 'injObj'):
                self.build_new_thruster_from_user_values()
        self.changes_since_last_save = True 
        
    def set_listbox_1_by_value(self, value):
        """Given mode value, set Listbox_1"""
        
        if value not in modeSvnD:
            return
        
        self.Listbox_1.selection_clear(0, END) 
        for i, listbox_entry in enumerate(self.Listbox_1.get(0, END)):
            if listbox_entry == value:
                self.Listbox_1.select_set(i)
        self.changes_since_last_save = True 
        
    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "RadioGroup_1_StringVar_traceName"
    def RadioGroup_1_StringVar_Callback(self, varName, index, mode):
        """  RadioGroup: Set Number of Elements By: : at LabelFrame_3(0,2)"""
        pass

        # >>>>>>insert any user code below this comment for section "RadioGroup_1_StringVar_traceName"
        # replace, delete, or comment-out the following
        if self.stringvar_callback_is_active:
            #print( "RadioGroup_1_StringVar_Callback varName, index, mode",varName, index, mode )
            self.statusMessage.set("    Set Number of Elements By: = "+self.RadioGroup_1_StringVar.get())
            #print( "    new StringVar value =",self.RadioGroup_1_StringVar.get() )


        user_valueD['setNelementsBy'] = self.RadioGroup_1_StringVar.get()
        
        if self.stringvar_callback_is_active and hasattr(self, 'injObj'):
            self.build_new_thruster_from_user_values()
        self.changes_since_last_save = True 

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "RadioGroup_2_StringVar_traceName"
    def RadioGroup_2_StringVar_Callback(self, varName, index, mode):
        """  RadioGroup: Set Fuel Element Type : at LabelFrame_3(0,3)"""
        pass

        # >>>>>>insert any user code below this comment for section "RadioGroup_2_StringVar_traceName"
        # replace, delete, or comment-out the following
        if self.stringvar_callback_is_active:        
            #print( "RadioGroup_2_StringVar_Callback varName, index, mode",varName, index, mode )
            self.statusMessage.set("Fuel Element Type = "+self.RadioGroup_2_StringVar.get())
            #print( "    Fuel Element Type =",self.RadioGroup_2_StringVar.get() )


        user_valueD['lolFuelElem'] = self.RadioGroup_2_StringVar.get() == 'Like-on-Like'
        
        if user_valueD['lolFuelElem']:
            user_valueD['FuelOrfPerEl'] = max(2.0, user_valueD['FuelOrfPerEl'])
        
        if self.stringvar_callback_is_active and hasattr(self, 'injObj'):
            self.build_new_thruster_from_user_values()
        self.changes_since_last_save = True 


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "RadioGroup_3_StringVar_traceName"
    def RadioGroup_3_StringVar_Callback(self, varName, index, mode):
        """  RadioGroup: Set Limiting Frequency By: : at LabelFrame_4(2,1)"""
        pass

        # >>>>>>insert any user code below this comment for section "RadioGroup_3_StringVar_traceName"
        # replace, delete, or comment-out the following
        if self.stringvar_callback_is_active:        
            #print( "RadioGroup_3_StringVar_Callback varName, index, mode",varName, index, mode )
            self.statusMessage.set("    RadioGroup_3_StringVar = "+self.RadioGroup_3_StringVar.get())
            #print( "    new StringVar value =",self.RadioGroup_3_StringVar.get() )

        user_valueD['setAcousticFreqBy'] = self.RadioGroup_3_StringVar.get()
        
        if self.stringvar_callback_is_active and hasattr(self, 'injObj'):
            self.build_new_thruster_from_user_values()
        self.changes_since_last_save = True 

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "menu_File_New"
    def menu_File_New(self):
        pass
        # >>>>>>insert any user code below this comment for section "menu_File_New"
        # replace, delete, or comment-out the following
        self.statusMessage.set("called menu_File_New")
        #print( "called menu_File_New" )

        ans = messagebox.askquestion('New Thruster', 'Do You Want to Abandon Current Thruster without Saving?')
        if ans == 'yes':
        
            # build thruster from default values
            reset_vars_to_default()
            self.thruster = None
            self.build_new_thruster_from_user_values()

            #self.set_all_labels_from_thruster()
            self.put_thruster_on_canvas()
            self.changes_since_last_save = False
        
    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "menu_File_Open"
    def menu_File_Open(self):
        pass
        # >>>>>>insert any user code below this comment for section "menu_File_Open"
        # replace, delete, or comment-out the following
        self.statusMessage.set("called menu_File_Open")
        #print( "called menu_File_Open" )

        filetypes = [
            ('RocketIsp','*.risp'),
            ('Any File','*.*')]
        
        
        filename = tkinter.filedialog.askopenfilename(parent=self.master,
                       title='Select RocketIsp Input File',
                       filetypes=filetypes,
                       initialdir=self.recent_rocketisp.last_dir)

        if filename:
            full_fname = os.path.abspath(filename)
            head,tail = os.path.split( full_fname )
            self.current_filePath = head
            self.current_fileName = tail
            self.recent_rocketisp.update( full_fname )
            
            self.load_file( full_fname )
            self.changes_since_last_save = False



    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "menu_File_Recent"
    def menu_File_Recent(self):
        pass
        # >>>>>>insert any user code below this comment for section "menu_File_Recent"
        # replace, delete, or comment-out the following
        self.statusMessage.set("called menu_File_Recent")
        #print( "called menu_File_Recent" )
        
        fileL = self.recent_rocketisp.recent_fileL
        
        numRecentFiles = min(len(fileL), RecentFiles.MaxRecentFiles)
        #print( numRecentFiles, fileL )
        
        dialog = _select_recent_file(self.master, "Pick Recent File", dialogOptions={'fileL':fileL})
        if dialog.result is not None:
            full_fname = dialog.result["file_name"]
            self.load_file( full_fname )
            self.changes_since_last_save = False
            
        


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "menu_File_Save"
    def menu_File_Save(self):
        pass
        # >>>>>>insert any user code below this comment for section "menu_File_Save"
        # replace, delete, or comment-out the following
        self.statusMessage.set("called menu_File_Save")
        #print( "called menu_File_Save" )
        self.save_dialog( is_saveas=False )
    
    def save_dialog(self, is_saveas=False):
    
        if self.current_filePath:
            initialdir = self.current_filePath
        else:
            initialdir = self.recent_rocketisp.last_dir
            
        if is_saveas:
            initialfile = '*.risp'
        else:
            if self.current_fileName:
                initialfile = self.current_fileName
            else:
                initialfile = '*.risp'
        
        filetypes = [
            ('RocketIsp','*.risp'),
            ('Any File','*.*')]
                                    
        fsave = tkinter.filedialog.asksaveasfilename(parent=self.master, 
                        title='Saving RocketIsp file', filetypes=filetypes,
                        initialdir=initialdir,
                        initialfile=initialfile)
    
        # if file name given, save it.
        if fsave:
            # make sure file extension is correct
            if not fsave.lower().endswith('.risp'):
                fsave += '.risp'
        
            self.statusMessage.set( 'Saving to:' + fsave )
            self.save_file( fsave )
            self.changes_since_last_save = False


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "menu_File_SaveAs"
    def menu_File_SaveAs(self):
        pass
        # >>>>>>insert any user code below this comment for section "menu_File_SaveAs"
        # replace, delete, or comment-out the following
        self.statusMessage.set("called menu_File_SaveAs")
        #print( "called menu_File_SaveAs" )
        
        self.save_dialog( is_saveas=True )

                
    def save_html_dialog(self):
    
        if self.current_filePath:
            initialdir = self.current_filePath
        else:
            initialdir = self.recent_rocketisp.last_dir
            
        if self.current_fileName:
            
            if self.current_fileName.lower().endswith('.risp'):
                initialfile = self.current_fileName[:-5] + '.html'
            else:
                initialfile = self.current_fileName + '.html'
        else:
            initialfile = '*.html'
        
        filetypes = [
            ('HTML','*.html'),
            ('Any File','*.*')]
                                    
        fsave = tkinter.filedialog.asksaveasfilename(parent=self.master, 
                        title='Saving RocketIsp HTML file', filetypes=filetypes,
                        initialdir=initialdir,
                        initialfile=initialfile)
    
        # if file name given, save it.
        if fsave:
            # make sure file extension is correct
            if not fsave.lower().endswith('.html'):
                fsave += '.html'
        
            self.statusMessage.set( 'Saving to:' + fsave )
            
            fOut = open( fsave, 'w')
            fOut.write( self.thruster.get_html_file_str() )
            fOut.close()
            
            webbrowser.open( os.path.abspath(fsave) )
        
        
    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "menu_File_"
    def menu_File_(self):
        pass
        # >>>>>>insert any user code below this comment for section "menu_File_"
        # replace, delete, or comment-out the following
        #self.statusMessage.set("called menu_File_")
        #print( "called menu_File_" )


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "menu_File_SaveHTML"
    def menu_File_SaveHTML(self):
        pass
        # >>>>>>insert any user code below this comment for section "menu_File_SaveHTML"
        # replace, delete, or comment-out the following
        self.statusMessage.set("called menu_File_SaveHTML")
        #print( "called menu_File_SaveHTML" )

        self.save_html_dialog()


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "menu_File_"
    def menu_File_(self):
        pass
        # >>>>>>insert any user code below this comment for section "menu_File_"
        # replace, delete, or comment-out the following
        #self.statusMessage.set("called menu_File_")
        #print( "called menu_File_" )


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "menu_File_Exit"
    def menu_File_Exit(self):
        pass
        # >>>>>>insert any user code below this comment for section "menu_File_Exit"
        # replace, delete, or comment-out the following
        self.statusMessage.set("called menu_File_Exit")
        #print( "called menu_File_Exit" )
        
        self.cleanupOnQuit()


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "menu_Common_Tasks_Set_Throat_Size"
    def menu_Common_Tasks_Set_Throat_Size(self):
        pass
        # >>>>>>insert any user code below this comment for section "menu_Common_Tasks_Set_Throat_Size"
        # replace, delete, or comment-out the following
        #self.statusMessage.set("called menu_Common_Tasks_Set_Throat_Size")
        #print( "called menu_Common_Tasks_Set_Throat_Size" )
        self.statusMessage.set("Setting Throat Size")
        self.get_inp_from_a_dialog('Rthrt')
        self.changes_since_last_save = True 


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "menu_Common_Tasks_Set_Thrust"
    def menu_Common_Tasks_Set_Thrust(self):
        pass
        # >>>>>>insert any user code below this comment for section "menu_Common_Tasks_Set_Thrust"
        # replace, delete, or comment-out the following
        #self.statusMessage.set("called menu_Common_Tasks_Set_Thrust")
        #print( "called menu_Common_Tasks_Set_Thrust" )
        self.statusMessage.set("Setting Thrust Level")
        
        Pamb_psia = get_value( user_valueD['Pamb'], user_unitsD['Pamb'], out_units='psia')
        
        s = 'Input Thrust at %g %s'%( user_valueD['Pamb'], user_unitsD['Pamb'] )
        dialog = _get_value_w_units(self.master, s, 
                 dialogOptions={'name':'Thrust', 'units':'lbf', 
                                'value':self.thruster.coreObj.Fambient, 'desc':'Ambient Thrust'})
        if dialog.result is not None:
            # return value is a string
            s = dialog.result["return_value"]
            v =floatCast( s )
            units = dialog.result["return_units"]
            
            self.statusMessage.set('Set Thrust = %g %s'%(v, units))
            
            ThrustLbf = get_value( v, units, out_units='lbf')
        
            self.thruster.scale_Rt_to_Thrust( ThrustLbf=ThrustLbf, Pamb=Pamb_psia )
            
            value = get_value( inp_val=self.thruster.geomObj.Rthrt, inp_units='in', out_units=user_unitsD['Rthrt'])
            user_valueD['Rthrt'] = value
            
            self.set_all_labels_from_thruster()
            self.changes_since_last_save = True 


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "menu_Common_Tasks_Set_MR_to_Max_Isp"
    def menu_Common_Tasks_Set_MR_to_Max_Isp(self):
        pass
        # >>>>>>insert any user code below this comment for section "menu_Common_Tasks_Set_MR_to_Max_Isp"
        # replace, delete, or comment-out the following
        self.statusMessage.set("called menu_Common_Tasks_Set_MR_to_Max_Isp")
        #print( "called menu_Common_Tasks_Set_MR_to_Max_Isp" )
        
        self.thruster.set_mr_to_max_ispdel()
        user_valueD['MRcore'] = self.coreObj.MRcore
        
        self.set_all_labels_from_thruster()
        self.changes_since_last_save = True 


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "menu_Common_Tasks_Set_MRthruster_given_FFC"
    def menu_Common_Tasks_Set_MRthruster_given_FFC(self):
        pass
        # >>>>>>insert any user code below this comment for section "menu_Common_Tasks_Set_MRthruster_given_FFC"
        # replace, delete, or comment-out the following
        self.statusMessage.set("called menu_Common_Tasks_Set_MRthruster_given_FFC")
        #print( "called menu_Common_Tasks_Set_MRthruster_given_FFC" )

        dialog = _get_value_v2(self.master, "Input MRthruster for pcentFFC=%s"%user_valueD['pcentFFC'], 
                 dialogOptions={'name':'MRthruster', 'value':self.coreObj.MRthruster, 
                                'val_type': type(1.234), 
                                'desc':'Thruster Mixture Ratio = MRcore * (1-%FFC/100)'})
        
        
        if dialog.result is not None:
            # return value is a string, but validated as float
            s = dialog.result["return_value"]
            v = parse_value( s )
            MRthruster = v
            
            try:
                self.statusMessage.set('Set MRthruster = %g'%v)
            except:
                self.statusMessage.set('Set MRthruster = %s'%v)

            if self.coreObj.barrierObj is None:
                # No barrierObj, so MRthruster is just MRcore
                self.thruster.coreObj.reset_attr('MRcore', v, re_evaluate=True)
                self.thruster.calc_all_eff()
                user_valueD['MRcore'] = self.coreObj.MRcore
            else:
                self.thruster.set_MRthruster( MRthruster )
                user_valueD['MRcore'] = self.coreObj.MRcore
                
            self.set_all_labels_from_thruster()
            self.changes_since_last_save = True 


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "menu_Common_Tasks_Set_Nozzle_Pexit"
    def menu_Common_Tasks_Set_Nozzle_Pexit(self):
        pass
        # >>>>>>insert any user code below this comment for section "menu_Common_Tasks_Set_Nozzle_Pexit"
        # replace, delete, or comment-out the following
        self.statusMessage.set("called menu_Common_Tasks_Set_Nozzle_Pexit")
        #print( "called menu_Common_Tasks_Set_Nozzle_Pexit" )

        if user_valueD['Pamb'] > 0.0:
            value = user_valueD['Pamb']
            inp_units = user_unitsD['Pamb']
        else:
            value = 14.7
            inp_units = 'psia'

        desc = 'Change Area Ratio to give Desired Exit Pressure.'
        dialog = _get_value_w_units(self.master, "Input Desired Exit Pressure.", 
                                    dialogOptions={'name':'Exit Pressure', 'value':value, 'desc':desc,
                                                   'units':inp_units})
        if dialog.result is not None:
            # return value is a string
            s = dialog.result["return_value"]
            v =floatCast( s )
            units = dialog.result["return_units"]
            
            self.statusMessage.set('Set Nozzle Exit Pressure = %g %s'%(v, units))
            
            Pamb_psia = get_value( v, units, out_units='psia')
            #print( 'Pamb_psia',Pamb_psia )
            
            eps_target = self.thruster.set_eps_to_equal_pexit( Pexit_psia=Pamb_psia )
            
            user_valueD['eps'] = eps_target
            
            self.set_all_labels_from_thruster()
            self.changes_since_last_save = True 

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "menu_Common_Tasks_Plot_Efficiencies"
    def menu_Common_Tasks_Plot_Efficiencies(self):
        pass
        # >>>>>>insert any user code below this comment for section "menu_Common_Tasks_Plot_Efficiencies"
        # replace, delete, or comment-out the following
        self.statusMessage.set("called menu_Common_Tasks_Plot_Efficiencies")
        #print( "called menu_Common_Tasks_Plot_Efficiencies" )
        
        figuresL=[manager.canvas.figure
                 for manager in matplotlib._pylab_helpers.Gcf.get_all_fig_managers()]
        #print(figuresL)
        for fig in figuresL:
            plt.close( fig )
        
        self.thruster.plot_eff_curves( title='', png_name='', pixel_wh=None,
                                                 do_show=True, show_grid=True, Npts=30, 
                                                 edge_frac=0.97 )
        
        #self.plot_efficiencies = True

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "menu_Common_Tasks_Plot_Isp_Delivered"
    def menu_Common_Tasks_Plot_Isp_Delivered(self):
        pass
        # >>>>>>insert any user code below this comment for section "menu_Common_Tasks_Plot_Isp_Delivered"
        # replace, delete, or comment-out the following
        self.statusMessage.set("called menu_Common_Tasks_Plot_Isp_Delivered")
        #print( "called menu_Common_Tasks_Plot_Isp_Delivered" )
        
        figuresL=[manager.canvas.figure
                 for manager in matplotlib._pylab_helpers.Gcf.get_all_fig_managers()]
        #print(figuresL)
        for fig in figuresL:
            plt.close( fig )
            
        self.thruster.plot_isp_curves( title='', png_name='', pixel_wh=None,
                                       do_show=True, show_grid=True, Npts=30, 
                                       edge_frac=0.97 )

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "menu_Help"
    def menu_Help(self):
        pass
        # >>>>>>insert any user code below this comment for section "menu_Help"
        # replace, delete, or comment-out the following
        self.statusMessage.set("called menu_Help")
        #print( "called menu_Help" )
        
        webbrowser.open(r'https://rocketisp.readthedocs.io/en/latest/')


# TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "end"

def main():
    root = Tk()
    app = _tk_thruster(root)
    root.mainloop()

if __name__ == '__main__':
    main()
