# Guide to benchmark codes

The source codes included in this directory can be used to reproduce all benchmark files used for the CCL unit tests. Several of these tests are based on the same software (e.g. the CosmoMAD library), but the output of that software was compared against other codes (i.e. CCL has not just been compared to CosmoMAD or any one particular package, but to several of them).

* **distances_bm.py** : this script generates the comoving distances used in tests distances_cosmomad_lowz:model_1-5. To run it (and several of the other scripts below) you need to download and install the cosmomad library and python wrapper (https://github.com/damonge/CosmoMAD). The version of CosmoMAD used to produce the benchmarks is the release under tag `ccl_validation`. CosmoMAD is publicly available under the GSL3.0 license.
* **distances_hiz_bm.py** : generates the high-redshift distances used in tests distances_cosmomad_hiz:model_1-3
* **growth_lowz_bm.py** and **growth_hiz_bm.py** : same as distances_bm and distances_hiz_bm for the growth functions used in tests growth_lowz:model_1-5 and growth_hiz:model_1-3
* **create_CLASS_distance_benchmarks.ipynb** : this notebook generates the distance benchmarks using `CLASS` for the tests distances_class:model1-11, where models 7-11 include massive neutrinos. The benchmarks are created for the low redshifts (`lowz`), high redshifts (`hiz`), and the whole redshift range (`allz`, using 10 logarithmically spaced redshifts between 0.01 and 1000)
* **multiple_neutrino_distances.ipynb** : this notebook uses `astropy` to generate the distance benchmarks for the tests distances_astropy_mnu_lowz:model1-5 and distances_astropy_mnu_hiz:model1-5
* **growth_allz.py** : generates the growth factors for the `allz` redshift range. Used in the tests growth_allz:model1-5
* **bbks_bm.py** and **ehpk_bm.py** : generates the benchmark BBKS and Eisenstein&Hu power spectra used in bbks:model_1-3 and eh:model_1.
* **sigmaM_bm.py** : generates the benchmark sigma(M) values used in sigmam:model_1-3.
* **mfunc_bm.py** : generates the mass function predictions used in massfunc:model_1.
* **cl_corr_bm** : this folder contains the software needed to reproduce many of the benchmark files for angular power spectra and correlation functions used in tests cls:histo, cls:analytic, corrs:analytic_bessel and corrs:analytic_fftlog. The C code within that folder (limberjack) should first be compiled before running the script run_all.py. For concreteness, this code generates the benchmarks currently used for galaxy clustering and shear-shear correlations.
* **cl_cmbl_bm.py** : generates the benchmark file for the CMB lensing angular power spectrum used in test cls:histo and cls:analytic.
* **cl_cmblx_bm.py** : generates the benchmark CMB lensing cross correlation power spectra with galaxy clustering and cosmic shear used in cls:histo and cls:analytic. 
* **bcm_bm.c** : this file shows an excerpt from a modified version of CLASS that was used to generate a benchmark power spectrum containing baryon corrections (used for test bcm:model_1). The file is just an excerpt, and therefore won't compile or run on its own.
* **3dcorr_benchmark.ipynb** : this python notebook can be used to generate the files used in tests corrs_3d:model_1-3.
* **halomod_bm.py** : this python script can be used to generate the files used in tests halomod:model_1-3.
* **model1_pk_nu.ini**, **model2_pk_nu.ini**, and **model3_pk_nu.ini** and CLASS ini files; running CLASS with these ini files will generate the power spectra used in tests power_nu:model_1-3 and power_nu_nl:model1_3 (you may have to rename the resulting output files to exactly match the naming convention of the tests.
* **angpow_benchmarks.c** : this C program uses an older version of CCL (version tagged 0.9) to generate the benchmark power spectrum used to validate angpow. It uses a now-deprecated "native" method to perform the non-limber calculation.
* **cosmolss_cclbenchmarking.tar.gz** : this tarball contains CosmoLSS used for benchmarking the galaxy clustering, galaxy-galaxy lensing, and cosmic shear angular power spectra and correlation functions including intrinsic alignments for all tomograhic bin combinations and both analytic/histogram redshift distributions. It can be downloaded from here: https://github.com/sjoudaki/CosmoLSS_CCLbenchmarking. This includes all 3x2pt terms: galaxy-galaxy (gg), galaxy-shear (gG), galaxy-intrinsic (gI), shear-shear (GG), shear-intrinsic (GI), intrinsic-intrinsic (II), galaxy-total (gG+gI), and total-total (GG+GI+II). Please make sure that you have installed Intel Fortran 14 or higher. To compile the code, enter the directory "cosmolss_cclbenchmarking/source", type "make clean", then "make". Then go back to the main directory (i.e. "cd .."), type "./cosmomc testcclbenchmarking.ini". This will generate all of the benchmark files for the analytic redshift distributions. For the histogram case, enter "cosmolss_cclbenchmarking/source" again, and type "cp CosmoLSS_cclbenchmarking_histo.f90 CosmoLSS.f90". Now, type "make", then go back to the main directory ("cd .."), and type "./cosmomc testcclbenchmarking.ini". This now generates all of the benchmark files for the histogram redshift distributions. For completeness, the downloaded tarball contains all of the benchmark files used in the unit tests and python notebook.
* **cosmolss_cclbenchmarking.tar.gz** : this tarball contains CosmoLSS used for benchmarking the galaxy clustering, galaxy-galaxy lensing, and cosmic shear angular power spectra and correlation functions including intrinsic alignments for all tomograhic bin combinations and both analytic/histogram redshift distributions. It can also be downloaded from here: https://github.com/sjoudaki/CosmoLSS_CCLbenchmarking. This includes all 3x2pt terms: galaxy-galaxy (gg), galaxy-shear (gG), galaxy-intrinsic (gI), shear-shear (GG), shear-intrinsic (GI), intrinsic-intrinsic (II), galaxy-total (gG+gI), and total-total (GG+GI+II). Please make sure that you have installed Intel Fortran 14 or higher. To compile the code, enter the directory "cosmolss_cclbenchmarking/source", type "make clean", then "make". Then go back to the main directory (i.e. "cd .."), type "./cosmomc testcclbenchmarking.ini". This will generate all of the benchmark files for the analytic redshift distributions. For the histogram case, enter "cosmolss_cclbenchmarking/source" again, and type "cp CosmoLSS_cclbenchmarking_histo.f90 CosmoLSS.f90". Now, type "make", then go back to the main directory ("cd .."), and type "./cosmomc testcclbenchmarking.ini". This now generates all of the benchmark files for the histogram redshift distributions. For completeness, the downloaded tarball contains all of the benchmark files used in the unit tests and python notebook.
