#Filename: cosmo_params.py
#Description: This module defines cosmological parameters 
import math


#Cosmology (Model used for Cl benchmarks)
c=299792.458 #km/s
w0=-1.0
wa=0.
H0 = 70.
h=H0/100.
sigma8=0.8
OmegaM= 0.3
OmegaL=1.0-OmegaM
npower= 0.96
Omegab = 0.0
Gconst = 6.6726*1.9891*1e-9/3.08567802 #Mpc/Msun(km/s)^2
rhocrit0 = 3.*H0**2./8./math.pi/Gconst #Msun/Mpc^3
bias=1.

#Other models frequently used
#Model1 (flat LCMD): Omega_m = 0.3, Omega_b = 0.05, Omega_v = 0.7, h0 = 0.7, sigma_8 = 0.8, n_s = 0.96, w_0 = -1.0, w_a = 0.0
#Model2 (w0 LCMD): Omega_m = 0.3, Omega_b = 0.05, Omega_v = 0.7, h0 = 0.7, sigma_8 = 0.8, n_s = 0.96, w_0 = -0.9, w_a = 0.0
#Model3 (wa LCMD): Omega_m = 0.3, Omega_b = 0.05, Omega_v = 0.7, h0 = 0.7, sigma_8 = 0.8, n_s = 0.96, w_0 = -0.9, w_a = 0.1

