"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NextComponent = exports.NextJsTypeScriptProject = exports.NextJsProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const javascript_1 = require("../javascript");
const sample_file_1 = require("../sample-file");
const typescript_1 = require("../typescript");
const util_1 = require("../util");
const postcss_1 = require("./postcss");
/**
 * (experimental) Next.js project without TypeScript.
 *
 * @experimental
 * @pjid nextjs
 */
class NextJsProject extends javascript_1.NodeProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _d, _e, _f, _g;
        super({
            jest: false,
            minNodeVersion: '12.13.0',
            ...options,
        });
        this.srcdir = (_d = options.srcdir) !== null && _d !== void 0 ? _d : 'pages';
        this.assetsdir = (_e = options.assetsdir) !== null && _e !== void 0 ? _e : 'public';
        this.tailwind = (_f = options.tailwind) !== null && _f !== void 0 ? _f : true;
        new NextComponent(this, { typescript: false, tailwind: this.tailwind });
        // generate sample code in `pages` and `public` if these directories are empty or non-existent.
        if ((_g = options.sampleCode) !== null && _g !== void 0 ? _g : true) {
            new NextSampleCode(this, {
                fileExt: 'js',
                srcdir: this.srcdir,
                assetsdir: this.assetsdir,
                tailwind: this.tailwind,
            });
        }
    }
}
exports.NextJsProject = NextJsProject;
_a = JSII_RTTI_SYMBOL_1;
NextJsProject[_a] = { fqn: "projen.web.NextJsProject", version: "0.40.1" };
/**
 * (experimental) Next.js project with TypeScript.
 *
 * @experimental
 * @pjid nextjs-ts
 */
class NextJsTypeScriptProject extends typescript_1.TypeScriptAppProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _d, _e, _f, _g;
        const defaultOptions = {
            srcdir: 'pages',
            eslint: false,
            minNodeVersion: '12.13.0',
            jest: false,
            tsconfig: {
                include: ['**/*.ts', '**/*.tsx'],
                compilerOptions: {
                    // required by Next.js
                    esModuleInterop: true,
                    module: 'esnext',
                    moduleResolution: javascript_1.TypeScriptModuleResolution.NODE,
                    isolatedModules: true,
                    resolveJsonModule: true,
                    jsx: javascript_1.TypeScriptJsxMode.PRESERVE,
                    // recommended by Next.js
                    allowJs: true,
                    skipLibCheck: true,
                    forceConsistentCasingInFileNames: true,
                    noEmit: true,
                    lib: ['dom', 'dom.iterable', 'esnext'],
                    strict: false,
                    target: 'es5',
                },
            },
        };
        // never generate default TypeScript sample code, since this class provides its own
        super(util_1.deepMerge([defaultOptions, options, { sampleCode: false }]));
        this.srcdir = (_d = options.srcdir) !== null && _d !== void 0 ? _d : 'pages';
        this.assetsdir = (_e = options.assetsdir) !== null && _e !== void 0 ? _e : 'public';
        this.tailwind = (_f = options.tailwind) !== null && _f !== void 0 ? _f : true;
        new NextComponent(this, { typescript: true, tailwind: this.tailwind });
        // 'next build' command fails if tsconfig.json is immutable
        if (this.tsconfig) {
            this.tsconfig.file.readonly = false;
        }
        // generate sample code in `pages` and `public` if these directories are empty or non-existent.
        if ((_g = options.sampleCode) !== null && _g !== void 0 ? _g : true) {
            new NextSampleCode(this, {
                fileExt: 'tsx',
                srcdir: this.srcdir,
                assetsdir: this.assetsdir,
                tailwind: this.tailwind,
            });
        }
    }
}
exports.NextJsTypeScriptProject = NextJsTypeScriptProject;
_b = JSII_RTTI_SYMBOL_1;
NextJsTypeScriptProject[_b] = { fqn: "projen.web.NextJsTypeScriptProject", version: "0.40.1" };
/**
 * @experimental
 */
class NextComponent extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _d, _e, _f;
        super(project);
        this.typescript = (_d = options.typescript) !== null && _d !== void 0 ? _d : false;
        this.tailwind = (_e = options.tailwind) !== null && _e !== void 0 ? _e : true;
        project.addDeps('next', 'react', 'react-dom');
        if (this.typescript) {
            project.addDevDeps('@types/react', '@types/react-dom');
        }
        if (this.tailwind) {
            new postcss_1.PostCss(project, { tailwind: true });
        }
        // NextJS CLI commands, see: https://nextjs.org/docs/api-reference/cli
        project.addTask('dev', {
            description: 'Starts the Next.js application in development mode',
            exec: 'next dev',
        });
        project.compileTask.exec('next build');
        project.addTask('export', {
            description: 'Exports the application for production deployment',
            exec: 'next export',
        });
        project.addTask('server', {
            description: 'Starts the Next.js application in production mode',
            exec: 'next start',
        });
        project.addTask('telemetry', {
            description: 'Checks the status of Next.js telemetry collection',
            exec: 'next telemetry',
        });
        (_f = project.npmignore) === null || _f === void 0 ? void 0 : _f.exclude('# Next.js', '/.next/');
        project.gitignore.exclude('# Next.js', '/.next/');
    }
}
exports.NextComponent = NextComponent;
_c = JSII_RTTI_SYMBOL_1;
NextComponent[_c] = { fqn: "projen.web.NextComponent", version: "0.40.1" };
class NextSampleCode extends component_1.Component {
    constructor(project, options) {
        var _d;
        super(project);
        this.fileExt = (_d = options.fileExt) !== null && _d !== void 0 ? _d : 'js';
        this.srcdir = options.srcdir;
        this.assetsdir = options.assetsdir;
        this.tailwind = options.tailwind;
        const indexJs = [
            'import Head from "next/head"',
            '',
            'export default function Home() {',
            '  return (',
            '    <div className="container">',
            '      <Head>',
            '        <title>Create Next App</title>',
            '      </Head>',
            '',
            '      <main>',
            '        <h1 className="title">',
            '          Welcome to <a href="https://nextjs.org">Next.js!</a>',
            '        </h1>',
            '',
            '        <p className="description">',
            '          Get started by editing <code>pages/index.js</code>',
            '        </p>',
            '',
            '        <div className="grid">',
            '          <a href="https://nextjs.org/docs" className="card">',
            '            <h3>Documentation &rarr;</h3>',
            '            <p>Find in-depth information about Next.js features and API.</p>',
            '          </a>',
            '',
            '          <a href="https://nextjs.org/learn" className="card">',
            '            <h3>Learn &rarr;</h3>',
            '            <p>Learn about Next.js in an interactive course with quizzes!</p>',
            '          </a>',
            '',
            '          <a',
            '            href="https://github.com/vercel/next.js/tree/master/examples"',
            '            className="card"',
            '          >',
            '            <h3>Examples &rarr;</h3>',
            '            <p>Discover and deploy boilerplate example Next.js projects.</p>',
            '          </a>',
            '',
            '          <a',
            '            href="https://vercel.com/import?filter=next.js&utm_source=create-next-app&utm_medium=default-template&utm_campaign=create-next-app"',
            '            className="card"',
            '          >',
            '            <h3>Deploy &rarr;</h3>',
            '            <p>',
            '              Instantly deploy your Next.js site to a public URL with Vercel.',
            '            </p>',
            '          </a>',
            '        </div>',
            '      </main>',
            '',
            '      <footer>',
            '        <a',
            '          href="https://vercel.com?utm_source=create-next-app&utm_medium=default-template&utm_campaign=create-next-app"',
            '          target="_blank"',
            '          rel="noopener noreferrer"',
            '        >',
            '          Powered by Vercel',
            '          <img src="/vercel.svg" alt="Vercel Logo" className="logo" />',
            '        </a>',
            '      </footer>',
            '',
            '      <style jsx>{`',
            '        .container {',
            '          min-height: 100vh;',
            '          padding: 0 0.5rem;',
            '          display: flex;',
            '          flex-direction: column;',
            '          justify-content: center;',
            '          align-items: center;',
            '        }',
            '',
            '        main {',
            '          padding: 5rem 0;',
            '          flex: 1;',
            '          display: flex;',
            '          flex-direction: column;',
            '          justify-content: center;',
            '          align-items: center;',
            '        }',
            '',
            '        footer {',
            '          width: 100%;',
            '          height: 100px;',
            '          border-top: 1px solid #eaeaea;',
            '          display: flex;',
            '          justify-content: center;',
            '          align-items: center;',
            '        }',
            '',
            '        footer img {',
            '          margin-left: 0.5rem;',
            '        }',
            '',
            '        footer a {',
            '          display: flex;',
            '          justify-content: center;',
            '          align-items: center;',
            '        }',
            '',
            '        a {',
            '          color: inherit;',
            '          text-decoration: none;',
            '        }',
            '',
            '        .title a {',
            '          color: #0070f3;',
            '          text-decoration: none;',
            '        }',
            '',
            '        .title a:hover,',
            '        .title a:focus,',
            '        .title a:active {',
            '          text-decoration: underline;',
            '        }',
            '',
            '        .title {',
            '          margin: 0;',
            '          line-height: 1.15;',
            '          font-size: 4rem;',
            '        }',
            '',
            '        .title,',
            '        .description {',
            '          text-align: center;',
            '        }',
            '',
            '        .description {',
            '          line-height: 1.5;',
            '          font-size: 1.5rem;',
            '        }',
            '',
            '        code {',
            '          background: #fafafa;',
            '          border-radius: 5px;',
            '          padding: 0.75rem;',
            '          font-size: 1.1rem;',
            '          font-family: Menlo, Monaco, Lucida Console, Liberation Mono,',
            '            DejaVu Sans Mono, Bitstream Vera Sans Mono, Courier New, monospace;',
            '        }',
            '',
            '        .grid {',
            '          display: flex;',
            '          align-items: center;',
            '          justify-content: center;',
            '          flex-wrap: wrap;',
            '',
            '          max-width: 800px;',
            '          margin-top: 3rem;',
            '        }',
            '',
            '        .card {',
            '          margin: 1rem;',
            '          flex-basis: 45%;',
            '          padding: 1.5rem;',
            '          text-align: left;',
            '          color: inherit;',
            '          text-decoration: none;',
            '          border: 1px solid #eaeaea;',
            '          border-radius: 10px;',
            '          transition: color 0.15s ease, border-color 0.15s ease;',
            '        }',
            '',
            '        .card:hover,',
            '        .card:focus,',
            '        .card:active {',
            '          color: #0070f3;',
            '          border-color: #0070f3;',
            '        }',
            '',
            '        .card h3 {',
            '          margin: 0 0 1rem 0;',
            '          font-size: 1.5rem;',
            '        }',
            '',
            '        .card p {',
            '          margin: 0;',
            '          font-size: 1.25rem;',
            '          line-height: 1.5;',
            '        }',
            '',
            '        .logo {',
            '          height: 1em;',
            '        }',
            '',
            '        @media (max-width: 600px) {',
            '          .grid {',
            '            width: 100%;',
            '            flex-direction: column;',
            '          }',
            '        }',
            '      `}</style>',
            '',
            '      <style jsx global>{`',
            '        html,',
            '        body {',
            '          padding: 0;',
            '          margin: 0;',
            '          font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Roboto,',
            '            Oxygen, Ubuntu, Cantarell, Fira Sans, Droid Sans, Helvetica Neue,',
            '            sans-serif;',
            '        }',
            '',
            '        * {',
            '          box-sizing: border-box;',
            '        }',
            '      `}</style>',
            '    </div>',
            '  )',
            '}',
            '',
        ];
        if (this.tailwind) {
            indexJs.unshift('import "tailwindcss/tailwind.css"');
        }
        const vercelSvg = [
            '<svg width="283" height="64" viewBox="0 0 283 64" fill="none" ',
            '    xmlns="http://www.w3.org/2000/svg">',
            '    <path d="M141.04 16c-11.04 0-19 7.2-19 18s8.96 18 20 18c6.67 0 12.55-2.64 16.19-7.09l-7.65-4.42c-2.02 2.21-5.09 3.5-8.54 3.5-4.79 0-8.86-2.5-10.37-6.5h28.02c.22-1.12.35-2.28.35-3.5 0-10.79-7.96-17.99-19-17.99zm-9.46 14.5c1.25-3.99 4.67-6.5 9.45-6.5 4.79 0 8.21 2.51 9.45 6.5h-18.9zM248.72 16c-11.04 0-19 7.2-19 18s8.96 18 20 18c6.67 0 12.55-2.64 16.19-7.09l-7.65-4.42c-2.02 2.21-5.09 3.5-8.54 3.5-4.79 0-8.86-2.5-10.37-6.5h28.02c.22-1.12.35-2.28.35-3.5 0-10.79-7.96-17.99-19-17.99zm-9.45 14.5c1.25-3.99 4.67-6.5 9.45-6.5 4.79 0 8.21 2.51 9.45 6.5h-18.9zM200.24 34c0 6 3.92 10 10 10 4.12 0 7.21-1.87 8.8-4.92l7.68 4.43c-3.18 5.3-9.14 8.49-16.48 8.49-11.05 0-19-7.2-19-18s7.96-18 19-18c7.34 0 13.29 3.19 16.48 8.49l-7.68 4.43c-1.59-3.05-4.68-4.92-8.8-4.92-6.07 0-10 4-10 10zm82.48-29v46h-9V5h9zM36.95 0L73.9 64H0L36.95 0zm92.38 5l-27.71 48L73.91 5H84.3l17.32 30 17.32-30h10.39zm58.91 12v9.69c-1-.29-2.06-.49-3.2-.49-5.81 0-10 4-10 10V51h-9V17h9v9.2c0-5.08 5.91-9.2 13.2-9.2z" fill="#000"/>',
            '</svg>',
        ];
        new sample_file_1.SampleDir(project, this.srcdir, {
            files: {
                ['index.' + this.fileExt]: indexJs.join('\n'),
            },
        });
        new sample_file_1.SampleDir(project, this.assetsdir, {
            files: {
                'vercel.svg': vercelSvg.join('\n'),
            },
        });
        new sample_file_1.SampleFile(project, 'next-env.d.ts', {
            contents: [
                '/// <reference types="next" />',
                '/// <reference types="next/types/global" />',
                '/// <reference types="next/image-types/global" />',
                '// NOTE: This file should not be edited',
                '// see https://nextjs.org/docs/basic-features/typescript for more information.',
                '',
            ].join('\n'),
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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