"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Version = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const component_1 = require("./component");
/**
 * @experimental
 */
class Version extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        super(project);
        this.changelogFileName = 'changelog.md';
        this.versionFileName = 'version.txt';
        this.releaseTagFileName = 'releasetag.txt';
        const versionInputFile = options.versionInputFile;
        // this command determines if there were any changes since the last release
        // (the top-most commit is not a bump). it is used as a condition for both
        // the `bump` and the `release` tasks.
        const changesSinceLastRelease = '! git log --oneline -1 | grep -q "chore(release):"';
        const changelogFile = path_1.posix.join(options.artifactsDirectory, this.changelogFileName);
        const bumpFile = path_1.posix.join(options.artifactsDirectory, this.versionFileName);
        const releaseTagFile = path_1.posix.join(options.artifactsDirectory, this.releaseTagFileName);
        const env = {
            OUTFILE: versionInputFile,
            CHANGELOG: changelogFile,
            BUMPFILE: bumpFile,
            RELEASETAG: releaseTagFile,
            // doesn't work if custom configuration is long
            VERSIONRCOPTIONS: JSON.stringify(options.versionrcOptions),
        };
        this.bumpTask = project.addTask('bump', {
            description: 'Bumps version based on latest git tag and generates a changelog entry',
            condition: changesSinceLastRelease,
            env: env,
        });
        this.bumpTask.builtin('release/bump-version');
        this.unbumpTask = project.addTask('unbump', {
            description: 'Restores version to 0.0.0',
            env: env,
        });
        this.unbumpTask.builtin('release/reset-version');
        project.addGitIgnore(`/${changelogFile}`);
        project.addGitIgnore(`/${bumpFile}`);
        project.addPackageIgnore(`/${changelogFile}`);
        project.addPackageIgnore(`/${bumpFile}`);
    }
}
exports.Version = Version;
_a = JSII_RTTI_SYMBOL_1;
Version[_a] = { fqn: "projen.Version", version: "0.40.1" };
/**
 * @experimental
 */
Version.STANDARD_VERSION = 'standard-version@^9';
//# sourceMappingURL=data:application/json;base64,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