import { Project } from '../project';
export interface SynthOutput {
    [filePath: string]: any;
}
/**
 * Creates a snapshot of the files generated by a project. Ignores any non-text
 * files so that the snapshots are human readable.
 */
export declare function synthSnapshot(project: Project): SynthOutput;
export interface DirectorySnapshotOptions {
    /**
     * Globs of files to exclude.
     * @default [] include all files
     */
    readonly excludeGlobs?: string[];
}
export declare function directorySnapshot(root: string, options?: DirectorySnapshotOptions): SynthOutput;
