"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Parses a projenrc.json file, uses it to generate a corresponding
 * projenrc.js file, and then run it to synthesize its contents.
 *
 * Environment variables:
 *
 * - PROJENRC_FILE: (optional) the name of the JSON file to parse from.
 *   Defaults to `.projenrc.json`.
 */
const fs = require("fs-extra");
const option_hints_1 = require("./option-hints");
const projects_1 = require("./projects");
let filename = process.env.PROJENRC_FILE;
if (!filename || filename == '') {
    filename = '.projenrc.json';
}
const { type, ...json } = fs.readJsonSync(filename, { encoding: 'utf8' });
if (!type) {
    throw new Error('projenrc.json requires a "type" field with the fully qualified type name. e.g. projen.web.ReactProject');
}
projects_1.Projects.createProject({
    dir: '.',
    projectFqn: type,
    projectOptions: json,
    optionHints: option_hints_1.NewProjectOptionHints.NONE,
    synth: true,
    post: false,
});
//# sourceMappingURL=data:application/json;base64,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