import { Component } from '../component';
import { GitHubProject } from '../github';
import { Job, JobStep } from '../github/workflows-model';
import { Task } from '../task';
import { Publisher } from './publisher';
import { ReleaseTrigger } from './release-trigger';
/**
 * (experimental) Project options for release.
 *
 * @experimental
 */
export interface ReleaseProjectOptions {
    /**
     * (deprecated) Automatically release new versions every commit to one of branches in `releaseBranches`.
     *
     * @default true
     * @deprecated Use `releaseTrigger: ReleaseTrigger.continuous()` instead
     */
    readonly releaseEveryCommit?: boolean;
    /**
     * (deprecated) CRON schedule to trigger new releases.
     *
     * @default - no scheduled releases
     * @deprecated Use `releaseTrigger: ReleaseTrigger.scheduled()` instead
     */
    readonly releaseSchedule?: string;
    /**
     * (experimental) The release trigger to use.
     *
     * @default - Continuous releases (`ReleaseTrigger.continuous()`)
     * @experimental
     */
    readonly releaseTrigger?: ReleaseTrigger;
    /**
     * (experimental) A directory which will contain artifacts to be published to npm.
     *
     * @default "dist"
     * @experimental
     */
    readonly artifactsDirectory?: string;
    /**
     * (experimental) A set of workflow steps to execute in order to setup the workflow container.
     *
     * @experimental
     */
    readonly releaseWorkflowSetupSteps?: JobStep[];
    /**
     * (experimental) Container image to use for GitHub workflows.
     *
     * @default - default image
     * @experimental
     */
    readonly workflowContainerImage?: string;
    /**
     * (experimental) Version requirement of `jsii-release` which is used to publish modules to npm.
     *
     * @default "latest"
     * @experimental
     */
    readonly jsiiReleaseVersion?: string;
    /**
     * (experimental) Steps to execute after build as part of the release workflow.
     *
     * @default []
     * @experimental
     */
    readonly postBuildSteps?: JobStep[];
    /**
     * (experimental) Checks that after build there are no modified files on git.
     *
     * @default true
     * @experimental
     */
    readonly antitamper?: boolean;
    /**
     * (experimental) Major version to release from the default branch.
     *
     * If this is specified, we bump the latest version of this major version line.
     * If not specified, we bump the global latest version.
     *
     * @default - Major version is not enforced.
     * @experimental
     */
    readonly majorVersion?: number;
    /**
     * (experimental) Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").
     *
     * @default - normal semantic versions
     * @experimental
     */
    readonly prerelease?: string;
    /**
     * (experimental) The npmDistTag to use when publishing from the default branch.
     *
     * To set the npm dist-tag for release branches, set the `npmDistTag` property
     * for each branch.
     *
     * @default "latest"
     * @experimental
     */
    readonly npmDistTag?: string;
    /**
     * (experimental) The name of the default release workflow.
     *
     * @default "Release"
     * @experimental
     */
    readonly releaseWorkflowName?: string;
    /**
     * (experimental) Defines additional release branches.
     *
     * A workflow will be created for each
     * release branch which will publish releases from commits in this branch.
     * Each release branch _must_ be assigned a major version number which is used
     * to enforce that versions published from that branch always use that major
     * version. If multiple branches are used, the `majorVersion` field must also
     * be provided for the default branch.
     *
     * @default - no additional branches are used for release. you can use
     * `addBranch()` to add additional branches.
     * @experimental
     */
    readonly releaseBranches?: {
        [name: string]: BranchOptions;
    };
    /**
     * (experimental) Create a github issue on every failed publishing task.
     *
     * @default false
     * @experimental
     */
    readonly releaseFailureIssue?: boolean;
    /**
     * (experimental) The label to apply to issues indicating publish failures.
     *
     * Only applies if `releaseFailureIssue` is true.
     *
     * @default "failed-release"
     * @experimental
     */
    readonly releaseFailureIssueLabel?: string;
    /**
     * (experimental) Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.
     *
     * Note: this prefix is used to detect the latest tagged version
     * when bumping, so if you change this on a project with an existing version
     * history, you may need to manually tag your latest release
     * with the new prefix.
     *
     * @default - no prefix
     * @experimental
     */
    readonly releaseTagPrefix?: string;
    /**
     * (experimental) Custom configuration used when creating changelog with standard-version package.
     *
     * Given values either append to default configuration or overwrite values in it.
     *
     * @default - standard configuration applicable for GitHub repositories
     * @experimental
     */
    readonly versionrcOptions?: Record<string, any>;
    /**
     * (experimental) Github Runner selection labels.
     *
     * @default ["ubuntu-latest"]
     * @experimental
     */
    readonly workflowRunsOn?: string[];
    /**
     * (experimental) Define publishing tasks that can be executed manually as well as workflows.
     *
     * Normally, publishing only happens within automated workflows. Enable this
     * in order to create a publishing task for each publishing activity.
     *
     * @default false
     * @experimental
     */
    readonly publishTasks?: boolean;
}
/**
 * (experimental) Options for `Release`.
 *
 * @experimental
 */
export interface ReleaseOptions extends ReleaseProjectOptions {
    /**
     * (experimental) The task to execute in order to create the release artifacts.
     *
     * Artifacts are
     * expected to reside under `artifactsDirectory` (defaults to `dist/`) once
     * build is complete.
     *
     * @experimental
     */
    readonly task: Task;
    /**
     * (experimental) A name of a .json file to set the `version` field in after a bump.
     *
     * @experimental
     * @example
     *
     * "package.json"
     */
    readonly versionFile: string;
    /**
     * (experimental) The default branch name to release from.
     *
     * Use `majorVersion` to restrict this branch to only publish releases with a
     * specific major version.
     *
     * You can add additional branches using `addBranch()`.
     *
     * @experimental
     */
    readonly branch: string;
    /**
     * (experimental) Create a GitHub release for each release.
     *
     * @default true
     * @experimental
     */
    readonly githubRelease?: boolean;
}
/**
 * (experimental) Manages releases (currently through GitHub workflows).
 *
 * By default, no branches are released. To add branches, call `addBranch()`.
 *
 * @experimental
 */
export declare class Release extends Component {
    /**
     * (experimental) Package publisher.
     *
     * @experimental
     */
    readonly publisher: Publisher;
    private readonly buildTask;
    private readonly version;
    private readonly postBuildSteps;
    private readonly antitamper;
    private readonly artifactsDirectory;
    private readonly versionFile;
    private readonly releaseTrigger;
    private readonly preBuildSteps;
    private readonly containerImage?;
    private readonly _branches;
    private readonly jobs;
    private readonly defaultBranch;
    private readonly github?;
    private readonly workflowRunsOn?;
    /**
     * @experimental
     */
    constructor(project: GitHubProject, options: ReleaseOptions);
    /**
     * (experimental) Adds a release branch.
     *
     * It is a git branch from which releases are published. If a project has more than one release
     * branch, we require that `majorVersion` is also specified for the primary branch in order to
     * ensure branches always release the correct version.
     *
     * @param branch The branch to monitor (e.g. `main`, `v2.x`).
     * @param options Branch definition.
     * @experimental
     */
    addBranch(branch: string, options: BranchOptions): void;
    /**
     * Adds a release branch.
     *
     * It is a git branch from which releases are published. If a project has more than one release
     * branch, we require that `majorVersion` is also specified for the primary branch in order to
     * ensure branches always release the correct version.
     *
     * @param branch The branch to monitor (e.g. `main`, `v2.x`)
     * @param options Branch definition
     */
    private _addBranch;
    /**
     * (experimental) Called before synthesis.
     *
     * @experimental
     */
    preSynthesize(): void;
    /**
     * (experimental) Adds jobs to all release workflows.
     *
     * @param jobs The jobs to add (name => job).
     * @experimental
     */
    addJobs(jobs: Record<string, Job>): void;
    /**
     * (experimental) Retrieve all release branch names.
     *
     * @experimental
     */
    get branches(): string[];
    /**
     * @returns a workflow or `undefined` if github integration is disabled.
     */
    private createWorkflow;
}
/**
 * (experimental) Options for a release branch.
 *
 * @experimental
 */
export interface BranchOptions {
    /**
     * (experimental) The name of the release workflow.
     *
     * @default "release-BRANCH"
     * @experimental
     */
    readonly workflowName?: string;
    /**
     * (experimental) The major versions released from this branch.
     *
     * @experimental
     */
    readonly majorVersion: number;
    /**
     * (experimental) Bump the version as a pre-release tag.
     *
     * @default - normal releases
     * @experimental
     */
    readonly prerelease?: string;
    /**
     * (experimental) Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.
     *
     * Note: this prefix is used to detect the latest tagged version
     * when bumping, so if you change this on a project with an existing version
     * history, you may need to manually tag your latest release
     * with the new prefix.
     *
     * @default - no prefix
     * @experimental
     */
    readonly tagPrefix?: string;
    /**
     * (experimental) The npm distribution tag to use for this branch.
     *
     * @default "latest"
     * @experimental
     */
    readonly npmDistTag?: string;
}
