"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.isAwsCodeArtifactRegistry = exports.Publisher = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const constants_1 = require("../github/constants");
const workflows_model_1 = require("../github/workflows-model");
const node_package_1 = require("../javascript/node-package");
const JSII_RELEASE_VERSION = 'latest';
const GITHUB_PACKAGES_REGISTRY = 'npm.pkg.github.com';
const GITHUB_PACKAGES_MAVEN_REPOSITORY = 'https://maven.pkg.github.com';
const ARTIFACTS_DOWNLOAD_DIR = 'dist';
const JSII_RELEASE_IMAGE = 'jsii/superchain:1-buster-slim-node14';
const AWS_CODEARTIFACT_REGISTRY_REGEX = /.codeartifact.*.amazonaws.com/;
/**
 * (experimental) Implements GitHub jobs for publishing modules to package managers.
 *
 * Under the hood, it uses https://github.com/aws/jsii-release
 *
 * @experimental
 */
class Publisher extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b, _c, _d, _e, _f;
        super(project);
        // functions that create jobs associated with a specific branch
        this._jobFactories = [];
        this.buildJobId = options.buildJobId;
        this.artifactName = options.artifactName;
        this.jsiiReleaseVersion = (_b = options.jsiiReleaseVersion) !== null && _b !== void 0 ? _b : JSII_RELEASE_VERSION;
        this.condition = options.condition;
        this.failureIssue = (_c = options.failureIssue) !== null && _c !== void 0 ? _c : false;
        this.failureIssueLabel = (_d = options.failureIssueLabel) !== null && _d !== void 0 ? _d : 'failed-release';
        this.runsOn = (_e = options.workflowRunsOn) !== null && _e !== void 0 ? _e : ['ubuntu-latest'];
        this.publishTasks = (_f = options.publishTasks) !== null && _f !== void 0 ? _f : false;
    }
    /**
     * Called by `Release` to add the publishing jobs to a release workflow
     * associated with a specific branch.
     * @param branch The branch name
     * @param options Branch options
     *
     * @internal
     */
    _renderJobsForBranch(branch, options) {
        let jobs = {};
        for (const factory of this._jobFactories) {
            jobs = {
                ...jobs,
                ...factory(branch, options),
            };
        }
        return jobs;
    }
    /**
     * (experimental) Publish to git.
     *
     * This includes generating a project-level changelog and release tags.
     *
     * @param options Options.
     * @experimental
     */
    publishToGit(options) {
        var _b;
        const releaseTagFile = options.releaseTagFile;
        const versionFile = options.versionFile;
        const changelog = options.changelogFile;
        const projectChangelogFile = options.projectChangelogFile;
        const gitBranch = (_b = options.gitBranch) !== null && _b !== void 0 ? _b : 'main';
        const taskName = (gitBranch === 'main' || gitBranch === 'master') ? 'publish:git' : `publish:git:${gitBranch}`;
        const publishTask = this.project.addTask(taskName, {
            description: 'Prepends the release changelog onto the project changelog, creates a release commit, and tags the release',
            env: {
                CHANGELOG: changelog,
                RELEASE_TAG_FILE: releaseTagFile,
                PROJECT_CHANGELOG_FILE: projectChangelogFile !== null && projectChangelogFile !== void 0 ? projectChangelogFile : '',
                VERSION_FILE: versionFile,
            },
        });
        if (projectChangelogFile) {
            publishTask.builtin('release/update-changelog');
        }
        publishTask.builtin('release/tag-version');
        if (options.gitPushCommand !== '') {
            const gitPushCommand = options.gitPushCommand || `git push --follow-tags origin ${gitBranch}`;
            publishTask.exec(gitPushCommand);
        }
        return publishTask;
    }
    /**
     * (experimental) Creates a GitHub Release.
     *
     * @param options Options.
     * @experimental
     */
    publishToGitHubReleases(options) {
        const changelogFile = options.changelogFile;
        const releaseTagFile = options.releaseTagFile;
        // create a github release
        const releaseTag = `$(cat ${releaseTagFile})`;
        const ghRelease = [
            `gh release create ${releaseTag}`,
            '-R $GITHUB_REPOSITORY',
            `-F ${changelogFile}`,
            `-t ${releaseTag}`,
            '--target $GITHUB_REF',
        ].join(' ');
        // release script that does not error when re-releasing a given version
        const idempotentRelease = [
            'errout=$(mktemp);',
            `${ghRelease} 2> $errout && true;`,
            'exitcode=$?;',
            'if [ $exitcode -ne 0 ] && ! grep -q "Release.tag_name already exists" $errout; then',
            'cat $errout;',
            'exit $exitcode;',
            'fi',
        ].join(' ');
        this.addPublishJob(() => {
            return {
                name: 'github',
                registryName: 'GitHub Releases',
                permissions: {
                    contents: workflows_model_1.JobPermission.WRITE,
                },
                workflowEnv: {
                    GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                    GITHUB_REPOSITORY: '${{ github.repository }}',
                    GITHUB_REF: '${{ github.ref }}',
                },
                run: idempotentRelease,
            };
        });
    }
    /**
     * (experimental) Publishes artifacts from `js/**` to npm.
     *
     * @param options Options.
     * @experimental
     */
    publishToNpm(options = {}) {
        var _b;
        const isGitHubPackages = (_b = options.registry) === null || _b === void 0 ? void 0 : _b.startsWith(GITHUB_PACKAGES_REGISTRY);
        const isAwsCodeArtifact = isAwsCodeArtifactRegistry(options.registry);
        const npmToken = node_package_1.defaultNpmToken(options.npmTokenSecret, options.registry);
        if (options.distTag) {
            this.project.logger.warn('The `distTag` option is deprecated. Use the npmDistTag option instead.');
        }
        this.addPublishJob((_branch, branchOptions) => {
            var _b, _c, _d, _e, _f, _g, _h;
            if (branchOptions.npmDistTag && options.distTag) {
                throw new Error('cannot set branch-level npmDistTag and npmDistTag in publishToNpm()');
            }
            return {
                name: 'npm',
                run: this.jsiiReleaseCommand('jsii-release-npm'),
                containerImage: JSII_RELEASE_IMAGE,
                registryName: 'npm',
                env: {
                    NPM_DIST_TAG: (_c = (_b = branchOptions.npmDistTag) !== null && _b !== void 0 ? _b : options.distTag) !== null && _c !== void 0 ? _c : 'latest',
                    NPM_REGISTRY: options.registry,
                },
                permissions: {
                    contents: workflows_model_1.JobPermission.READ,
                    packages: isGitHubPackages ? workflows_model_1.JobPermission.WRITE : undefined,
                },
                workflowEnv: {
                    NPM_TOKEN: npmToken ? secret(npmToken) : undefined,
                    // if we are publishing to AWS CodeArtifact, pass AWS access keys that will be used to generate NPM_TOKEN using AWS CLI.
                    AWS_ACCESS_KEY_ID: isAwsCodeArtifact ? secret((_e = (_d = options.codeArtifactOptions) === null || _d === void 0 ? void 0 : _d.accessKeyIdSecret) !== null && _e !== void 0 ? _e : 'AWS_ACCESS_KEY_ID') : undefined,
                    AWS_SECRET_ACCESS_KEY: isAwsCodeArtifact ? secret((_g = (_f = options.codeArtifactOptions) === null || _f === void 0 ? void 0 : _f.secretAccessKeySecret) !== null && _g !== void 0 ? _g : 'AWS_SECRET_ACCESS_KEY') : undefined,
                    AWS_ROLE_TO_ASSUME: isAwsCodeArtifact ? (_h = options.codeArtifactOptions) === null || _h === void 0 ? void 0 : _h.roleToAssume : undefined,
                },
            };
        });
    }
    /**
     * (experimental) Publishes artifacts from `dotnet/**` to NuGet Gallery.
     *
     * @param options Options.
     * @experimental
     */
    publishToNuget(options = {}) {
        this.addPublishJob((_branch, _branchOptions) => {
            var _b;
            return ({
                name: 'nuget',
                containerImage: JSII_RELEASE_IMAGE,
                run: this.jsiiReleaseCommand('jsii-release-nuget'),
                registryName: 'NuGet Gallery',
                workflowEnv: {
                    NUGET_API_KEY: secret((_b = options.nugetApiKeySecret) !== null && _b !== void 0 ? _b : 'NUGET_API_KEY'),
                },
            });
        });
    }
    /**
     * (experimental) Publishes artifacts from `java/**` to Maven.
     *
     * @param options Options.
     * @experimental
     */
    publishToMaven(options = {}) {
        var _b, _c;
        const isGitHubPackages = (_b = options.mavenRepositoryUrl) === null || _b === void 0 ? void 0 : _b.startsWith(GITHUB_PACKAGES_MAVEN_REPOSITORY);
        const isGitHubActor = isGitHubPackages && options.mavenUsername == undefined;
        const mavenServerId = (_c = options.mavenServerId) !== null && _c !== void 0 ? _c : (isGitHubPackages ? 'github' : undefined);
        if (isGitHubPackages && mavenServerId != 'github') {
            throw new Error('publishing to GitHub Packages requires the "mavenServerId" to be "github"');
        }
        this.addPublishJob((_branch, _branchOptions) => {
            var _b, _c, _d, _e, _f;
            return ({
                name: 'maven',
                registryName: 'Maven Central',
                containerImage: JSII_RELEASE_IMAGE,
                run: this.jsiiReleaseCommand('jsii-release-maven'),
                env: {
                    MAVEN_ENDPOINT: options.mavenEndpoint,
                    MAVEN_SERVER_ID: mavenServerId,
                    MAVEN_REPOSITORY_URL: options.mavenRepositoryUrl,
                },
                workflowEnv: {
                    MAVEN_GPG_PRIVATE_KEY: isGitHubPackages ? undefined : secret((_b = options.mavenGpgPrivateKeySecret) !== null && _b !== void 0 ? _b : 'MAVEN_GPG_PRIVATE_KEY'),
                    MAVEN_GPG_PRIVATE_KEY_PASSPHRASE: isGitHubPackages ? undefined : secret((_c = options.mavenGpgPrivateKeyPassphrase) !== null && _c !== void 0 ? _c : 'MAVEN_GPG_PRIVATE_KEY_PASSPHRASE'),
                    MAVEN_PASSWORD: secret((_d = options.mavenPassword) !== null && _d !== void 0 ? _d : (isGitHubPackages ? 'GITHUB_TOKEN' : 'MAVEN_PASSWORD')),
                    MAVEN_USERNAME: isGitHubActor ? '${{ github.actor }}' : secret((_e = options.mavenUsername) !== null && _e !== void 0 ? _e : 'MAVEN_USERNAME'),
                    MAVEN_STAGING_PROFILE_ID: isGitHubPackages ? undefined : secret((_f = options.mavenStagingProfileId) !== null && _f !== void 0 ? _f : 'MAVEN_STAGING_PROFILE_ID'),
                },
                permissions: {
                    contents: workflows_model_1.JobPermission.READ,
                    packages: isGitHubPackages ? workflows_model_1.JobPermission.WRITE : undefined,
                },
            });
        });
    }
    /**
     * (experimental) Publishes wheel artifacts from `python` to PyPI.
     *
     * @param options Options.
     * @experimental
     */
    publishToPyPi(options = {}) {
        this.addPublishJob((_branch, _branchOptions) => {
            var _b, _c;
            return ({
                name: 'pypi',
                registryName: 'PyPI',
                run: this.jsiiReleaseCommand('jsii-release-pypi'),
                containerImage: JSII_RELEASE_IMAGE,
                env: {
                    TWINE_REPOSITORY_URL: options.twineRegistryUrl,
                },
                workflowEnv: {
                    TWINE_USERNAME: secret((_b = options.twineUsernameSecret) !== null && _b !== void 0 ? _b : 'TWINE_USERNAME'),
                    TWINE_PASSWORD: secret((_c = options.twinePasswordSecret) !== null && _c !== void 0 ? _c : 'TWINE_PASSWORD'),
                },
            });
        });
    }
    /**
     * (experimental) Adds a go publishing job.
     *
     * @param options Options.
     * @experimental
     */
    publishToGo(options = {}) {
        this.addPublishJob((_branch, _branchOptions) => {
            var _b, _c, _d;
            return ({
                name: 'golang',
                run: this.jsiiReleaseCommand('jsii-release-golang'),
                containerImage: JSII_RELEASE_IMAGE,
                registryName: 'GitHub',
                env: {
                    GITHUB_REPO: options.githubRepo,
                    GIT_BRANCH: options.gitBranch,
                    GIT_USER_NAME: (_b = options.gitUserName) !== null && _b !== void 0 ? _b : constants_1.DEFAULT_GITHUB_ACTIONS_USER.name,
                    GIT_USER_EMAIL: (_c = options.gitUserEmail) !== null && _c !== void 0 ? _c : constants_1.DEFAULT_GITHUB_ACTIONS_USER.email,
                    GIT_COMMIT_MESSAGE: options.gitCommitMessage,
                },
                workflowEnv: {
                    GITHUB_TOKEN: secret((_d = options.githubTokenSecret) !== null && _d !== void 0 ? _d : 'GO_GITHUB_TOKEN'),
                },
            });
        });
    }
    addPublishJob(factory) {
        this._jobFactories.push((branch, branchOptions) => {
            var _b, _c;
            const opts = factory(branch, branchOptions);
            const jobname = `release_${opts.name}`;
            if (jobname in this._jobFactories) {
                throw new Error(`Duplicate job with name "${jobname}"`);
            }
            const requiredEnv = new Array();
            // jobEnv is the env we pass to the github job (task environment + secrets/expressions).
            const jobEnv = { ...opts.env };
            const workflowEnvEntries = Object.entries((_b = opts.workflowEnv) !== null && _b !== void 0 ? _b : {})
                .filter(([_, value]) => value != undefined);
            for (const [name, expression] of workflowEnvEntries) {
                requiredEnv.push(name);
                jobEnv[name] = expression;
            }
            if (this.publishTasks) {
                const branchSuffix = (branch === 'main' || branch === 'master') ? '' : `:${branch}`;
                // define a task which can be used through `projen publish:xxx`.
                const task = this.project.addTask(`publish:${opts.name.toLocaleLowerCase()}${branchSuffix}`, {
                    description: `Publish this package to ${opts.registryName}`,
                    env: opts.env,
                    requiredEnv: requiredEnv,
                });
                // first verify that we are on the correct branch
                task.exec(`test "$(git branch --show-current)" = "${branch}"`);
                // run commands
                task.exec(opts.run);
            }
            const steps = [
                {
                    name: 'Download build artifacts',
                    uses: 'actions/download-artifact@v2',
                    with: {
                        name: this.artifactName,
                        path: ARTIFACTS_DOWNLOAD_DIR,
                    },
                },
                {
                    name: 'Release',
                    // it would have been nice if we could just run "projen publish:xxx" here but that is not possible because this job does not checkout sources
                    run: opts.run,
                    env: jobEnv,
                },
            ];
            const perms = (_c = opts.permissions) !== null && _c !== void 0 ? _c : { contents: workflows_model_1.JobPermission.READ };
            if (this.failureIssue) {
                steps.push(...[
                    {
                        name: 'Extract Version',
                        if: '${{ failure() }}',
                        id: 'extract-version',
                        run: 'echo "::set-output name=VERSION::$(cat dist/version.txt)"',
                    },
                    {
                        name: 'Create Issue',
                        if: '${{ failure() }}',
                        uses: 'imjohnbo/issue-bot@v3',
                        with: {
                            labels: this.failureIssueLabel,
                            title: `Publishing v\${{ steps.extract-version.outputs.VERSION }} to ${opts.registryName} failed`,
                            body: 'See https://github.com/${{ github.repository }}/actions/runs/${{ github.run_id }}',
                        },
                        env: {
                            GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                        },
                    },
                ]);
                Object.assign(perms, { issues: workflows_model_1.JobPermission.WRITE });
            }
            return {
                [jobname]: {
                    name: `Publish to ${opts.registryName}`,
                    permissions: perms,
                    if: this.condition,
                    needs: [this.buildJobId],
                    runsOn: this.runsOn,
                    container: opts.containerImage ? {
                        image: opts.containerImage,
                    } : undefined,
                    steps,
                },
            };
        });
    }
    jsiiReleaseCommand(command) {
        return `npx -p jsii-release@${this.jsiiReleaseVersion} ${command}`;
    }
}
exports.Publisher = Publisher;
_a = JSII_RTTI_SYMBOL_1;
Publisher[_a] = { fqn: "projen.release.Publisher", version: "0.40.1" };
function secret(secretName) {
    return `\${{ secrets.${secretName} }}`;
}
/**
 * Evaluates if the `registryUrl` is a AWS CodeArtifact registry.
 * @param registryUrl url of registry
 * @returns true for AWS CodeArtifact
 */
function isAwsCodeArtifactRegistry(registryUrl) {
    return registryUrl && AWS_CODEARTIFACT_REGISTRY_REGEX.test(registryUrl);
}
exports.isAwsCodeArtifactRegistry = isAwsCodeArtifactRegistry;
//# sourceMappingURL=data:application/json;base64,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