"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const case_1 = require("case");
const fs_extra_1 = require("fs-extra");
const common_1 = require("../common");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
const inventory_1 = require("../inventory");
/**
 * (experimental) Allows writing projenrc files in python.
 *
 * This will install `projen` as a Python dependency and will add a
 * `synth` task which will run `.projenrc.py`.
 *
 * @experimental
 */
class Projenrc extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b, _c;
        super(project);
        const projenVersion = (_b = options.projenVersion) !== null && _b !== void 0 ? _b : common_1.PROJEN_VERSION; // ?
        this.rcfile = (_c = options.filename) !== null && _c !== void 0 ? _c : '.projenrc.py';
        project.deps.addDependency(`projen@${projenVersion}`, dependencies_1.DependencyType.DEVENV);
        // set up the "default" task which is the task executed when `projen` is executed for this project.
        project.defaultTask.exec('python projenrc.py');
        // if this is a new project, generate a skeleton for projenrc.py
        this.generateProjenrc();
    }
    generateProjenrc() {
        var _b, _c, _d;
        const bootstrap = this.project.newProject;
        if (!bootstrap) {
            return;
        }
        const jsiiFqn = bootstrap.fqn;
        const jsiiManifest = inventory_1.readJsiiManifest(jsiiFqn);
        const jsiiType = jsiiManifest.types[jsiiFqn];
        const optionsTypeFqn = (_d = (_c = (_b = jsiiType.initializer) === null || _b === void 0 ? void 0 : _b.parameters) === null || _c === void 0 ? void 0 : _c[0].type) === null || _d === void 0 ? void 0 : _d.fqn;
        if (!optionsTypeFqn) {
            this.project.logger.warn('cannot determine jsii type for project options');
            return;
        }
        const pythonFile = path_1.join(this.project.outdir, this.rcfile);
        // skip if file exists
        if (fs_extra_1.existsSync(pythonFile)) {
            return;
        }
        const lines = new Array();
        let indent = 0;
        const emit = (line = '') => lines.push(' '.repeat(indent * 4) + line);
        // const openBlock = (line: string = '') => { emit(line + ' {'); indent++; };
        // const closeBlock = () => { indent--; emit('}'); };
        const optionFqns = {};
        for (const option of bootstrap.type.options) {
            if (option.fqn) {
                optionFqns[option.name] = option.fqn;
            }
        }
        const { renderedOptions, imports } = renderPythonOptions(indent, optionFqns, bootstrap.args);
        emit(toPythonImport(jsiiFqn));
        for (const fqn of imports) {
            emit(toPythonImport(fqn));
        }
        emit();
        emit(`project = ${jsiiType.name}(${renderedOptions});`);
        emit();
        emit('project.synth();');
        fs_extra_1.mkdirpSync(path_1.dirname(pythonFile));
        fs_extra_1.writeFileSync(pythonFile, lines.join('\n'));
        this.project.logger.info(`Project definition file was created at ${pythonFile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.python.Projenrc", version: "0.40.1" };
function renderPythonOptions(indent, optionFqns, initOptions) {
    const imports = new Set();
    if (!initOptions || Object.keys(initOptions).length === 0) { // no options
        return { renderedOptions: '', imports };
    }
    const lines = [''];
    for (const [name, value] of Object.entries(initOptions)) {
        const { pythonValue, importName } = toPythonValue(value, name, optionFqns);
        if (importName)
            imports.add(importName);
        lines.push(`${toPythonProperty(name)}=${pythonValue},`);
    }
    const renderedOptions = lines.join(`\n${' '.repeat((indent + 1) * 4)}`).concat('\n');
    return { renderedOptions, imports };
}
function toPythonProperty(prop) {
    return case_1.snake(prop);
}
function toPythonValue(value, name, optionFqns) {
    if (typeof value === 'boolean') {
        return { pythonValue: value ? 'True' : 'False' };
    }
    else if (typeof value === 'number') {
        return { pythonValue: JSON.stringify(value) };
    }
    else if (typeof value === 'string') {
        if (optionFqns[name] !== undefined) {
            const parts = optionFqns[name].split('.');
            const base = parts[parts.length - 1];
            const choice = String(value).toUpperCase().replace(/-/g, '_');
            return { pythonValue: `${base}.${choice}`, importName: optionFqns[name] };
        }
        else {
            return { pythonValue: JSON.stringify(value) };
        }
    }
    else if (value === undefined || value === null) {
        return { pythonValue: 'None' };
    }
    else {
        return { pythonValue: JSON.stringify(value) };
    }
}
function toPythonImport(fqn) {
    const parts = fqn.split('.');
    if (parts.length === 1) {
        return `import ${parts[0]}`;
    }
    else {
        return `from ${parts.slice(0, -1).join('.')} import ${parts[parts.length - 1]}`;
    }
}
//# sourceMappingURL=data:application/json;base64,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