import { Component } from './component';
import { Project } from './project';
import { Task } from './task';
/**
 * (experimental) Manages a standard build process for all projects.
 *
 * Build spawns these tasks in order:
 * 1. default
 * 2. pre-compile
 * 3. compile
 * 4. post-compile
 * 5. test
 * 6. package
 *
 * @experimental
 */
export declare class ProjectBuild extends Component {
    /**
     * (experimental) The task responsible for a full release build.
     *
     * @experimental
     */
    readonly buildTask: Task;
    /**
     * (experimental) Pre-compile task.
     *
     * @experimental
     */
    readonly preCompileTask: Task;
    /**
     * (experimental) Compiles the code.
     *
     * By default for node.js projects this task is empty.
     *
     * @experimental
     */
    readonly compileTask: Task;
    /**
     * (experimental) Post-compile task.
     *
     * @experimental
     */
    readonly postCompileTask: Task;
    /**
     * (experimental) Tests the code.
     *
     * @experimental
     */
    readonly testTask: Task;
    /**
     * (experimental) The "package" task.
     *
     * @experimental
     */
    readonly packageTask: Task;
    /**
     * @experimental
     */
    constructor(project: Project);
}
