"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.License = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs-extra");
const file_1 = require("./file");
/**
 * @experimental
 */
class License extends file_1.FileBase {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b;
        super(project, 'LICENSE');
        const spdx = options.spdx;
        const textFile = `${__dirname}/../license-text/${spdx}.txt`;
        if (!fs.existsSync(textFile)) {
            throw new Error(`unsupported license ${spdx}`);
        }
        const years = (_b = options.copyrightPeriod) !== null && _b !== void 0 ? _b : new Date().getFullYear().toString();
        const owner = options.copyrightOwner;
        let text = fs.readFileSync(textFile, 'utf-8');
        text = text.replace('$copyright_period', years);
        // if the license text includes $copyright_owner, then `copyrightOwner` is required.
        if (text.indexOf('$copyright_owner') !== -1) {
            if (!owner) {
                throw new Error(`The ${spdx} license requires "copyrightOwner" to be specified`);
            }
            text = text.replace('$copyright_owner', owner);
        }
        this.text = text;
    }
    /**
     * (experimental) Implemented by derived classes and returns the contents of the file to emit.
     *
     * @experimental
     */
    synthesizeContent(_) {
        return this.text;
    }
}
exports.License = License;
_a = JSII_RTTI_SYMBOL_1;
License[_a] = { fqn: "projen.License", version: "0.40.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGljZW5zZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9saWNlbnNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsK0JBQStCO0FBQy9CLGlDQUE2Qzs7OztBQWM3QyxNQUFhLE9BQVEsU0FBUSxlQUFROzs7O0lBR25DLFlBQVksT0FBZ0IsRUFBRSxPQUF1Qjs7UUFDbkQsS0FBSyxDQUFDLE9BQU8sRUFBRSxTQUFTLENBQUMsQ0FBQztRQUUxQixNQUFNLElBQUksR0FBRyxPQUFPLENBQUMsSUFBSSxDQUFDO1FBRTFCLE1BQU0sUUFBUSxHQUFHLEdBQUcsU0FBUyxvQkFBb0IsSUFBSSxNQUFNLENBQUM7UUFDNUQsSUFBSSxDQUFDLEVBQUUsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLEVBQUU7WUFDNUIsTUFBTSxJQUFJLEtBQUssQ0FBQyx1QkFBdUIsSUFBSSxFQUFFLENBQUMsQ0FBQztTQUNoRDtRQUVELE1BQU0sS0FBSyxTQUFHLE9BQU8sQ0FBQyxlQUFlLG1DQUFJLElBQUksSUFBSSxFQUFFLENBQUMsV0FBVyxFQUFFLENBQUMsUUFBUSxFQUFFLENBQUM7UUFDN0UsTUFBTSxLQUFLLEdBQUcsT0FBTyxDQUFDLGNBQWMsQ0FBQztRQUVyQyxJQUFJLElBQUksR0FBRyxFQUFFLENBQUMsWUFBWSxDQUFDLFFBQVEsRUFBRSxPQUFPLENBQUMsQ0FBQztRQUU5QyxJQUFJLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxtQkFBbUIsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUVoRCxvRkFBb0Y7UUFDcEYsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLGtCQUFrQixDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUU7WUFDM0MsSUFBSSxDQUFDLEtBQUssRUFBRTtnQkFDVixNQUFNLElBQUksS0FBSyxDQUFDLE9BQU8sSUFBSSxvREFBb0QsQ0FBQyxDQUFDO2FBQ2xGO1lBRUQsSUFBSSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLENBQUM7U0FDaEQ7UUFFRCxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztJQUNuQixDQUFDOzs7Ozs7SUFFUyxpQkFBaUIsQ0FBQyxDQUFZO1FBQ3RDLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQztJQUNuQixDQUFDOztBQWxDSCwwQkFtQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBmcyBmcm9tICdmcy1leHRyYSc7XG5pbXBvcnQgeyBGaWxlQmFzZSwgSVJlc29sdmVyIH0gZnJvbSAnLi9maWxlJztcbmltcG9ydCB7IFByb2plY3QgfSBmcm9tICcuL3Byb2plY3QnO1xuXG5leHBvcnQgaW50ZXJmYWNlIExpY2Vuc2VPcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3BkeDogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjb3B5cmlnaHRPd25lcj86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNvcHlyaWdodFBlcmlvZD86IHN0cmluZztcbn1cblxuZXhwb3J0IGNsYXNzIExpY2Vuc2UgZXh0ZW5kcyBGaWxlQmFzZSB7XG4gIHByaXZhdGUgcmVhZG9ubHkgdGV4dDogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHByb2plY3Q6IFByb2plY3QsIG9wdGlvbnM6IExpY2Vuc2VPcHRpb25zKSB7XG4gICAgc3VwZXIocHJvamVjdCwgJ0xJQ0VOU0UnKTtcblxuICAgIGNvbnN0IHNwZHggPSBvcHRpb25zLnNwZHg7XG5cbiAgICBjb25zdCB0ZXh0RmlsZSA9IGAke19fZGlybmFtZX0vLi4vbGljZW5zZS10ZXh0LyR7c3BkeH0udHh0YDtcbiAgICBpZiAoIWZzLmV4aXN0c1N5bmModGV4dEZpbGUpKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYHVuc3VwcG9ydGVkIGxpY2Vuc2UgJHtzcGR4fWApO1xuICAgIH1cblxuICAgIGNvbnN0IHllYXJzID0gb3B0aW9ucy5jb3B5cmlnaHRQZXJpb2QgPz8gbmV3IERhdGUoKS5nZXRGdWxsWWVhcigpLnRvU3RyaW5nKCk7XG4gICAgY29uc3Qgb3duZXIgPSBvcHRpb25zLmNvcHlyaWdodE93bmVyO1xuXG4gICAgbGV0IHRleHQgPSBmcy5yZWFkRmlsZVN5bmModGV4dEZpbGUsICd1dGYtOCcpO1xuXG4gICAgdGV4dCA9IHRleHQucmVwbGFjZSgnJGNvcHlyaWdodF9wZXJpb2QnLCB5ZWFycyk7XG5cbiAgICAvLyBpZiB0aGUgbGljZW5zZSB0ZXh0IGluY2x1ZGVzICRjb3B5cmlnaHRfb3duZXIsIHRoZW4gYGNvcHlyaWdodE93bmVyYCBpcyByZXF1aXJlZC5cbiAgICBpZiAodGV4dC5pbmRleE9mKCckY29weXJpZ2h0X293bmVyJykgIT09IC0xKSB7XG4gICAgICBpZiAoIW93bmVyKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcihgVGhlICR7c3BkeH0gbGljZW5zZSByZXF1aXJlcyBcImNvcHlyaWdodE93bmVyXCIgdG8gYmUgc3BlY2lmaWVkYCk7XG4gICAgICB9XG5cbiAgICAgIHRleHQgPSB0ZXh0LnJlcGxhY2UoJyRjb3B5cmlnaHRfb3duZXInLCBvd25lcik7XG4gICAgfVxuXG4gICAgdGhpcy50ZXh0ID0gdGV4dDtcbiAgfVxuXG4gIHByb3RlY3RlZCBzeW50aGVzaXplQ29udGVudChfOiBJUmVzb2x2ZXIpOiBzdHJpbmcgfCB1bmRlZmluZWQge1xuICAgIHJldHVybiB0aGlzLnRleHQ7XG4gIH1cbn0iXX0=