"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bundler = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
const util_1 = require("./util");
/**
 * (experimental) Adds support for bundling JavaScript applications and dependencies into a single file.
 *
 * In the future, this will also supports bundling websites.
 *
 * @experimental
 */
class Bundler extends component_1.Component {
    /**
     * (experimental) Creates a `Bundler`.
     *
     * @experimental
     */
    constructor(project, options = {}) {
        var _b;
        super(project);
        this.esbuildVersion = options.esbuildVersion;
        this.bundledir = (_b = options.assetsDir) !== null && _b !== void 0 ? _b : 'assets';
    }
    /**
     * (experimental) Returns the `Bundler` instance associated with a project or `undefined` if there is no Bundler.
     *
     * @param project The project.
     * @returns A bundler
     * @experimental
     */
    static of(project) {
        const isBundler = (o) => o instanceof Bundler;
        return project.components.find(isBundler);
    }
    /**
     * (experimental) Gets or creates the singleton "bundle" task of the project.
     *
     * If the project doesn't have a "bundle" task, it will be created and spawned
     * during the pre-compile phase.
     *
     * @experimental
     */
    get bundleTask() {
        if (!this._task) {
            this.addBundlingSupport();
            this._task = this.project.tasks.addTask('bundle', {
                description: 'Prepare assets',
            });
            this.project.preCompileTask.spawn(this._task);
        }
        return this._task;
    }
    /**
     * (experimental) Adds a task to the project which bundles a specific entrypoint and all of its dependencies into a single javascript output file.
     *
     * @param entrypoint The relative path of the artifact within the project.
     * @param options Bundling options.
     * @experimental
     */
    addBundle(entrypoint, options) {
        var _b, _c, _d;
        const name = util_1.renderBundleName(entrypoint);
        const outfile = path_1.join(this.bundledir, name, 'index.js');
        const args = [
            'esbuild',
            '--bundle',
            entrypoint,
            `--target="${options.target}"`,
            `--platform="${options.platform}"`,
            `--outfile="${outfile}"`,
        ];
        for (const x of (_b = options.externals) !== null && _b !== void 0 ? _b : []) {
            args.push(`--external:${x}`);
        }
        const sourcemap = (_c = options.sourcemap) !== null && _c !== void 0 ? _c : false;
        if (sourcemap) {
            args.push('--sourcemap');
        }
        const bundleTask = this.project.addTask(`bundle:${name}`, {
            description: `Create a JavaScript bundle from ${entrypoint}`,
            exec: args.join(' '),
        });
        this.bundleTask.spawn(bundleTask);
        let watchTask;
        const watch = (_d = options.watchTask) !== null && _d !== void 0 ? _d : true;
        if (watch) {
            watchTask = this.project.addTask(`bundle:${name}:watch`, {
                description: `Continuously update the JavaScript bundle from ${entrypoint}`,
                exec: `${args.join(' ')} --watch`,
            });
        }
        return {
            bundleTask: bundleTask,
            watchTask: watchTask,
            outfile: outfile,
        };
    }
    /**
     * Add bundling support to a project. This is called implicitly when
     * `bundleTask` is referenced first. It adds the dependency on `esbuild`,
     * gitignore/npmignore, etc.
     */
    addBundlingSupport() {
        const ignoreEntry = `/${this.bundledir}/`;
        this.project.addGitIgnore(ignoreEntry);
        this.project.addPackageIgnore(`!${ignoreEntry}`); // include in tarball
        const dep = this.esbuildVersion ? `esbuild@${this.esbuildVersion}` : 'esbuild';
        this.project.deps.addDependency(dep, dependencies_1.DependencyType.BUILD);
    }
}
exports.Bundler = Bundler;
_a = JSII_RTTI_SYMBOL_1;
Bundler[_a] = { fqn: "projen.javascript.Bundler", version: "0.40.1" };
//# sourceMappingURL=data:application/json;base64,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