"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JavaProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const github_1 = require("../github");
const junit_1 = require("./junit");
const maven_compile_1 = require("./maven-compile");
const maven_packaging_1 = require("./maven-packaging");
const maven_sample_1 = require("./maven-sample");
const pom_1 = require("./pom");
const projenrc_1 = require("./projenrc");
/**
 * (experimental) Java project.
 *
 * @experimental
 * @pjid java
 */
class JavaProject extends github_1.GitHubProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h;
        super(options);
        this.distdir = (_b = options.distdir) !== null && _b !== void 0 ? _b : 'dist/java';
        this.pom = new pom_1.Pom(this, options);
        if ((_c = options.projenrcJava) !== null && _c !== void 0 ? _c : true) {
            this.projenrc = new projenrc_1.Projenrc(this, this.pom, options.projenrcJavaOptions);
        }
        const sampleJavaPackage = (_d = options.sampleJavaPackage) !== null && _d !== void 0 ? _d : 'org.acme';
        if ((_e = options.junit) !== null && _e !== void 0 ? _e : true) {
            this.junit = new junit_1.Junit(this, {
                pom: this.pom,
                sampleJavaPackage,
                ...options.junitOptions,
            });
        }
        if ((_f = options.sample) !== null && _f !== void 0 ? _f : true) {
            new maven_sample_1.MavenSample(this, { package: sampleJavaPackage });
        }
        // platform independent build
        this.pom.addProperty('project.build.sourceEncoding', 'UTF-8');
        this.gitignore.exclude('.classpath');
        this.gitignore.exclude('.project');
        this.gitignore.exclude('.settings');
        this.compile = new maven_compile_1.MavenCompile(this, this.pom, options.compileOptions);
        this.packaging = new maven_packaging_1.MavenPackaging(this, this.pom, options.packagingOptions);
        this.addPlugin('org.apache.maven.plugins/maven-enforcer-plugin@3.0.0-M3', {
            executions: [{ id: 'enforce-maven', goals: ['enforce'] }],
            configuration: {
                rules: [
                    { requireMavenVersion: [{ version: '3.6' }] },
                ],
            },
        });
        for (const dep of (_g = options.deps) !== null && _g !== void 0 ? _g : []) {
            this.addDependency(dep);
        }
        for (const dep of (_h = options.testDeps) !== null && _h !== void 0 ? _h : []) {
            this.addTestDependency(dep);
        }
    }
    /**
     * (experimental) Adds a runtime dependency.
     *
     * @param spec Format `<groupId>/<artifactId>@<semver>`.
     * @experimental
     */
    addDependency(spec) {
        return this.pom.addDependency(spec);
    }
    /**
     * (experimental) Adds a test dependency.
     *
     * @param spec Format `<groupId>/<artifactId>@<semver>`.
     * @experimental
     */
    addTestDependency(spec) {
        return this.pom.addTestDependency(spec);
    }
    /**
     * (experimental) Adds a build plugin to the pom.
     *
     * The plug in is also added as a BUILD dep to the project.
     *
     * @param spec dependency spec (`group/artifact@version`).
     * @param options plugin options.
     * @experimental
     */
    addPlugin(spec, options = {}) {
        return this.pom.addPlugin(spec, options);
    }
}
exports.JavaProject = JavaProject;
_a = JSII_RTTI_SYMBOL_1;
JavaProject[_a] = { fqn: "projen.java.JavaProject", version: "0.40.1" };
//# sourceMappingURL=data:application/json;base64,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