"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubWorkflow = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const case_1 = require("case");
const component_1 = require("../component");
const util_1 = require("../util");
const yaml_1 = require("../yaml");
/**
 * (experimental) Workflow for GitHub.
 *
 * A workflow is a configurable automated process made up of one or more jobs.
 *
 * @see https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions
 * @experimental
 */
class GithubWorkflow extends component_1.Component {
    /**
     * @experimental
     */
    constructor(github, name, options = {}) {
        super(github.project);
        this.events = {};
        this.jobs = {};
        this.name = name;
        this.concurrency = options.concurrency;
        const workflowsEnabled = github.workflowsEnabled || options.force;
        if (workflowsEnabled) {
            this.file = new yaml_1.YamlFile(this.project, `.github/workflows/${name.toLocaleLowerCase()}.yml`, {
                obj: () => this.renderWorkflow(),
            });
        }
    }
    /**
     * (experimental) Add events to triggers the workflow.
     *
     * @param events The event(s) to trigger the workflow.
     * @experimental
     */
    on(events) {
        this.events = {
            ...this.events,
            ...events,
        };
    }
    /**
     * (experimental) Add jobs to the workflow.
     *
     * @param jobs Jobs to add.
     * @experimental
     */
    addJobs(jobs) {
        // verify that job has a "permissions" statement to ensure workflow can
        // operate in repos with default tokens set to readonly
        for (const [id, job] of Object.entries(jobs)) {
            if (!job.permissions) {
                throw new Error(`${id}: all workflow jobs must have a "permissions" clause to ensure workflow can operate in restricted repositories`);
            }
        }
        // verify that job has a "runsOn" statement to ensure a worker can be selected appropriately
        for (const [id, job] of Object.entries(jobs)) {
            if (job.runsOn.length === 0) {
                throw new Error(`${id}: at least one runner selector labels must be provided in "runsOn" to ensure a runner instance can be selected`);
            }
        }
        this.jobs = {
            ...this.jobs,
            ...jobs,
        };
    }
    renderWorkflow() {
        return {
            name: this.name,
            on: snakeCaseKeys(this.events),
            concurrency: this.concurrency,
            jobs: renderJobs(this.jobs),
        };
    }
}
exports.GithubWorkflow = GithubWorkflow;
_a = JSII_RTTI_SYMBOL_1;
GithubWorkflow[_a] = { fqn: "projen.github.GithubWorkflow", version: "0.40.1" };
function snakeCaseKeys(obj) {
    if (typeof obj !== 'object' || obj == null) {
        return obj;
    }
    if (Array.isArray(obj)) {
        return obj.map(snakeCaseKeys);
    }
    const result = {};
    for (let [k, v] of Object.entries(obj)) {
        if (typeof v === 'object' && v != null) {
            v = snakeCaseKeys(v);
        }
        result[case_1.snake(k)] = v;
    }
    return result;
}
function renderJobs(jobs) {
    const result = {};
    for (const [name, job] of Object.entries(jobs)) {
        result[name] = renderJob(job);
    }
    return result;
    /** @see https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions */
    function renderJob(job) {
        return {
            'name': job.name,
            'needs': arrayOrScalar(job.needs),
            'runs-on': arrayOrScalar(job.runsOn),
            'permissions': util_1.kebabCaseKeys(job.permissions),
            'environment': job.environment,
            'concurrency': job.concurrency,
            'outputs': renderJobOutputs(job.outputs),
            'env': job.env,
            'defaults': util_1.kebabCaseKeys(job.defaults),
            'if': job.if,
            'steps': util_1.kebabCaseKeys(job.steps, false),
            'timeout-minutes': job.timeoutMinutes,
            'strategy': renderJobStrategy(job.strategy),
            'continue-on-error': job.continueOnError,
            'container': job.container,
            'services': job.services,
        };
    }
    function renderJobOutputs(output) {
        if (output == null) {
            return undefined;
        }
        const rendered = {};
        for (const [name, { stepId, outputName }] of Object.entries(output)) {
            rendered[name] = `\${{ steps.${stepId}.outputs.${outputName} }}`;
        }
        return rendered;
    }
    function renderJobStrategy(strategy) {
        var _b;
        if (strategy == null) {
            return undefined;
        }
        const rendered = {
            'max-parallel': strategy.maxParallel,
            'fail-fast': strategy.failFast,
        };
        if (strategy.matrix) {
            const matrix = {
                include: strategy.matrix.include,
                exclude: strategy.matrix.exclude,
            };
            for (const [key, values] of Object.entries((_b = strategy.matrix.domain) !== null && _b !== void 0 ? _b : {})) {
                if (key in matrix) {
                    // A domain key was set to `include`, or `exclude`:
                    throw new Error(`Illegal job strategy matrix key: ${key}`);
                }
                matrix[key] = values;
            }
            rendered.matrix = matrix;
        }
        return rendered;
    }
}
function arrayOrScalar(arr) {
    if (arr == null || arr.length === 0) {
        return arr;
    }
    if (arr.length === 1) {
        return arr[0];
    }
    return arr;
}
//# sourceMappingURL=data:application/json;base64,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