"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskWorkflow = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constants_1 = require("./constants");
const workflows_1 = require("./workflows");
const DEFAULT_JOB_ID = 'build';
/**
 * (experimental) A GitHub workflow for common build tasks within a project.
 *
 * @experimental
 */
class TaskWorkflow extends workflows_1.GithubWorkflow {
    /**
     * @experimental
     */
    constructor(github, options) {
        var _b, _c, _d, _e, _f, _g;
        super(github, options.name);
        this.jobId = (_b = options.jobId) !== null && _b !== void 0 ? _b : DEFAULT_JOB_ID;
        this.github = github;
        if (options.triggers) {
            if (options.triggers.issueComment) {
                // https://docs.github.com/en/actions/learn-github-actions/security-hardening-for-github-actions#potential-impact-of-a-compromised-runner
                throw new Error('Trigger "issueComment" should not be used due to a security concern');
            }
            this.on(options.triggers);
        }
        this.on({
            workflowDispatch: {},
        });
        const preCheckoutSteps = (_c = options.preCheckoutSteps) !== null && _c !== void 0 ? _c : [];
        const checkoutWith = options.checkoutWith ? { with: options.checkoutWith } : {};
        const preBuildSteps = (_d = options.preBuildSteps) !== null && _d !== void 0 ? _d : [];
        const postBuildSteps = (_e = options.postBuildSteps) !== null && _e !== void 0 ? _e : [];
        const gitIdentity = (_f = options.gitIdentity) !== null && _f !== void 0 ? _f : constants_1.DEFAULT_GITHUB_ACTIONS_USER;
        if (options.artifactsDirectory) {
            postBuildSteps.push({
                name: 'Upload artifact',
                uses: 'actions/upload-artifact@v2.1.1',
                // Setting to always will ensure that this step will run even if
                // the previous ones have failed (e.g. coverage report, internal logs, etc)
                if: 'always()',
                with: {
                    name: options.artifactsDirectory,
                    path: options.artifactsDirectory,
                },
            });
        }
        const job = {
            runsOn: (_g = options.runsOn) !== null && _g !== void 0 ? _g : ['ubuntu-latest'],
            container: options.container,
            env: options.env,
            permissions: options.permissions,
            if: options.condition,
            outputs: options.outputs,
            steps: [
                ...preCheckoutSteps,
                // check out sources.
                {
                    name: 'Checkout',
                    uses: 'actions/checkout@v2',
                    ...checkoutWith,
                },
                // sets git identity so we can push later
                constants_1.setGitIdentityStep(gitIdentity),
                ...preBuildSteps,
                // run the main build task
                {
                    name: options.task.name,
                    run: this.github.project.runTaskCommand(options.task),
                },
                ...postBuildSteps,
            ],
        };
        this.addJobs({ [this.jobId]: job });
    }
}
exports.TaskWorkflow = TaskWorkflow;
_a = JSII_RTTI_SYMBOL_1;
TaskWorkflow[_a] = { fqn: "projen.github.TaskWorkflow", version: "0.40.1" };
//# sourceMappingURL=data:application/json;base64,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