"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stale = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const stale_util_1 = require("./stale-util");
const workflows_model_1 = require("./workflows-model");
/**
 * (experimental) Warns and then closes issues and PRs that have had no activity for a specified amount of time.
 *
 * The default configuration will:
 *
 *   * Add a "Stale" label to pull requests after 14 days and closed after 2 days
 *   * Add a "Stale" label to issues after 60 days and closed after 7 days
 *   * If a comment is added, the label will be removed and timer is restarted.
 *
 * @see https://github.com/actions/stale
 * @experimental
 */
class Stale extends component_1.Component {
    /**
     * @experimental
     */
    constructor(github, options = {}) {
        var _b;
        super(github.project);
        const stale = github.addWorkflow('stale');
        stale.on({
            schedule: [{ cron: '0 1 * * *' }],
            workflowDispatch: {},
        });
        const pullRequests = stale_util_1.renderBehavior(options.pullRequest, { stale: 14, close: 2, type: 'pull request' });
        const issues = stale_util_1.renderBehavior(options.issues, { stale: 60, close: 7, type: 'issue' });
        stale.addJobs({
            stale: {
                runsOn: (_b = options.runsOn) !== null && _b !== void 0 ? _b : ['ubuntu-latest'],
                permissions: {
                    issues: workflows_model_1.JobPermission.WRITE,
                    pullRequests: workflows_model_1.JobPermission.WRITE,
                },
                steps: [
                    {
                        uses: 'actions/stale@v4',
                        with: {
                            // disable global
                            'days-before-stale': -1,
                            'days-before-close': -1,
                            // pull requests
                            'days-before-pr-stale': pullRequests.daysBeforeStale,
                            'days-before-pr-close': pullRequests.daysBeforeClose,
                            'stale-pr-message': pullRequests.staleMessage,
                            'close-pr-message': pullRequests.closeMessage,
                            'stale-pr-label': pullRequests.staleLabel,
                            // issues
                            'days-before-issue-stale': issues.daysBeforeStale,
                            'days-before-issue-close': issues.daysBeforeClose,
                            'stale-issue-message': issues.staleMessage,
                            'close-issue-message': issues.closeMessage,
                            'stale-issue-label': issues.staleLabel,
                        },
                    },
                ],
            },
        });
    }
}
exports.Stale = Stale;
_a = JSII_RTTI_SYMBOL_1;
Stale[_a] = { fqn: "projen.github.Stale", version: "0.40.1" };
//# sourceMappingURL=data:application/json;base64,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