"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const dependabot_1 = require("./dependabot");
const mergify_1 = require("./mergify");
const pr_template_1 = require("./pr-template");
const pull_request_lint_1 = require("./pull-request-lint");
const workflows_1 = require("./workflows");
/**
 * @experimental
 */
class GitHub extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b, _c, _d;
        super(project);
        this.workflowsEnabled = (_b = options.workflows) !== null && _b !== void 0 ? _b : true;
        if ((_c = options.mergify) !== null && _c !== void 0 ? _c : true) {
            this.mergify = new mergify_1.Mergify(this, options.mergifyOptions);
        }
        if ((_d = options.pullRequestLint) !== null && _d !== void 0 ? _d : true) {
            new pull_request_lint_1.PullRequestLint(this, options.pullRequestLintOptions);
        }
    }
    /**
     * (experimental) All workflows.
     *
     * @experimental
     */
    get workflows() {
        const isWorkflow = (c) => c instanceof workflows_1.GithubWorkflow;
        return this.project.components.filter(isWorkflow).sort((w1, w2) => w1.name.localeCompare(w2.name));
    }
    /**
     * (experimental) Adds a workflow to the project.
     *
     * @param name Name of the workflow.
     * @returns a GithubWorkflow instance
     * @experimental
     */
    addWorkflow(name) {
        const workflow = new workflows_1.GithubWorkflow(this, name);
        return workflow;
    }
    /**
     * @experimental
     */
    addPullRequestTemplate(...content) {
        return new pr_template_1.PullRequestTemplate(this, { lines: content });
    }
    /**
     * @experimental
     */
    addDependabot(options) {
        return new dependabot_1.Dependabot(this, options);
    }
    /**
     * (experimental) Finds a GitHub workflow by name.
     *
     * Returns `undefined` if the workflow cannot be found.
     *
     * @param name The name of the GitHub workflow.
     * @experimental
     */
    tryFindWorkflow(name) {
        return this.workflows.find(w => w.name === name);
    }
}
exports.GitHub = GitHub;
_a = JSII_RTTI_SYMBOL_1;
GitHub[_a] = { fqn: "projen.github.GitHub", version: "0.40.1" };
//# sourceMappingURL=data:application/json;base64,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