import { AutoApprove, AutoApproveOptions, AutoMergeOptions, GitHub, GitHubOptions, MergifyOptions, StaleOptions } from '.';
import { Gitpod } from '../gitpod';
import { Project, ProjectOptions, ProjectType } from '../project';
import { SampleReadmeProps } from '../readme';
import { DevContainer, VsCode } from '../vscode';
/**
 * (experimental) Options for `GitHubProject`.
 *
 * @experimental
 */
export interface GitHubProjectOptions extends ProjectOptions {
    /**
     * (experimental) Add a Gitpod development environment.
     *
     * @default false
     * @experimental
     */
    readonly gitpod?: boolean;
    /**
     * (experimental) Enable VSCode integration.
     *
     * Enabled by default for root projects. Disabled for non-root projects.
     *
     * @default true
     * @experimental
     */
    readonly vscode?: boolean;
    /**
     * (experimental) Enable GitHub integration.
     *
     * Enabled by default for root projects. Disabled for non-root projects.
     *
     * @default true
     * @experimental
     */
    readonly github?: boolean;
    /**
     * (experimental) Options for GitHub integration.
     *
     * @default - see GitHubOptions
     * @experimental
     */
    readonly githubOptions?: GitHubOptions;
    /**
     * (deprecated) Whether mergify should be enabled on this repository or not.
     *
     * @default true
     * @deprecated use `githubOptions.mergify` instead
     */
    readonly mergify?: boolean;
    /**
     * (deprecated) Options for mergify.
     *
     * @default - default options
     * @deprecated use `githubOptions.mergifyOptions` instead
     */
    readonly mergifyOptions?: MergifyOptions;
    /**
     * (experimental) Add a VSCode development environment (used for GitHub Codespaces).
     *
     * @default false
     * @experimental
     */
    readonly devContainer?: boolean;
    /**
     * (experimental) Add a `clobber` task which resets the repo to origin.
     *
     * @default true
     * @experimental
     */
    readonly clobber?: boolean;
    /**
     * (experimental) The README setup.
     *
     * @default - { filename: 'README.md', contents: '# replace this' }
     * @experimental
     * @example
     *
     * "{ filename: 'readme.md', contents: '# title' }"
     */
    readonly readme?: SampleReadmeProps;
    /**
     * (deprecated) Which type of project this is (library/app).
     *
     * @default ProjectType.UNKNOWN
     * @deprecated no longer supported at the base project level
     */
    readonly projectType?: ProjectType;
    /**
     * (experimental) Enable and configure the 'auto approve' workflow.
     *
     * @default - auto approve is disabled
     * @experimental
     */
    readonly autoApproveOptions?: AutoApproveOptions;
    /**
     * (experimental) Configure options for automatic merging on GitHub.
     *
     * Has no effect if
     * `github.mergify` is set to false.
     *
     * @default - see defaults in `AutoMergeOptions`
     * @experimental
     */
    readonly autoMergeOptions?: AutoMergeOptions;
    /**
     * (experimental) Auto-close stale issues and pull requests.
     *
     * To disable set `stale` to `false`.
     *
     * @default - see defaults in `StaleOptions`
     * @experimental
     */
    readonly staleOptions?: StaleOptions;
    /**
     * (experimental) Auto-close of stale issues and pull request.
     *
     * See `staleOptions` for options.
     *
     * @default true
     * @experimental
     */
    readonly stale?: boolean;
}
/**
 * (deprecated) GitHub-based project.
 *
 * @deprecated This is a *temporary* class. At the moment, our base project
 * types such as `NodeProject` and `JavaProject` are derived from this, but we
 * want to be able to use these project types outside of GitHub as well. One of
 * the next steps to address this is to abstract workflows so that different
 * "engines" can be used to implement our CI/CD solutions.
 */
export declare class GitHubProject extends Project {
    /**
     * (deprecated) Access all github components.
     *
     * This will be `undefined` for subprojects.
     *
     * @deprecated
     */
    readonly github: GitHub | undefined;
    /**
     * (deprecated) Access all VSCode components.
     *
     * This will be `undefined` for subprojects.
     *
     * @deprecated
     */
    readonly vscode: VsCode | undefined;
    /**
     * (deprecated) Access for Gitpod.
     *
     * This will be `undefined` if gitpod boolean is false
     *
     * @deprecated
     */
    readonly gitpod: Gitpod | undefined;
    /**
     * (deprecated) Access for .devcontainer.json (used for GitHub Codespaces).
     *
     * This will be `undefined` if devContainer boolean is false
     *
     * @deprecated
     */
    readonly devContainer: DevContainer | undefined;
    /**
     * @deprecated
     */
    readonly projectType: ProjectType;
    /**
     * (deprecated) Auto approve set up for this project.
     *
     * @deprecated
     */
    readonly autoApprove?: AutoApprove;
    /**
     * @deprecated
     */
    constructor(options: GitHubProjectOptions);
    /**
     * (deprecated) Marks the provided file(s) as being generated.
     *
     * This is achieved using the
     * github-linguist attributes. Generated files do not count against the
     * repository statistics and language breakdown.
     *
     * @param glob the glob pattern to match (could be a file path).
     * @see https://github.com/github/linguist/blob/master/docs/overrides.md
     * @deprecated
     */
    annotateGenerated(glob: string): void;
}
