"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dependabot = exports.VersioningStrategy = exports.DependabotScheduleInterval = exports.DependabotRegistryType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const util_1 = require("../util");
const yaml_1 = require("../yaml");
/**
 * (experimental) Each configuration type requires you to provide particular settings.
 *
 * Some types allow more than one way to connect
 *
 * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#configuration-options-for-private-registries
 * @experimental
 */
var DependabotRegistryType;
(function (DependabotRegistryType) {
    DependabotRegistryType["COMPOSER_REGISTRY"] = "composer-registry";
    DependabotRegistryType["DOCKER_REGISTRY"] = "docker-registry";
    DependabotRegistryType["GIT"] = "git";
    DependabotRegistryType["HEX_ORGANIZATION"] = "hex-organization";
    DependabotRegistryType["MAVEN_REPOSITORY"] = "maven-repository";
    DependabotRegistryType["NPM_REGISTRY"] = "npm-registry";
    DependabotRegistryType["NUGET_FEED"] = "nuget-feed";
    DependabotRegistryType["PYTHON_INDEX"] = "python-index";
    DependabotRegistryType["RUBYGEMS_SERVER"] = "rubygems-server";
    DependabotRegistryType["TERRAFORM_REGISTRY"] = "terraform-registry";
})(DependabotRegistryType = exports.DependabotRegistryType || (exports.DependabotRegistryType = {}));
/**
 * (experimental) How often to check for new versions and raise pull requests for version updates.
 *
 * @experimental
 */
var DependabotScheduleInterval;
(function (DependabotScheduleInterval) {
    DependabotScheduleInterval["DAILY"] = "daily";
    DependabotScheduleInterval["WEEKLY"] = "weekly";
    DependabotScheduleInterval["MONTHLY"] = "monthly";
})(DependabotScheduleInterval = exports.DependabotScheduleInterval || (exports.DependabotScheduleInterval = {}));
/**
 * (experimental) The strategy to use when edits manifest and lock files.
 *
 * @experimental
 */
var VersioningStrategy;
(function (VersioningStrategy) {
    VersioningStrategy["LOCKFILE_ONLY"] = "lockfile-only";
    VersioningStrategy["AUTO"] = "auto";
    VersioningStrategy["WIDEN"] = "widen";
    VersioningStrategy["INCREASE"] = "increase";
    VersioningStrategy["INCREASE_IF_NECESSARY"] = "increase-if-necessary";
})(VersioningStrategy = exports.VersioningStrategy || (exports.VersioningStrategy = {}));
/**
 * (experimental) Defines dependabot configuration for node projects.
 *
 * Since module versions are managed in projen, the versioning strategy will be
 * configured to "lockfile-only" which means that only updates that can be done
 * on the lockfile itself will be proposed.
 *
 * @experimental
 */
class Dependabot extends component_1.Component {
    /**
     * @experimental
     */
    constructor(github, options = {}) {
        var _b, _c, _d, _e;
        super(github.project);
        const project = github.project;
        this.ignore = [];
        this.ignoresProjen = (_b = options.ignoreProjen) !== null && _b !== void 0 ? _b : true;
        const registries = options.registries ? util_1.kebabCaseKeys(options.registries) : undefined;
        this.config = {
            version: 2,
            registries,
            updates: [
                {
                    'package-ecosystem': 'npm',
                    'versioning-strategy': 'lockfile-only',
                    'directory': '/',
                    'schedule': {
                        interval: (_c = options.scheduleInterval) !== null && _c !== void 0 ? _c : DependabotScheduleInterval.DAILY,
                    },
                    'ignore': () => this.ignore.length > 0 ? this.ignore : undefined,
                    'labels': options.labels ? options.labels : undefined,
                    'registries': registries ? Object.keys(registries) : undefined,
                },
            ],
        };
        new yaml_1.YamlFile(project, '.github/dependabot.yml', {
            obj: this.config,
            committed: true,
        });
        for (const i of (_d = options.ignore) !== null && _d !== void 0 ? _d : []) {
            this.addIgnore(i.dependencyName, ...((_e = i.versions) !== null && _e !== void 0 ? _e : []));
        }
        if (this.ignoresProjen) {
            this.addIgnore('projen');
        }
    }
    /**
     * (experimental) Ignores a dependency from automatic updates.
     *
     * @param dependencyName Use to ignore updates for dependencies with matching names, optionally using `*` to match zero or more characters.
     * @param versions Use to ignore specific versions or ranges of versions.
     * @experimental
     */
    addIgnore(dependencyName, ...versions) {
        this.ignore.push({
            'dependency-name': dependencyName,
            'versions': () => versions.length > 0 ? versions : undefined,
        });
    }
}
exports.Dependabot = Dependabot;
_a = JSII_RTTI_SYMBOL_1;
Dependabot[_a] = { fqn: "projen.github.Dependabot", version: "0.40.1" };
//# sourceMappingURL=data:application/json;base64,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