import { IResolver, FileBase } from './file';
import { Project } from './project';
/**
 * (experimental) Assign attributes to file names in a git repository.
 *
 * @see https://git-scm.com/docs/gitattributes
 * @experimental
 */
export declare class GitAttributesFile extends FileBase {
    private readonly attributes;
    /**
     * @experimental
     */
    constructor(project: Project);
    /**
     * (experimental) Maps a set of attributes to a set of files.
     *
     * @param glob Glob pattern to match files in the repo.
     * @param attributes Attributes to assign to these files.
     * @experimental
     */
    addAttributes(glob: string, ...attributes: string[]): void;
    /**
     * (experimental) Implemented by derived classes and returns the contents of the file to emit.
     *
     * @experimental
     */
    protected synthesizeContent(_: IResolver): string | undefined;
}
