import { Component } from './component';
import { Project } from './project';
/**
 * (experimental) The `Dependencies` component is responsible to track the list of dependencies a project has, and then used by project types as the model for rendering project-specific dependency manifests such as the dependencies section `package.json` files.
 *
 * To add a dependency you can use a project-type specific API such as
 * `nodeProject.addDeps()` or use the generic API of `project.deps`:
 *
 * @experimental
 */
export declare class Dependencies extends Component {
    /**
     * (experimental) The project-relative path of the deps manifest file.
     *
     * @experimental
     */
    static readonly MANIFEST_FILE: string;
    /**
     * (experimental) Returns the coordinates of a dependency spec.
     *
     * Given `foo@^3.4.0` returns `{ name: "foo", version: "^3.4.0" }`.
     * Given `bar@npm:@bar/legacy` returns `{ name: "bar", version: "npm:@bar/legacy" }`.
     *
     * @experimental
     */
    static parseDependency(spec: string): DependencyCoordinates;
    private readonly _deps;
    /**
     * (experimental) Adds a dependencies component to the project.
     *
     * @param project The parent project.
     * @experimental
     */
    constructor(project: Project);
    /**
     * (experimental) A copy of all dependencies recorded for this project.
     *
     * The list is sorted by type->name->version
     *
     * @experimental
     */
    get all(): Dependency[];
    /**
     * (experimental) Returns a dependency by name.
     *
     * Fails if there is no dependency defined by that name or if `type` is not
     * provided and there is more then one dependency type for this dependency.
     *
     * @param name The name of the dependency.
     * @param type The dependency type.
     * @returns a copy (cannot be modified)
     * @experimental
     */
    getDependency(name: string, type?: DependencyType): Dependency;
    /**
     * (experimental) Returns a dependency by name.
     *
     * Returns `undefined` if there is no dependency defined by that name or if
     * `type` is not provided and there is more then one dependency type for this
     * dependency.
     *
     * @param name The name of the dependency.
     * @param type The dependency type.
     * @returns a copy (cannot be modified) or undefined if there is no match
     * @experimental
     */
    tryGetDependency(name: string, type?: DependencyType): Dependency | undefined;
    /**
     * (experimental) Adds a dependency to this project.
     *
     * @param spec The dependency spec in the format `MODULE[@VERSION]` where `MODULE` is the package-manager-specific module name and `VERSION` is an optional semantic version requirement (e.g. `^3.4.0`).
     * @param type The type of the dependency.
     * @experimental
     */
    addDependency(spec: string, type: DependencyType, metadata?: {
        [key: string]: any;
    }): Dependency;
    /**
     * (experimental) Removes a dependency.
     *
     * @param name The name of the module to remove (without the version).
     * @param type The dependency type.
     * @experimental
     */
    removeDependency(name: string, type?: DependencyType): void;
    private tryGetDependencyIndex;
    private toJson;
}
/**
 * @experimental
 */
export interface DepsManifest {
    /**
     * (experimental) All dependencies of this module.
     *
     * @experimental
     */
    readonly dependencies: Dependency[];
}
/**
 * (experimental) Coordinates of the dependency (name and version).
 *
 * @experimental
 */
export interface DependencyCoordinates {
    /**
     * (experimental) The package manager name of the dependency (e.g. `leftpad` for npm).
     *
     * NOTE: For package managers that use complex coordinates (like Maven), we
     * will codify it into a string somehow.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) Semantic version version requirement.
     *
     * @default - requirement is managed by the package manager (e.g. npm/yarn).
     * @experimental
     */
    readonly version?: string;
}
/**
 * (experimental) Represents a project dependency.
 *
 * @experimental
 */
export interface Dependency extends DependencyCoordinates {
    /**
     * (experimental) Which type of dependency this is (runtime, build-time, etc).
     *
     * @experimental
     */
    readonly type: DependencyType;
    /**
     * (experimental) Additional JSON metadata associated with the dependency (package manager specific).
     *
     * @default {}
     * @experimental
     */
    readonly metadata?: {
        [key: string]: any;
    };
}
/**
 * (experimental) Type of dependency.
 *
 * @experimental
 */
export declare enum DependencyType {
    /**
     * (experimental) The dependency is required for the program/library during runtime.
     *
     * @experimental
     */
    RUNTIME = "runtime",
    /**
     * (experimental) The dependency is required at runtime but expected to be installed by the consumer.
     *
     * @experimental
     */
    PEER = "peer",
    /**
     * (experimental) The dependency is bundled and shipped with the module, so consumers are not required to install it.
     *
     * @experimental
     */
    BUNDLED = "bundled",
    /**
     * (experimental) The dependency is required to run the `build` task.
     *
     * @experimental
     */
    BUILD = "build",
    /**
     * (experimental) The dependency is required to run the `test` task.
     *
     * @experimental
     */
    TEST = "test",
    /**
     * (experimental) The dependency is required for development (e.g. IDE plugins).
     *
     * @experimental
     */
    DEVENV = "devenv"
}
