"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Clobber = void 0;
const component_1 = require("./component");
class Clobber extends component_1.Component {
    constructor(project) {
        super(project);
        const task = this.project.addTask('clobber', {
            description: 'hard resets to HEAD of origin and cleans the local repo',
            condition: 'git diff --exit-code > /dev/null',
            env: {
                BRANCH: '$(git branch --show-current)',
            },
        });
        task.exec('git checkout -b scratch', { name: 'save current HEAD in "scratch" branch' });
        task.exec('git checkout $BRANCH');
        task.exec('git fetch origin', { name: 'fetch latest changes from origin' });
        task.exec('git reset --hard origin/$BRANCH', { name: 'hard reset to origin commit' });
        task.exec('git clean -fdx', { name: 'clean all untracked files' });
        task.say('ready to rock! (unpushed commits are under the "scratch" branch)');
    }
}
exports.Clobber = Clobber;
//# sourceMappingURL=data:application/json;base64,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