"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cdk8sTypeScriptApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
const component_1 = require("../component");
const typescript_1 = require("../typescript");
/**
 * (experimental) CDK8s app in TypeScript.
 *
 * @experimental
 * @pjid cdk8s-app-ts
 */
class Cdk8sTypeScriptApp extends typescript_1.TypeScriptAppProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c;
        super({
            ...options,
            sampleCode: false,
        });
        if (!options.cdk8sVersion) {
            throw new Error('Required field cdk8sVersion is not specified.');
        }
        // encode a hidden assumption further down the chain
        if (this.srcdir !== 'src') {
            throw new Error('sources are expected under the "src" directory');
        }
        // encode a hidden assumption further down the chain
        if (this.testdir !== 'test') {
            throw new Error('test sources are expected under the "test" directory');
        }
        this.appEntrypoint = (_b = options.appEntrypoint) !== null && _b !== void 0 ? _b : 'main.ts';
        this.cdk8sVersion = options.cdk8sVersionPinning ? options.cdk8sVersion : `^${options.cdk8sVersion}`;
        if (options.constructsVersion) {
            this.constructsVersion = options.constructsVersionPinning ? options.constructsVersion : `^${options.constructsVersion}`;
        }
        else {
            this.constructsVersion = '^3.2.34';
        }
        if (!!options.cdk8sCliVersion) {
            this.cdk8sCliVersion = options.cdk8sCliVersionPinning ? options.cdk8sCliVersion : `^${options.cdk8sCliVersion}`;
        }
        else {
            this.cdk8sCliVersion = this.cdk8sVersion;
        }
        // CLI
        this.addDeps(`cdk8s@${this.cdk8sVersion}`, `constructs@${this.constructsVersion}`);
        this.addDevDeps('ts-node@^9', `cdk8s-cli@${this.cdk8sCliVersion}`, `cdk8s@${this.cdk8sVersion}`, `constructs@${this.constructsVersion}`);
        const synth = this.addTask('synth', {
            description: 'Synthesizes your cdk8s app into dist (part of "yarn build")',
            exec: 'cdk8s synth',
        });
        this.addTask('import', {
            description: 'Imports API objects to your app by generating constructs.',
            exec: 'cdk8s import',
        });
        this.gitignore.include('imports/');
        this.gitignore.include('cdk8s.yaml');
        // add synth to the build
        this.postCompileTask.spawn(synth);
        if ((_c = options.sampleCode) !== null && _c !== void 0 ? _c : true) {
            new SampleCode(this);
        }
    }
}
exports.Cdk8sTypeScriptApp = Cdk8sTypeScriptApp;
_a = JSII_RTTI_SYMBOL_1;
Cdk8sTypeScriptApp[_a] = { fqn: "projen.cdk8s.Cdk8sTypeScriptApp", version: "0.40.1" };
class SampleCode extends component_1.Component {
    constructor(project) {
        super(project);
        this.appProject = project;
    }
    synthesize() {
        const outdir = this.project.outdir;
        const srcdir = path.join(outdir, this.appProject.srcdir);
        if (fs.pathExistsSync(srcdir) && fs.readdirSync(srcdir).filter(x => x.endsWith('.ts'))) {
            return;
        }
        const srcCode = `import { Construct } from 'constructs';
import { App, Chart, ChartProps, ApiObject } from 'cdk8s';

export class MyChart extends Chart {
  constructor(scope: Construct, id: string, props: ChartProps = { }) {
    super(scope, id, props);

    const label = { app: 'hello-k8s' };



    new ApiObject(this, 'deployment', {
      apiVersion: "v1",
      kind: "Pod",
      metadata: {
          namespace: "frontend",
          name: "nginx",
          labels: label,
      },
      spec: {
          containers: [{
              name: "nginx",
              image: "nginx:1.14-alpine",
              resources: {
                  limits: {
                      memory: "20Mi",
                      cpu: 0.2,
                  },
              },
          }],
      },
    });
  }
}

const app = new App();
new MyChart(app, 'hello');
app.synth();`;
        fs.mkdirpSync(srcdir);
        fs.writeFileSync(path.join(srcdir, this.appProject.appEntrypoint), srcCode);
        const appEntrypointName = path.basename(this.appProject.appEntrypoint, '.ts');
        const cdk8sYaml = `language: typescript
app: node lib/${appEntrypointName}.js
imports:
  - k8s
    `;
        fs.writeFileSync(path.join(outdir, 'cdk8s.yaml'), cdk8sYaml);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2RrOHMtYXBwLXRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2NkazhzL2NkazhzLWFwcC10cy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLDZCQUE2QjtBQUM3QiwrQkFBK0I7QUFDL0IsNENBQXlDO0FBQ3pDLDhDQUErRTs7Ozs7OztBQWlDL0UsTUFBYSxrQkFBbUIsU0FBUSxpQ0FBb0I7Ozs7SUFlMUQsWUFBWSxPQUFrQzs7UUFDNUMsS0FBSyxDQUFDO1lBQ0osR0FBRyxPQUFPO1lBQ1YsVUFBVSxFQUFFLEtBQUs7U0FDbEIsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLE9BQU8sQ0FBQyxZQUFZLEVBQUU7WUFDekIsTUFBTSxJQUFJLEtBQUssQ0FBQywrQ0FBK0MsQ0FBQyxDQUFDO1NBQ2xFO1FBRUQsb0RBQW9EO1FBQ3BELElBQUksSUFBSSxDQUFDLE1BQU0sS0FBSyxLQUFLLEVBQUU7WUFDekIsTUFBTSxJQUFJLEtBQUssQ0FBQyxnREFBZ0QsQ0FBQyxDQUFDO1NBQ25FO1FBRUQsb0RBQW9EO1FBQ3BELElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxNQUFNLEVBQUU7WUFDM0IsTUFBTSxJQUFJLEtBQUssQ0FBQyxzREFBc0QsQ0FBQyxDQUFDO1NBQ3pFO1FBRUQsSUFBSSxDQUFDLGFBQWEsU0FBRyxPQUFPLENBQUMsYUFBYSxtQ0FBSSxTQUFTLENBQUM7UUFFeEQsSUFBSSxDQUFDLFlBQVksR0FBRyxPQUFPLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLElBQUksT0FBTyxDQUFDLFlBQVksRUFBRSxDQUFDO1FBRXBHLElBQUksT0FBTyxDQUFDLGlCQUFpQixFQUFFO1lBQzdCLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxPQUFPLENBQUMsd0JBQXdCLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQSxDQUFDLENBQUMsSUFBSSxPQUFPLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztTQUN4SDthQUFNO1lBQ0wsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFNBQVMsQ0FBQztTQUNwQztRQUVELElBQUksQ0FBQyxDQUFFLE9BQU8sQ0FBQyxlQUFlLEVBQUU7WUFDOUIsSUFBSSxDQUFDLGVBQWUsR0FBRyxPQUFPLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxlQUFlLENBQUEsQ0FBQyxDQUFDLElBQUksT0FBTyxDQUFDLGVBQWUsRUFBRSxDQUFDO1NBQ2hIO2FBQU07WUFDTCxJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUM7U0FDMUM7UUFHRCxNQUFNO1FBQ04sSUFBSSxDQUFDLE9BQU8sQ0FDVixTQUFTLElBQUksQ0FBQyxZQUFZLEVBQUUsRUFDNUIsY0FBYyxJQUFJLENBQUMsaUJBQWlCLEVBQUUsQ0FDdkMsQ0FBQztRQUNGLElBQUksQ0FBQyxVQUFVLENBQ2IsWUFBWSxFQUNaLGFBQWEsSUFBSSxDQUFDLGVBQWUsRUFBRSxFQUNuQyxTQUFTLElBQUksQ0FBQyxZQUFZLEVBQUUsRUFDNUIsY0FBYyxJQUFJLENBQUMsaUJBQWlCLEVBQUUsQ0FDdkMsQ0FBQztRQUVGLE1BQU0sS0FBSyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxFQUFFO1lBQ2xDLFdBQVcsRUFBRSw2REFBNkQ7WUFDMUUsSUFBSSxFQUFFLGFBQWE7U0FDcEIsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUU7WUFDckIsV0FBVyxFQUFFLDJEQUEyRDtZQUN4RSxJQUFJLEVBQUUsY0FBYztTQUNyQixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNuQyxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsQ0FBQztRQUVyQyx5QkFBeUI7UUFDekIsSUFBSSxDQUFDLGVBQWUsQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFbEMsVUFBSSxPQUFPLENBQUMsVUFBVSxtQ0FBSSxJQUFJLEVBQUU7WUFDOUIsSUFBSSxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUM7U0FDdEI7SUFDSCxDQUFDOztBQW5GSCxnREFxRkM7OztBQUVELE1BQU0sVUFBVyxTQUFRLHFCQUFTO0lBRWhDLFlBQVksT0FBMkI7UUFDckMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ2YsSUFBSSxDQUFDLFVBQVUsR0FBRyxPQUFPLENBQUM7SUFDNUIsQ0FBQztJQUVNLFVBQVU7UUFDZixNQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQztRQUNuQyxNQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ3pELElBQUksRUFBRSxDQUFDLGNBQWMsQ0FBQyxNQUFNLENBQUMsSUFBSSxFQUFFLENBQUMsV0FBVyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRTtZQUN0RixPQUFPO1NBQ1I7UUFFRCxNQUFNLE9BQU8sR0FBRzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OzthQXFDUCxDQUFDO1FBRVYsRUFBRSxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUN0QixFQUFFLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLEVBQUUsT0FBTyxDQUFDLENBQUM7UUFFNUUsTUFBTSxpQkFBaUIsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsYUFBYSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRTlFLE1BQU0sU0FBUyxHQUFHO2dCQUNOLGlCQUFpQjs7O0tBRzVCLENBQUM7UUFFRixFQUFFLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLFlBQVksQ0FBQyxFQUFFLFNBQVMsQ0FBQyxDQUFDO0lBRS9ELENBQUM7Q0FDRiIsInNvdXJjZXNDb250ZW50IjpbIlxuaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCAqIGFzIGZzIGZyb20gJ2ZzLWV4dHJhJztcbmltcG9ydCB7IENvbXBvbmVudCB9IGZyb20gJy4uL2NvbXBvbmVudCc7XG5pbXBvcnQgeyBUeXBlU2NyaXB0QXBwUHJvamVjdCwgVHlwZVNjcmlwdFByb2plY3RPcHRpb25zIH0gZnJvbSAnLi4vdHlwZXNjcmlwdCc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQ2RrOHNUeXBlU2NyaXB0QXBwT3B0aW9ucyBleHRlbmRzIFR5cGVTY3JpcHRQcm9qZWN0T3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNkazhzVmVyc2lvbjogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuXG4gIHJlYWRvbmx5IGNvbnN0cnVjdHNWZXJzaW9uPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuXG4gIHJlYWRvbmx5IGNkazhzQ2xpVmVyc2lvbj86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY2RrOHNWZXJzaW9uUGlubmluZz86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjZGs4c0NsaVZlcnNpb25QaW5uaW5nPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjZGs4c1BsdXNWZXJzaW9uUGlubmluZz86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNvbnN0cnVjdHNWZXJzaW9uUGlubmluZz86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGFwcEVudHJ5cG9pbnQ/OiBzdHJpbmc7XG5cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcblxuZXhwb3J0IGNsYXNzIENkazhzVHlwZVNjcmlwdEFwcCBleHRlbmRzIFR5cGVTY3JpcHRBcHBQcm9qZWN0IHtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGNkazhzVmVyc2lvbjogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBjb25zdHJ1Y3RzVmVyc2lvbjogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcblxuICBwdWJsaWMgcmVhZG9ubHkgY2RrOHNDbGlWZXJzaW9uOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBhcHBFbnRyeXBvaW50OiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Iob3B0aW9uczogQ2RrOHNUeXBlU2NyaXB0QXBwT3B0aW9ucykge1xuICAgIHN1cGVyKHtcbiAgICAgIC4uLm9wdGlvbnMsXG4gICAgICBzYW1wbGVDb2RlOiBmYWxzZSxcbiAgICB9KTtcblxuICAgIGlmICghb3B0aW9ucy5jZGs4c1ZlcnNpb24pIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignUmVxdWlyZWQgZmllbGQgY2RrOHNWZXJzaW9uIGlzIG5vdCBzcGVjaWZpZWQuJyk7XG4gICAgfVxuXG4gICAgLy8gZW5jb2RlIGEgaGlkZGVuIGFzc3VtcHRpb24gZnVydGhlciBkb3duIHRoZSBjaGFpblxuICAgIGlmICh0aGlzLnNyY2RpciAhPT0gJ3NyYycpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignc291cmNlcyBhcmUgZXhwZWN0ZWQgdW5kZXIgdGhlIFwic3JjXCIgZGlyZWN0b3J5Jyk7XG4gICAgfVxuXG4gICAgLy8gZW5jb2RlIGEgaGlkZGVuIGFzc3VtcHRpb24gZnVydGhlciBkb3duIHRoZSBjaGFpblxuICAgIGlmICh0aGlzLnRlc3RkaXIgIT09ICd0ZXN0Jykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCd0ZXN0IHNvdXJjZXMgYXJlIGV4cGVjdGVkIHVuZGVyIHRoZSBcInRlc3RcIiBkaXJlY3RvcnknKTtcbiAgICB9XG5cbiAgICB0aGlzLmFwcEVudHJ5cG9pbnQgPSBvcHRpb25zLmFwcEVudHJ5cG9pbnQgPz8gJ21haW4udHMnO1xuXG4gICAgdGhpcy5jZGs4c1ZlcnNpb24gPSBvcHRpb25zLmNkazhzVmVyc2lvblBpbm5pbmcgPyBvcHRpb25zLmNkazhzVmVyc2lvbiA6IGBeJHtvcHRpb25zLmNkazhzVmVyc2lvbn1gO1xuXG4gICAgaWYgKG9wdGlvbnMuY29uc3RydWN0c1ZlcnNpb24pIHtcbiAgICAgIHRoaXMuY29uc3RydWN0c1ZlcnNpb24gPSBvcHRpb25zLmNvbnN0cnVjdHNWZXJzaW9uUGlubmluZyA/IG9wdGlvbnMuY29uc3RydWN0c1ZlcnNpb246IGBeJHtvcHRpb25zLmNvbnN0cnVjdHNWZXJzaW9ufWA7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMuY29uc3RydWN0c1ZlcnNpb24gPSAnXjMuMi4zNCc7XG4gICAgfVxuXG4gICAgaWYgKCEhIG9wdGlvbnMuY2RrOHNDbGlWZXJzaW9uKSB7XG4gICAgICB0aGlzLmNkazhzQ2xpVmVyc2lvbiA9IG9wdGlvbnMuY2RrOHNDbGlWZXJzaW9uUGlubmluZyA/IG9wdGlvbnMuY2RrOHNDbGlWZXJzaW9uOiBgXiR7b3B0aW9ucy5jZGs4c0NsaVZlcnNpb259YDtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5jZGs4c0NsaVZlcnNpb24gPSB0aGlzLmNkazhzVmVyc2lvbjtcbiAgICB9XG5cblxuICAgIC8vIENMSVxuICAgIHRoaXMuYWRkRGVwcyhcbiAgICAgIGBjZGs4c0Ake3RoaXMuY2RrOHNWZXJzaW9ufWAsXG4gICAgICBgY29uc3RydWN0c0Ake3RoaXMuY29uc3RydWN0c1ZlcnNpb259YCxcbiAgICApO1xuICAgIHRoaXMuYWRkRGV2RGVwcyhcbiAgICAgICd0cy1ub2RlQF45JyxcbiAgICAgIGBjZGs4cy1jbGlAJHt0aGlzLmNkazhzQ2xpVmVyc2lvbn1gLFxuICAgICAgYGNkazhzQCR7dGhpcy5jZGs4c1ZlcnNpb259YCxcbiAgICAgIGBjb25zdHJ1Y3RzQCR7dGhpcy5jb25zdHJ1Y3RzVmVyc2lvbn1gLFxuICAgICk7XG5cbiAgICBjb25zdCBzeW50aCA9IHRoaXMuYWRkVGFzaygnc3ludGgnLCB7XG4gICAgICBkZXNjcmlwdGlvbjogJ1N5bnRoZXNpemVzIHlvdXIgY2RrOHMgYXBwIGludG8gZGlzdCAocGFydCBvZiBcInlhcm4gYnVpbGRcIiknLFxuICAgICAgZXhlYzogJ2NkazhzIHN5bnRoJyxcbiAgICB9KTtcblxuICAgIHRoaXMuYWRkVGFzaygnaW1wb3J0Jywge1xuICAgICAgZGVzY3JpcHRpb246ICdJbXBvcnRzIEFQSSBvYmplY3RzIHRvIHlvdXIgYXBwIGJ5IGdlbmVyYXRpbmcgY29uc3RydWN0cy4nLFxuICAgICAgZXhlYzogJ2NkazhzIGltcG9ydCcsXG4gICAgfSk7XG5cbiAgICB0aGlzLmdpdGlnbm9yZS5pbmNsdWRlKCdpbXBvcnRzLycpO1xuICAgIHRoaXMuZ2l0aWdub3JlLmluY2x1ZGUoJ2NkazhzLnlhbWwnKTtcblxuICAgIC8vIGFkZCBzeW50aCB0byB0aGUgYnVpbGRcbiAgICB0aGlzLnBvc3RDb21waWxlVGFzay5zcGF3bihzeW50aCk7XG5cbiAgICBpZiAob3B0aW9ucy5zYW1wbGVDb2RlID8/IHRydWUpIHtcbiAgICAgIG5ldyBTYW1wbGVDb2RlKHRoaXMpO1xuICAgIH1cbiAgfVxuXG59XG5cbmNsYXNzIFNhbXBsZUNvZGUgZXh0ZW5kcyBDb21wb25lbnQge1xuICBwcml2YXRlIHJlYWRvbmx5IGFwcFByb2plY3Q6IENkazhzVHlwZVNjcmlwdEFwcDtcbiAgY29uc3RydWN0b3IocHJvamVjdDogQ2RrOHNUeXBlU2NyaXB0QXBwKSB7XG4gICAgc3VwZXIocHJvamVjdCk7XG4gICAgdGhpcy5hcHBQcm9qZWN0ID0gcHJvamVjdDtcbiAgfVxuXG4gIHB1YmxpYyBzeW50aGVzaXplKCkge1xuICAgIGNvbnN0IG91dGRpciA9IHRoaXMucHJvamVjdC5vdXRkaXI7XG4gICAgY29uc3Qgc3JjZGlyID0gcGF0aC5qb2luKG91dGRpciwgdGhpcy5hcHBQcm9qZWN0LnNyY2Rpcik7XG4gICAgaWYgKGZzLnBhdGhFeGlzdHNTeW5jKHNyY2RpcikgJiYgZnMucmVhZGRpclN5bmMoc3JjZGlyKS5maWx0ZXIoeCA9PiB4LmVuZHNXaXRoKCcudHMnKSkpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICBjb25zdCBzcmNDb2RlID0gYGltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQXBwLCBDaGFydCwgQ2hhcnRQcm9wcywgQXBpT2JqZWN0IH0gZnJvbSAnY2RrOHMnO1xuXG5leHBvcnQgY2xhc3MgTXlDaGFydCBleHRlbmRzIENoYXJ0IHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENoYXJ0UHJvcHMgPSB7IH0pIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcblxuICAgIGNvbnN0IGxhYmVsID0geyBhcHA6ICdoZWxsby1rOHMnIH07XG5cblxuXG4gICAgbmV3IEFwaU9iamVjdCh0aGlzLCAnZGVwbG95bWVudCcsIHtcbiAgICAgIGFwaVZlcnNpb246IFwidjFcIixcbiAgICAgIGtpbmQ6IFwiUG9kXCIsXG4gICAgICBtZXRhZGF0YToge1xuICAgICAgICAgIG5hbWVzcGFjZTogXCJmcm9udGVuZFwiLFxuICAgICAgICAgIG5hbWU6IFwibmdpbnhcIixcbiAgICAgICAgICBsYWJlbHM6IGxhYmVsLFxuICAgICAgfSxcbiAgICAgIHNwZWM6IHtcbiAgICAgICAgICBjb250YWluZXJzOiBbe1xuICAgICAgICAgICAgICBuYW1lOiBcIm5naW54XCIsXG4gICAgICAgICAgICAgIGltYWdlOiBcIm5naW54OjEuMTQtYWxwaW5lXCIsXG4gICAgICAgICAgICAgIHJlc291cmNlczoge1xuICAgICAgICAgICAgICAgICAgbGltaXRzOiB7XG4gICAgICAgICAgICAgICAgICAgICAgbWVtb3J5OiBcIjIwTWlcIixcbiAgICAgICAgICAgICAgICAgICAgICBjcHU6IDAuMixcbiAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgfV0sXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG59XG5cbmNvbnN0IGFwcCA9IG5ldyBBcHAoKTtcbm5ldyBNeUNoYXJ0KGFwcCwgJ2hlbGxvJyk7XG5hcHAuc3ludGgoKTtgO1xuXG4gICAgZnMubWtkaXJwU3luYyhzcmNkaXIpO1xuICAgIGZzLndyaXRlRmlsZVN5bmMocGF0aC5qb2luKHNyY2RpciwgdGhpcy5hcHBQcm9qZWN0LmFwcEVudHJ5cG9pbnQpLCBzcmNDb2RlKTtcblxuICAgIGNvbnN0IGFwcEVudHJ5cG9pbnROYW1lID0gcGF0aC5iYXNlbmFtZSh0aGlzLmFwcFByb2plY3QuYXBwRW50cnlwb2ludCwgJy50cycpO1xuXG4gICAgY29uc3QgY2RrOHNZYW1sID0gYGxhbmd1YWdlOiB0eXBlc2NyaXB0XG5hcHA6IG5vZGUgbGliLyR7YXBwRW50cnlwb2ludE5hbWV9LmpzXG5pbXBvcnRzOlxuICAtIGs4c1xuICAgIGA7XG5cbiAgICBmcy53cml0ZUZpbGVTeW5jKHBhdGguam9pbihvdXRkaXIsICdjZGs4cy55YW1sJyksIGNkazhzWWFtbCk7XG5cbiAgfVxufSJdfQ==