"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CdkTasks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
/**
 * (experimental) Adds standard AWS CDK tasks to your project.
 *
 * @experimental
 */
class CdkTasks extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project) {
        super(project);
        this.synth = project.addTask('synth', {
            description: 'Synthesizes your cdk app into cdk.out (part of "yarn build")',
            exec: 'cdk synth',
        });
        this.deploy = project.addTask('deploy', {
            description: 'Deploys your CDK app to the AWS cloud',
            exec: 'cdk deploy',
        });
        this.destroy = project.addTask('destroy', {
            description: 'Destroys your cdk app in the AWS cloud',
            exec: 'cdk destroy',
        });
        this.diff = project.addTask('diff', {
            description: 'Diffs the currently deployed app against your code',
            exec: 'cdk diff',
        });
    }
}
exports.CdkTasks = CdkTasks;
_a = JSII_RTTI_SYMBOL_1;
CdkTasks[_a] = { fqn: "projen.awscdk.CdkTasks", version: "0.40.1" };
//# sourceMappingURL=data:application/json;base64,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