import { ConstructLibrary, ConstructLibraryOptions } from '../cdk';
import { LambdaFunctionCommonOptions } from './lambda-function';
/**
 * (experimental) Options for the construct-lib-aws project.
 *
 * @experimental
 */
export interface AwsCdkConstructLibraryOptions extends ConstructLibraryOptions {
    /**
     * (experimental) Minimum target version this library is tested against.
     *
     * @default "2.0.0"
     * @experimental
     * @featured true
     */
    readonly cdkVersion: string;
    /**
     * (experimental) Minimum target version of constructs being tested against. If not provided, the default value depends on the configured `cdkVersion`:.
     *
     * - For CDK 1.x, the default is "3.2.27"
     * - For CDK 2.x, the default is "10.0.5"
     * - Otherwise, the default is "*"
     *
     * @default - When the default behavior is used, the dependency on `constructs` will
     * be added as both a `peerDependency` and a `devDependency`.
     * @experimental
     */
    readonly constructsVersion?: string;
    /**
     * (experimental) Use pinned version instead of caret version for CDK.
     *
     * You can use this to prevent yarn to mix versions for your CDK dependencies and to prevent auto-updates.
     * If you use experimental features this will let you define the moment you include breaking changes.
     *
     * @default false
     * @experimental
     */
    readonly cdkVersionPinning?: boolean;
    /**
     * (deprecated) Which AWS CDK modules (those that start with "@aws-cdk/") does this library require when consumed?
     *
     * @deprecated - For CDK 2.x use 'peerDeps' instead
     */
    readonly cdkDependencies?: string[];
    /**
     * (deprecated) If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`).
     *
     * This is to ensure that downstream consumers actually have your CDK dependencies installed
     * when using npm < 7 or yarn, where peer dependencies are not automatically installed.
     * If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
     * they are present during development.
     *
     * @default true
     * @deprecated - Not used for CDK 2.x
     */
    readonly cdkDependenciesAsDeps?: boolean;
    /**
     * (deprecated) Install the @aws-cdk/assert library?
     *
     * @default false
     * @deprecated - use cdkAssertions instead
     */
    readonly cdkAssert?: boolean;
    /**
     * (experimental) Install the @aws-cdk/assertions library?
     *
     * Only needed for CDK 1.x. If using CDK 2.x then
     * assertions is already included in 'aws-cdk-lib'
     *
     * @default true
     * @experimental
     */
    readonly cdkAssertions?: boolean;
    /**
     * (deprecated) AWS CDK modules required for testing.
     *
     * @deprecated - For CDK 2.x use 'devDeps' instead
     * @featured true
     */
    readonly cdkTestDependencies?: string[];
    /**
     * (experimental) Automatically adds an `aws_lambda.Function` for each `.lambda.ts` handler in your source tree. If this is disabled, you either need to explicitly call `aws_lambda.Function.autoDiscover()` or define a `new aws_lambda.Function()` for each handler.
     *
     * @default true
     * @experimental
     */
    readonly lambdaAutoDiscover?: boolean;
    /**
     * (experimental) Common options for all AWS Lambda functions.
     *
     * @default - default options
     * @experimental
     */
    readonly lambdaOptions?: LambdaFunctionCommonOptions;
}
/**
 * (experimental) AWS CDK construct library project.
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the AWS CDK with a friendly workflow and automatic publishing to
 * the construct catalog.
 *
 * @experimental
 * @pjid awscdk-construct
 */
export declare class AwsCdkConstructLibrary extends ConstructLibrary {
    /**
     * (experimental) The target CDK version for this library.
     *
     * @experimental
     */
    readonly cdkVersion: string;
    /**
     * (experimental) Whether CDK dependencies are added as normal dependencies (and peer dependencies).
     *
     * @experimental
     */
    readonly cdkDependenciesAsDeps: boolean;
    /**
     * @experimental
     */
    constructor(options: AwsCdkConstructLibraryOptions);
    /**
     * @deprecated use `cdkVersion`
     */
    get version(): string;
    /**
     * (experimental) Adds CDK modules as runtime dependencies.
     *
     * Modules are currently by default added with a caret CDK version both as "dependencies"
     * and "peerDependencies". This is because currently npm would not
     * automatically install peer dependencies that are not declared as concerete
     * dependencies by the consumer, so this is a little npm "hack" so that
     * consumers will not need to depend on them directly if they don't interact
     * with them.
     * See `cdkDependenciesAsDeps` for changing the default behavior.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @experimental
     */
    addCdkDependencies(...deps: string[]): void;
    /**
     * (experimental) Adds CDK modules as test dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @experimental
     */
    addCdkTestDependencies(...deps: string[]): void;
    private formatModuleSpec;
}
/**
 * @deprecated use `AwsCdkConstructLibraryOptions`
 */
export interface ConstructLibraryAwsOptions extends AwsCdkConstructLibraryOptions {
}
/**
 * @deprecated use `AwsCdkConstructLibrary`
 */
export declare class ConstructLibraryAws extends AwsCdkConstructLibrary {
}
