"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoDiscover = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const glob = require("glob");
const _1 = require(".");
const component_1 = require("../component");
const internal_1 = require("./internal");
const lambda_function_1 = require("./lambda-function");
/**
 * (experimental) Automatically creates a `LambdaFunction` for all `.lambda.ts` files under the source directory of the project.
 *
 * @experimental
 */
class AutoDiscover extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        super(project);
        this.autoDiscoverLambdaFunctions(options);
        this.autoDiscoverIntegrationTests(options);
    }
    autoDiscoverLambdaFunctions(options) {
        const entrypoints = glob.sync(`**/*${internal_1.TYPESCRIPT_LAMBDA_EXT}`, {
            cwd: path_1.join(this.project.outdir, options.srcdir),
        });
        for (const entrypoint of entrypoints) {
            new lambda_function_1.LambdaFunction(this.project, {
                entrypoint: path_1.join(options.srcdir, entrypoint),
                ...options.lambdaOptions,
            });
        }
    }
    autoDiscoverIntegrationTests(options) {
        const entrypoints = glob.sync(`**/*${internal_1.TYPESCRIPT_INTEG_EXT}`, {
            cwd: path_1.join(this.project.outdir, options.testdir),
        });
        for (const entrypoint of entrypoints) {
            new _1.IntegrationTest(this.project, {
                entrypoint: path_1.join(options.testdir, entrypoint),
                tsconfigPath: options.tsconfigPath,
            });
        }
    }
}
exports.AutoDiscover = AutoDiscover;
_a = JSII_RTTI_SYMBOL_1;
AutoDiscover[_a] = { fqn: "projen.awscdk.AutoDiscover", version: "0.40.1" };
//# sourceMappingURL=data:application/json;base64,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