# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['needly']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=9.0.1,<10.0.0']

entry_points = \
{'console_scripts': ['needly = needly.needly:main']}

setup_kwargs = {
    'name': 'needly',
    'version': '2.5.5',
    'description': 'Python Needle Editor for openQA',
    'long_description': '# Needly (Version 2.5)\n\n*Needly* is an openQA needle editor written in Python. It creates or modifies needles for the openQA tests. \n\nThe openQA needle consists of two files, a *png* screenshot and the *json* definition file. The definition file provides various information to the openQA engine, including the *tags*, *types*, and *areas* to look for. Users can use this application to edit (or create) all the necessary information quickly and draw the areas using the built-in WYSIWYG editor. When the needle is saved, it is fully compatible with the openQA engine. \n\nThe advantage of the editor is that it does not need openQA to be installed on the system. The needle files are all you need to work with them.\n\nThe editor only supports *png* screenshots. To open the needle, you can either load that *png* file or the *json* definition file. Both ways will open the needle in the editor. \n\n## Requirements to run the application\n\n* Python 3\n* Tkinter\n* the Pillow library\n\n## Recommended requirements to have better user experience\n\n* Libvirt (to run VMs that can be controllable with `virsh`)\n* ImageMagick (to work with screenshots) \n\n## Using the editor\n\n### Starting the editor\n\nCurrently, you can run the editor from the console.\n\n* Running `./needly.py` starts the editor without any image loaded. You can open an image using the **Ctrl-O** combination. Or you can load the entire directory into a front using **Ctrl-D**. \n* Running `./needly.py needle.png` starts the editor with that particular image loaded which can be useful to edit an existing needle quickly.\n\n### Reading the images\n\n#### Editing multiple files in a directory\n\nYou can open an entire directory and navigate through images one after another and edit their needles. To use this approach:\n\n1. Click **File > Open directory** or use **Ctrl-D**.\n2. Use the dialogue to select a directory from which the screenshots will be loaded.\n3. Circle over the images using **Load next** (**Ctrl-N**) or **Load previous** (**Ctrl-P**) from the **File** menu.\n\n#### Editing a single file\n\nYou can also open a particular file and edit its needle. To use this approach:\n\n1. Click the **File > Open file** or use the **Ctrl-O** key.\n2. Use the dialogue to locate the file you want to edit.\n\n### Working with needles\n\n#### Loading the needle information\n\nIn the current version, when you have loaded a picture, the definition file is not loaded automatically so that you can recreate the needle from scratch which is useful when reneedling test suites where bigger changes are to expected. However, if you would rather want to edit the current definiton file, you need to load it using **Needle > Load** (**Ctrl-L**).  \n\nYou can reload the needle again anytime and restore all the original information until you save the definition file.\n\n#### Reading the needle information.\n\nWhen the needle is loaded, you can see all needle information in the right part of the program window.\nAmong others:\n\n* the name of the active image\n* needle properties\n* needle tags\n* active area coordinates\n* number of areas in the needle\n* the content of the needle json file\n\n#### Updating the needle information\n\nYou can manually update the following fields:\n\n* the coordinates\n* the properties\n* the tags\n* the area type\n\n#### Redrawing the area\n\nThe needle area can be updated using several techniqes:\n\n1. You can use the mouse to draw a new needle area. \n2. You can manually update the coordinates in the coordinate fields on the right.\n3. You can use keys to change the size of the area. \n\nWhen using the keyboard:\n\n* Using **Left**, **Right**, **Up**, and **Down** arrows changes the coordinates of the lower right corner in steps of 1 px each.\n* Using the **Shift** key combined with arrows changes the coordinates of the upper left corner in steps of 1 px each.\n* Holding the **Ctrl** key when pressing arrows increases one step to 5 pxs.\n* Holding the **Alt** key when pressing arrows increases one step to 25 pxs.\n\n**Note**: When you have updated the area, you have to click **Area > Modify area** (**Ctrl-M**) \nto update the actual needle. \n\n#### Saving a needle\n\nIf you want to store the needle information permanently, you have to save it. To do so:\n\n1. Click on the **Needle > Save**, or use the **Ctrl-S** shortcut to save the needle.\n\nWhen saving, the editor overwrites the definiton file and the original needle cannot be restored.\n\n#### Creating a new needle from scratch\n\nWhen you create a needle can do it for an existing image or you can take a screenshot from a connected virtual machine (see later). To create a new needle for an existing image:\n\n1. Open the existing image.\n2. Fill in all needed info:\n   * needle tag\n   * needle area\n   * needle type (match, ocr, or exclude)\n   * needle properties (not compulsory)\n3. Draw a rectangle around the area or use any of the approaches from **Redrawing the area** section.\n4. Click **Area > Add area** button or press the **Ctrl-A**  to add the area to the needle. \n5. If you wish to add another area (the needle can have more areas), just draw a new area and repeat **Step 3** to add it to the needle.\n6. Click the **Needle > Save** (**Ctrl-S**) to save the needle permanently.\n\n### Working with areas\n\n#### Add an area to the needle\n\nIn order to have an area on the needle, you have to add it to it:\n\n1. Press the **Area > Add area** button (**Ctrl-A**) to add the area to the needle. \n2. Repeat for another area.\n\nYou can see the number of areas in the field in the lower right part of the window.\n\n#### Removing an active area\n\nWhen your area is still active (that means that you have not added a new area yet), it can be removed\nfrom the needle again:\n\n1. Click on the **Area > Remove area** button (**Ctrl-R**) to remove it from the needle. \n\nWhen removing the area from the needle, the active area falls back to the previous area \n(which becomes active) and the rectangle will show its current position. You can repeat the action, until all areas are deleted.\n\nIf, however, you need to remove an area added earlier but you do not want to remove the later areas, you need to save the needle first, then reload it, which puts you to the earliest area and makes it active. Then you can move to later areas using **Area > Go to next area** (**Ctrl-G**).\n\n#### Showing next area\n\nWhen the needle has more than one area (you can see the number in the lower right part of the\nprogram window), only the first area is shown. To see the next area:\n\n1. Click on the **Area > Go to next area** (**Ctrl-G**). \n\nThis will show the next area in the needle and makes it active. You can update the area or remove it.\n\n**Warning**: In this version, you cannot navigate in areas. You only can move to the next ones.\nHowever, if you remove the area from the needle, the editor will fall back to the previous area and \nmake it active again so you can update or remove it.\n\nIf you need to change the first area without removing the next area, use the following workaround:\n\n1. Save the needle (**Ctrl-S**).\n2. Load the needle (**Ctrl-L**).\n3. Now, the editor makes the very first area active and you can modify it (**Ctrl-M**).\n4. Move to the next area (**Ctrl-G**) to modify it.\n5. Repeat until you have modified required areas.\n6. Save the needle (**Ctrl-S**).\n\n#### Taking screenshots from a VM\n\nIf you do not have any screenshot to be used as a needle, you can create one by taking a screenshot from an existing and running virtual machine:\n\n1. Click on the **vMachine > Connect a VM** to open a dialogue to connect to a running VM. Now, the application will be able to take screenshots from that virtual machine. When you need to connect to a different VM, repeate this step.\n2. When the application is connected to a VM (indicated in the lower right part), you can take a screenshot any time using **vMachine > Take screenshot** (**Ctrl-T**). The screenshot will be saved as `screenshot.png` and displayed in the application.\n3. In order to protect the screenshot from being overwritten with another press of the key shortcut, type in the tag name, and use the **File > Set name from tag** (**Ctrl-X**) to rename the *png* file.\n\n**Note:** To have this functionality, you have to have `libvirt`, `virsh`, and `ImageMagick` installed. \n\n**Warning:** If your virtual machine does not run in user space, it might not be visible by the application. There are several ways to fix it: \n\n1. In `virt-manager` add a new, user related, connection to libvirt. Click **File > Add connection** and then choose **QEMU/KVM user relation** as the hypervisor. Now, any VM created under this connection will be available to be used in the application. (recommended) \n2. Fix the rights of the user to be able to manipulate the system VMs via `virsh` (out of scope of this document)\n3. Run the editor with `sudo` (not-recommended).\n\n## Reporting a problem\n\nIf you experience a problem, open an issue. Or help with the development. Yup, it is opensource!\n',
    'author': 'Lukáš Růžička',
    'author_email': 'lruzicka@redhat.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
