"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const backend_1 = require("./backend");
const backend_dashboard_1 = require("./backend-dashboard");
const inventory_1 = require("./backend/inventory");
const orchestration_1 = require("./backend/orchestration");
const constants_1 = require("./backend/shared/constants");
const repository_1 = require("./codeartifact/repository");
const monitoring_1 = require("./monitoring");
const webapp_1 = require("./webapp");
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
class ConstructHub extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        const monitoring = new monitoring_1.Monitoring(this, 'Monitoring', {
            alarmActions: props.alarmActions,
            dashboardName: (_b = props.dashboardName) !== null && _b !== void 0 ? _b : 'construct-hub',
        });
        const packageData = new s3.Bucket(this, 'PackageData', {
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            enforceSSL: true,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                // Abort multi-part uploads after 1 day
                { abortIncompleteMultipartUploadAfter: core_1.Duration.days(1) },
                // Transition non-current object versions to IA after 1 month
                { noncurrentVersionTransitions: [{ storageClass: s3.StorageClass.INFREQUENT_ACCESS, transitionAfter: core_1.Duration.days(31) }] },
                // Permanently delete non-current object versions after 3 months
                { noncurrentVersionExpiration: core_1.Duration.days(90), expiredObjectDeleteMarker: true },
                // Permanently delete non-current versions of catalog.json earlier
                { noncurrentVersionExpiration: core_1.Duration.days(7), prefix: constants_1.CATALOG_KEY },
            ],
            versioned: true,
        });
        const codeArtifact = new repository_1.Repository(this, 'CodeArtifact', { description: 'Proxy to npmjs.com for ConstructHub' });
        const vpc = ((_c = props.isolateLambdas) !== null && _c !== void 0 ? _c : true)
            ? new ec2.Vpc(this, 'VPC', {
                enableDnsHostnames: true,
                enableDnsSupport: true,
                natGateways: 0,
                subnetConfiguration: [{ name: 'Isolated', subnetType: ec2.SubnetType.ISOLATED }],
            })
            : undefined;
        const vpcEndpoints = vpc && {
            codeArtifactApi: vpc.addInterfaceEndpoint('CodeArtifact.API', {
                privateDnsEnabled: false,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.api'),
                subnets: { subnetType: ec2.SubnetType.ISOLATED },
            }),
            codeArtifact: vpc.addInterfaceEndpoint('CodeArtifact', {
                privateDnsEnabled: true,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.repositories'),
                subnets: { subnetType: ec2.SubnetType.ISOLATED },
            }),
            s3: vpc.addGatewayEndpoint('S3', {
                service: ec2.GatewayVpcEndpointAwsService.S3,
                subnets: [{ subnetType: ec2.SubnetType.ISOLATED }],
            }),
        };
        // The S3 access is necessary for the CodeArtifact VPC endpoint to be used.
        vpcEndpoints === null || vpcEndpoints === void 0 ? void 0 : vpcEndpoints.s3.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['s3:GetObject'],
            resources: [`${codeArtifact.s3BucketArn}/*`],
            principals: [new aws_iam_1.AnyPrincipal()],
            sid: 'Allow-CodeArtifact-Bucket',
        }));
        const orchestration = new orchestration_1.Orchestration(this, 'Orchestration', {
            bucket: packageData,
            codeArtifact,
            monitoring,
            vpc,
            vpcEndpoints,
        });
        this.ingestion = new backend_1.Ingestion(this, 'Ingestion', { bucket: packageData, orchestration, monitoring });
        const discovery = new backend_1.Discovery(this, 'Discovery', { queue: this.ingestion.queue, monitoring });
        discovery.bucket.grantRead(this.ingestion);
        const inventory = new inventory_1.Inventory(this, 'InventoryCanary', { bucket: packageData, monitoring });
        new backend_dashboard_1.BackendDashboard(this, 'BackendDashboard', { discovery, ingestion: this.ingestion, inventory, orchestration });
        new webapp_1.WebApp(this, 'WebApp', {
            domain: props.domain,
            monitoring,
            packageData,
        });
    }
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal() {
        return this.ingestion.grantPrincipal;
    }
    /**
     * @experimental
     */
    get ingestionQueue() {
        return this.ingestion.queue;
    }
}
exports.ConstructHub = ConstructHub;
_a = JSII_RTTI_SYMBOL_1;
ConstructHub[_a] = { fqn: "construct-hub.ConstructHub", version: "0.1.103" };
//# sourceMappingURL=data:application/json;base64,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