"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reset = exports.stepFunctions = exports.sqs = exports.s3ObjectExists = exports.s3 = void 0;
const AWS = require("aws-sdk");
let _s3;
let _sqs;
let _sfn;
function s3() {
    if (_s3 == null) {
        _s3 = new AWS.S3();
    }
    return _s3;
}
exports.s3 = s3;
/**
 * Checks whether an object exists in S3 at the provided bucket and key.
 */
function s3ObjectExists(bucket, key) {
    return s3().headObject({
        Bucket: bucket,
        Key: key,
    }).promise()
        .then(() => true, (cause) => {
        if (cause.code === 'NotFound') {
            return false;
        }
        return Promise.reject(cause);
    });
}
exports.s3ObjectExists = s3ObjectExists;
function sqs() {
    if (_sqs == null) {
        _sqs = new AWS.SQS();
    }
    return _sqs;
}
exports.sqs = sqs;
function stepFunctions() {
    if (_sfn == null) {
        _sfn = new AWS.StepFunctions();
    }
    return _sfn;
}
exports.stepFunctions = stepFunctions;
/**
 * Resets all clients vended by this module. This is useful in unit tests when
 * `aws-sdk-mocks` is used, so that new mocks are injected as intended.
 */
function reset() {
    _s3 = _sqs = _sfn = undefined;
}
exports.reset = reset;
//# sourceMappingURL=data:application/json;base64,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