var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __export = (target, all) => {
  __markAsModule(target);
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && key !== "default")
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toModule = (module2) => {
  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", module2 && module2.__esModule && "default" in module2 ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
};

// src/backend/orchestration/reprocess-all.lambda.ts
__export(exports, {
  handler: () => handler
});

// src/backend/shared/aws.lambda-shared.ts
var AWS = __toModule(require("aws-sdk"));
var _s3;
var _sfn;
function s3() {
  if (_s3 == null) {
    _s3 = new AWS.S3();
  }
  return _s3;
}
function s3ObjectExists(bucket, key) {
  return s3().headObject({
    Bucket: bucket,
    Key: key
  }).promise().then(() => true, (cause) => {
    if (cause.code === "NotFound") {
      return false;
    }
    return Promise.reject(cause);
  });
}
function stepFunctions() {
  if (_sfn == null) {
    _sfn = new AWS.StepFunctions();
  }
  return _sfn;
}

// src/backend/shared/language.ts
var _DocumentationLanguage = class {
  constructor(lang) {
    this.lang = lang;
  }
  static fromString(lang) {
    switch (lang) {
      case _DocumentationLanguage.TYPESCRIPT.toString():
        return _DocumentationLanguage.TYPESCRIPT;
      case _DocumentationLanguage.PYTHON.toString():
        return _DocumentationLanguage.PYTHON;
      default:
        throw new UnsupportedLanguageError(lang, [_DocumentationLanguage.TYPESCRIPT, _DocumentationLanguage.PYTHON]);
    }
  }
  toString() {
    return this.lang;
  }
};
var DocumentationLanguage = _DocumentationLanguage;
DocumentationLanguage.TYPESCRIPT = new _DocumentationLanguage("typescript");
DocumentationLanguage.PYTHON = new _DocumentationLanguage("python");
var UnsupportedLanguageError = class extends Error {
  constructor(lang, supported) {
    super(`Unsupported language: ${lang}. Supported languages are: [${supported}]`);
  }
};

// src/backend/shared/constants.ts
var STORAGE_KEY_PREFIX = "data/";
var PACKAGE_KEY_SUFFIX = "/package.tgz";
var METADATA_KEY_SUFFIX = "/metadata.json";
var ASSEMBLY_KEY_SUFFIX = "/assembly.json";
var DOCS_KEY_SUFFIX_TYPESCRIPT = docsKeySuffix(DocumentationLanguage.TYPESCRIPT);
var DOCS_KEY_SUFFIX_PYTHON = docsKeySuffix(DocumentationLanguage.PYTHON);
var DOCS_KEY_SUFFIX_ANY = docsKeySuffix("*");
function docsKeySuffix(lang, submodule) {
  return `/docs-${submodule ? `${submodule}-` : ""}${lang}.md`;
}
var STORAGE_KEY_FORMAT_REGEX = new RegExp(`^${STORAGE_KEY_PREFIX}((?:@[^/]+/)?[^/]+)/v([^/]+)/.*$`);
var ELIGIBLE_LICENSES = new Set([
  "Apache-1.0",
  "Apache-1.1",
  "Apache-2.0",
  "0BSD",
  "BSD-1-Clause",
  "BSD-2-Clause",
  "BSD-2-Clause-Patent",
  "BSD-2-Clause-Views",
  "BSD-3-Clause",
  "BSD-3-Clause-Attribution",
  "BSD-3-Clause-Clear",
  "BSD-3-Clause-LBNL",
  "BSD-3-Clause-Modification",
  "BSD-3-Clause-No-Military-License",
  "BSD-3-Clause-No-Nuclear-License",
  "BSD-3-Clause-No-Nuclear-License-2014",
  "BSD-3-Clause-No-Nuclear-Warranty",
  "BSD-3-Clause-Open-MPI",
  "BSD-4-Clause",
  "BSD-4-Clause-Shortened",
  "BSD-4-Clause-UC",
  "BSD-Protection",
  "BSD-Source-Code",
  "MIT",
  "MIT-0",
  "MIT-advertising",
  "MIT-CMU",
  "MIT-enna",
  "MIT-feh",
  "MIT-Modern-Variant",
  "MIT-open-group",
  "MITNFA"
].map((s) => s.toUpperCase()));

// src/backend/shared/env.lambda-shared.ts
var import_process = __toModule(require("process"));
function requireEnv(name) {
  const result = import_process.env[name];
  if (!result) {
    throw new Error(`No value specified for required environment variable: ${name}`);
  }
  return result;
}

// src/backend/orchestration/reprocess-all.lambda.ts
async function handler(event, _context) {
  console.log(`Event: ${JSON.stringify(event, null, 2)}`);
  const bucketName = requireEnv("BUCKET_NAME");
  const stateMachineArn = requireEnv("STATE_MACHINE_ARN");
  for await (const input of listIndexedPackages(bucketName)) {
    console.log(`Input payload: ${JSON.stringify(input, null, 2)}`);
    const { executionArn } = await stepFunctions().startExecution({
      input: JSON.stringify(input),
      stateMachineArn
    }).promise();
    console.log(`Started execution: ${executionArn}`);
  }
}
var scopedPrefix = `${STORAGE_KEY_PREFIX}@`;
async function* listIndexedPackages(bucketName) {
  var _a;
  const request = {
    Bucket: bucketName,
    Delimiter: "/",
    Prefix: STORAGE_KEY_PREFIX
  };
  do {
    const response = await s3().listObjectsV2(request).promise();
    request.ContinuationToken = response.NextContinuationToken;
    for (const { Prefix: prefix } of (_a = response.CommonPrefixes) != null ? _a : []) {
      if (prefix == null ? void 0 : prefix.startsWith(scopedPrefix)) {
        yield* listScopedPackages(bucketName, prefix);
      } else if (prefix == null ? void 0 : prefix.endsWith("/")) {
        yield* listPackageVersions(bucketName, prefix);
      }
    }
  } while (request.ContinuationToken != null);
}
async function* listScopedPackages(bucketName, prefix) {
  var _a;
  const request = {
    Bucket: bucketName,
    Delimiter: "/",
    Prefix: prefix
  };
  do {
    const response = await s3().listObjectsV2(request).promise();
    request.ContinuationToken = response.NextContinuationToken;
    for (const { Prefix: packagePrefix } of (_a = response.CommonPrefixes) != null ? _a : []) {
      if (packagePrefix == null ? void 0 : packagePrefix.endsWith("/")) {
        yield* listPackageVersions(bucketName, packagePrefix);
      }
    }
  } while (request.ContinuationToken != null);
}
async function* listPackageVersions(bucketName, prefix) {
  var _a;
  const request = {
    Bucket: bucketName,
    Delimiter: "/",
    Prefix: prefix
  };
  do {
    const response = await s3().listObjectsV2(request).promise();
    request.ContinuationToken = response.NextContinuationToken;
    for (let { Prefix: packageVersion } of (_a = response.CommonPrefixes) != null ? _a : []) {
      if (packageVersion == null ? void 0 : packageVersion.endsWith("/")) {
        packageVersion = packageVersion.substring(0, packageVersion.length - 1);
        const assemblyKey = `${packageVersion}${ASSEMBLY_KEY_SUFFIX}`;
        const metadataKey = `${packageVersion}${METADATA_KEY_SUFFIX}`;
        const packageKey = `${packageVersion}${PACKAGE_KEY_SUFFIX}`;
        const foundResult = await Promise.all([
          await s3ObjectExists(bucketName, assemblyKey),
          await s3ObjectExists(bucketName, metadataKey),
          await s3ObjectExists(bucketName, packageKey)
        ]);
        const allFound = foundResult.every((found) => found);
        if (allFound) {
          const sfnInput = {
            bucket: bucketName,
            assembly: { key: assemblyKey },
            metadata: { key: metadataKey },
            package: { key: packageKey }
          };
          yield sfnInput;
        }
      }
    }
  } while (request.ContinuationToken != null);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
